/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.selector;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocument;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.selector.UndefinedExpressionSelectorPopoverImpl;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.selector.UndefinedExpressionSelectorPopoverView;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class UndefinedExpressionSelectorPopoverImplTest {
    @Mock
    private UndefinedExpressionSelectorPopoverView view;
    @Mock
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    private ExpressionEditorDefinition undefinedExpressionEditorDefinition;
    @Mock
    private ExpressionEditorDefinition literalExpressionEditorDefinition;
    @Mock
    private ExpressionEditorDefinition literalExpressionPMMLEditorDefinition;
    @Mock
    private UndefinedExpressionGrid undefinedExpressionGrid;
    @Mock
    private TranslationService translationService;
    @Captor
    private ArgumentCaptor<List<ExpressionEditorDefinition>> expressionDefinitionsCaptor;
    private LiteralExpression literalExpression = new LiteralExpression();
    private LiteralExpressionPMMLDocument literalExpressionPMMLDocument = new LiteralExpressionPMMLDocument();
    private UndefinedExpressionSelectorPopoverView.Presenter popover;

    @Before
    public void setup() {
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)this.undefinedExpressionEditorDefinition);
        expressionEditorDefinitions.add((Object)this.literalExpressionEditorDefinition);
        expressionEditorDefinitions.add((Object)this.literalExpressionPMMLEditorDefinition);
        Mockito.when((Object)this.undefinedExpressionEditorDefinition.getModelClass()).thenReturn(Optional.empty());
        Mockito.when((Object)this.literalExpressionEditorDefinition.isUserSelectable()).thenReturn((Object)true);
        Mockito.when((Object)this.literalExpressionEditorDefinition.getType()).thenReturn((Object)ExpressionType.LITERAL_EXPRESSION);
        Mockito.when((Object)this.literalExpressionEditorDefinition.getName()).thenReturn((Object)LiteralExpression.class.getSimpleName());
        Mockito.when((Object)this.literalExpressionEditorDefinition.getModelClass()).thenReturn(Optional.of(this.literalExpression));
        Mockito.when((Object)this.literalExpressionPMMLEditorDefinition.isUserSelectable()).thenReturn((Object)false);
        Mockito.when((Object)this.literalExpressionPMMLEditorDefinition.getType()).thenReturn((Object)ExpressionType.LITERAL_EXPRESSION);
        Mockito.when((Object)this.literalExpressionPMMLEditorDefinition.getName()).thenReturn((Object)LiteralExpressionPMMLDocument.class.getSimpleName());
        Mockito.when((Object)this.literalExpressionPMMLEditorDefinition.getModelClass()).thenReturn(Optional.of(this.literalExpressionPMMLDocument));
        Mockito.when((Object)this.expressionEditorDefinitionsSupplier.get()).thenReturn((Object)expressionEditorDefinitions);
        Mockito.when((Object)this.translationService.getTranslation(Matchers.anyString())).thenAnswer(i -> i.getArguments()[0]);
        this.popover = new UndefinedExpressionSelectorPopoverImpl(this.view, this.translationService, this.expressionEditorDefinitionsSupplier);
    }

    @Test
    public void testInitialisation() {
        ((UndefinedExpressionSelectorPopoverView)Mockito.verify((Object)this.view)).setExpressionEditorDefinitions((List)this.expressionDefinitionsCaptor.capture());
        List expressionDefinitions = (List)this.expressionDefinitionsCaptor.getValue();
        Assertions.assertThat((List)expressionDefinitions).hasSize(1);
        Assertions.assertThat((List)expressionDefinitions).containsOnly((Object[])new ExpressionEditorDefinition[]{this.literalExpressionEditorDefinition});
    }

    @Test
    public void testShowWhenBound() {
        this.popover.bind((Object)this.undefinedExpressionGrid, 0, 0);
        this.popover.show();
        ((UndefinedExpressionSelectorPopoverView)Mockito.verify((Object)this.view)).show((Optional)Matchers.eq(Optional.ofNullable(this.popover.getPopoverTitle())));
    }

    @Test
    public void testShowWhenNotBound() {
        this.popover.show();
        ((UndefinedExpressionSelectorPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).show((Optional)Matchers.any(Optional.class));
    }

    @Test
    public void testHideWhenBound() {
        this.popover.bind((Object)this.undefinedExpressionGrid, 0, 0);
        this.popover.hide();
        ((UndefinedExpressionSelectorPopoverView)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testHideWhenNotBound() {
        this.popover.hide();
        ((UndefinedExpressionSelectorPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide();
    }

    @Test
    public void testOnExpressionEditorDefinitionSelectedWhenBound() {
        this.popover.bind((Object)this.undefinedExpressionGrid, 0, 0);
        this.popover.onExpressionEditorDefinitionSelected(this.literalExpressionEditorDefinition);
        ((UndefinedExpressionGrid)Mockito.verify((Object)this.undefinedExpressionGrid)).onExpressionTypeChanged((ExpressionType)Matchers.eq((Object)ExpressionType.LITERAL_EXPRESSION));
        ((UndefinedExpressionSelectorPopoverView)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testOnExpressionEditorDefinitionSelectedWhenNotBound() {
        this.popover.onExpressionEditorDefinitionSelected(this.literalExpressionEditorDefinition);
        ((UndefinedExpressionGrid)Mockito.verify((Object)this.undefinedExpressionGrid, (VerificationMode)Mockito.never())).onExpressionTypeChanged((ExpressionType)Matchers.any(ExpressionType.class));
        ((UndefinedExpressionSelectorPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide();
    }
}

