/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included;

import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessages;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPage;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPagePresenter;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPageState;
import org.kie.workbench.common.dmn.client.editors.included.common.IncludedModelsPageStateProvider;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={RootPanel.class})
public class IncludedModelsPageTest {
    @Mock
    private HTMLDivElement pageView;
    @Mock
    private TranslationService translationService;
    @Mock
    private FlashMessages flashMessages;
    @Mock
    private IncludedModelsPagePresenter includedModelsPresenter;
    @Mock
    private IncludedModelsPageState pageState;
    @Mock
    private IncludedModelsPageStateProvider stateProvider;
    private IncludedModelsPage page;

    @Before
    public void setup() {
        this.page = (IncludedModelsPage)Mockito.spy((Object)new IncludedModelsPage(this.pageView, this.translationService, this.flashMessages, this.includedModelsPresenter, this.pageState, this.stateProvider){

            protected void setupPageCSSClass(String cssClass) {
            }
        });
    }

    @Test
    public void testOnFocus() {
        HTMLElement flashMessagesElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement includedModelsPresenterElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Element currentElement = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)this.flashMessages.getElement()).thenReturn((Object)flashMessagesElement);
        Mockito.when((Object)this.includedModelsPresenter.getElement()).thenReturn((Object)includedModelsPresenterElement);
        this.pageView.firstChild = currentElement;
        Mockito.when((Object)this.pageView.removeChild((Node)currentElement)).then(a -> {
            this.pageView.firstChild = null;
            return currentElement;
        });
        this.page.onFocus();
        ((HTMLDivElement)Mockito.verify((Object)this.pageView)).removeChild((Node)currentElement);
        ((HTMLDivElement)Mockito.verify((Object)this.pageView)).appendChild((Node)flashMessagesElement);
        ((HTMLDivElement)Mockito.verify((Object)this.pageView)).appendChild((Node)includedModelsPresenterElement);
    }

    @Test
    public void testOnLostFocus() {
        this.page.onLostFocus();
        ((FlashMessages)Mockito.verify((Object)this.flashMessages)).hideMessages();
    }

    @Test
    public void testSetup() {
        this.page.reload();
        ((IncludedModelsPageState)Mockito.verify((Object)this.pageState)).init(this.stateProvider);
        ((IncludedModelsPagePresenter)Mockito.verify((Object)this.includedModelsPresenter)).refresh();
    }
}

