/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.editors.included.BaseIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsFactory;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsPageStateProviderImpl;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class IncludedModelsPageStateProviderImplTest {
    @Mock
    private DMNGraphUtils dmnGraphUtils;
    @Mock
    private IncludedModelsFactory factory;
    @Mock
    private DMNDiagramsSession dmnDiagramsSession;
    @Mock
    private Diagram diagram;
    private IncludedModelsPageStateProviderImpl stateProvider;

    @Before
    public void setup() {
        PowerMockito.when((Object)this.dmnDiagramsSession.getDRGDiagram()).thenReturn((Object)this.diagram);
        this.stateProvider = (IncludedModelsPageStateProviderImpl)Mockito.spy((Object)new IncludedModelsPageStateProviderImpl(this.dmnGraphUtils, this.factory, this.dmnDiagramsSession));
    }

    @Test
    public void testGenerateIncludedModels() {
        List<Import> imports = Arrays.asList((Import)Mockito.mock(Import.class), (Import)Mockito.mock(Import.class));
        List<BaseIncludedModelActiveRecord> expectedIncludedModels = Arrays.asList((BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class), (BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class));
        PowerMockito.when((Object)this.factory.makeIncludedModels(imports)).thenReturn(expectedIncludedModels);
        ((IncludedModelsPageStateProviderImpl)Mockito.doReturn(imports).when((Object)this.stateProvider)).getImports();
        List actualIncludedModels = this.stateProvider.generateIncludedModels();
        Assert.assertEquals(expectedIncludedModels, (Object)actualIncludedModels);
    }

    @Test
    public void testGetImportsWhenDiagramIsPresent() {
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        List<Import> expectedImports = Arrays.asList((Import)Mockito.mock(Import.class), (Import)Mockito.mock(Import.class));
        PowerMockito.when((Object)this.dmnGraphUtils.getDefinitions(this.diagram)).thenReturn((Object)definitions);
        PowerMockito.when((Object)definitions.getImport()).thenReturn(expectedImports);
        List actualImports = this.stateProvider.getImports();
        Assert.assertEquals(expectedImports, (Object)actualImports);
    }

    @Test
    public void testGetImportsWhenDiagramIsNotPresent() {
        PowerMockito.when((Object)this.dmnDiagramsSession.getDRGDiagram()).thenReturn(null);
        List actualImports = this.stateProvider.getImports();
        List expectedImports = Collections.emptyList();
        Assert.assertEquals(expectedImports, (Object)actualImports);
    }

    @Test
    public void testGetCurrentDiagramNamespace() {
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        String expectedNamespace = "://namespace";
        PowerMockito.when((Object)this.dmnGraphUtils.getDefinitions(this.diagram)).thenReturn((Object)definitions);
        PowerMockito.when((Object)definitions.getNamespace()).thenReturn((Object)new Text("://namespace"));
        String actualNamespace = this.stateProvider.getCurrentDiagramNamespace();
        Assert.assertEquals((Object)"://namespace", (Object)actualNamespace);
    }
}

