/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports.persistence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocument;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocumentModel;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.PMMLIncludedModelHandler;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.ExpressionGridCache;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class PMMLIncludedModelHandlerTest {
    private static final String NODE1_UUID = "uuid1";
    private static final String NODE2_UUID = "uuid2";
    private static final String NODE3_UUID = "uuid3";
    private static final String DOCUMENT_NAME_ORIGINAL = "document-original";
    private static final String DOCUMENT_NAME_UPDATED = "document-updated";
    private static final String MODEL_NAME = "model";
    private static final String UNAFFECTED_DOCUMENT = "unaffected-document";
    private static final String UNAFFECTED_MODEL = "unaffected-model";
    @Mock
    private DMNGraphUtils dmnGraphUtils;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private DMNSession dmnSession;
    @Mock
    private ExpressionGridCache expressionGridCache;
    @Mock
    private BaseExpressionGrid expressionGrid1;
    @Mock
    private BaseExpressionGrid expressionGrid2;
    @Mock
    private BaseExpressionGrid expressionGrid3;
    private PMMLIncludedModelHandler handler;

    @Before
    public void setup() {
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.dmnSession);
        Mockito.when((Object)this.dmnSession.getExpressionGridCache()).thenReturn((Object)this.expressionGridCache);
        Mockito.when((Object)this.expressionGridCache.getExpressionGrid(Matchers.anyString())).thenReturn(Optional.empty());
        Mockito.when((Object)this.expressionGridCache.getExpressionGrid((String)Matchers.eq((Object)NODE1_UUID))).thenReturn(Optional.of(this.expressionGrid1));
        Mockito.when((Object)this.expressionGridCache.getExpressionGrid((String)Matchers.eq((Object)NODE2_UUID))).thenReturn(Optional.of(this.expressionGrid2));
        Mockito.when((Object)this.expressionGridCache.getExpressionGrid((String)Matchers.eq((Object)NODE3_UUID))).thenReturn(Optional.of(this.expressionGrid3));
        this.handler = new PMMLIncludedModelHandler(this.dmnGraphUtils, this.sessionManager);
    }

    @Test
    public void testUpdateDecisionWithTopLevelFunction() {
        List<Decision> decisions = this.setupDecisionWithTopLevelFunction();
        this.handler.update(DOCUMENT_NAME_ORIGINAL, DOCUMENT_NAME_UPDATED);
        this.assertTopLevelLiteralExpression(decisions.get(0));
        this.assertTopLevelFunctionDefinition(decisions.get(1), DOCUMENT_NAME_UPDATED, MODEL_NAME);
        this.assertTopLevelFunctionDefinition(decisions.get(2), UNAFFECTED_DOCUMENT, UNAFFECTED_MODEL);
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid1)).initialiseUiCells();
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid2)).initialiseUiCells();
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid3)).initialiseUiCells();
    }

    @Test
    public void testUpdateDecisionWithNestedFunction() {
        List<Decision> decisions = this.setupDecisionWithNestedFunction();
        this.handler.update(DOCUMENT_NAME_ORIGINAL, DOCUMENT_NAME_UPDATED);
        this.assertNestedLiteralExpression(decisions.get(0));
        this.assertNestedFunctionDefinition(decisions.get(1), DOCUMENT_NAME_UPDATED, MODEL_NAME);
        this.assertNestedFunctionDefinition(decisions.get(2), UNAFFECTED_DOCUMENT, UNAFFECTED_MODEL);
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid1, (VerificationMode)Mockito.never())).initialiseUiCells();
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid2, (VerificationMode)Mockito.never())).initialiseUiCells();
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid3, (VerificationMode)Mockito.never())).initialiseUiCells();
    }

    @Test
    public void testUpdateBusinessKnowledgeModelWithTopLevelFunction() {
        List<BusinessKnowledgeModel> bkms = this.setupBusinessKnowledgeModelWithTopLevelFunction();
        this.handler.update(DOCUMENT_NAME_ORIGINAL, DOCUMENT_NAME_UPDATED);
        this.assertTopLevelLiteralExpression(bkms.get(0));
        this.assertPMMLContextDefinition(bkms.get(1).getEncapsulatedLogic(), DOCUMENT_NAME_UPDATED, MODEL_NAME);
        this.assertPMMLContextDefinition(bkms.get(2).getEncapsulatedLogic(), UNAFFECTED_DOCUMENT, UNAFFECTED_MODEL);
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid1)).initialiseUiCells();
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid2)).initialiseUiCells();
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid3)).initialiseUiCells();
    }

    @Test
    public void testUpdateBusinessKnowledgeModelWithNestedFunction() {
        List<BusinessKnowledgeModel> bkms = this.setupBusinessKnowledgeModelWithNestedFunction();
        this.handler.update(DOCUMENT_NAME_ORIGINAL, DOCUMENT_NAME_UPDATED);
        this.assertNestedLiteralExpression(bkms.get(0));
        this.assertNestedFunctionDefinition(bkms.get(1), DOCUMENT_NAME_UPDATED, MODEL_NAME);
        this.assertNestedFunctionDefinition(bkms.get(2), UNAFFECTED_DOCUMENT, UNAFFECTED_MODEL);
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid1, (VerificationMode)Mockito.never())).initialiseUiCells();
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid2, (VerificationMode)Mockito.never())).initialiseUiCells();
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid3, (VerificationMode)Mockito.never())).initialiseUiCells();
    }

    @Test
    public void testDestroyDecisionWithTopLevelFunction() {
        List<Decision> decisions = this.setupDecisionWithTopLevelFunction();
        this.handler.destroy(DOCUMENT_NAME_ORIGINAL);
        this.assertTopLevelLiteralExpression(decisions.get(0));
        this.assertTopLevelFunctionDefinition(decisions.get(1), "", "");
        this.assertTopLevelFunctionDefinition(decisions.get(2), UNAFFECTED_DOCUMENT, UNAFFECTED_MODEL);
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid1)).initialiseUiCells();
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid2)).initialiseUiCells();
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid3)).initialiseUiCells();
    }

    @Test
    public void testDestroyDecisionWithNestedFunction() {
        List<Decision> decisions = this.setupDecisionWithNestedFunction();
        this.handler.destroy(DOCUMENT_NAME_ORIGINAL);
        this.assertNestedLiteralExpression(decisions.get(0));
        this.assertNestedFunctionDefinition(decisions.get(1), "", "");
        this.assertNestedFunctionDefinition(decisions.get(2), UNAFFECTED_DOCUMENT, UNAFFECTED_MODEL);
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid1, (VerificationMode)Mockito.never())).initialiseUiCells();
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid2, (VerificationMode)Mockito.never())).initialiseUiCells();
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid3, (VerificationMode)Mockito.never())).initialiseUiCells();
    }

    @Test
    public void testDestroyBusinessKnowledgeModelWithTopLevelFunction() {
        List<BusinessKnowledgeModel> bkms = this.setupBusinessKnowledgeModelWithTopLevelFunction();
        this.handler.destroy(DOCUMENT_NAME_ORIGINAL);
        this.assertTopLevelLiteralExpression(bkms.get(0));
        this.assertPMMLContextDefinition(bkms.get(1).getEncapsulatedLogic(), "", "");
        this.assertPMMLContextDefinition(bkms.get(2).getEncapsulatedLogic(), UNAFFECTED_DOCUMENT, UNAFFECTED_MODEL);
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid1)).initialiseUiCells();
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid2)).initialiseUiCells();
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid3)).initialiseUiCells();
    }

    @Test
    public void testDestroyBusinessKnowledgeModelWithNestedFunction() {
        List<BusinessKnowledgeModel> bkms = this.setupBusinessKnowledgeModelWithNestedFunction();
        this.handler.destroy(DOCUMENT_NAME_ORIGINAL);
        this.assertNestedLiteralExpression(bkms.get(0));
        this.assertNestedFunctionDefinition(bkms.get(1), "", "");
        this.assertNestedFunctionDefinition(bkms.get(2), UNAFFECTED_DOCUMENT, UNAFFECTED_MODEL);
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid1, (VerificationMode)Mockito.never())).initialiseUiCells();
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid2, (VerificationMode)Mockito.never())).initialiseUiCells();
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid3, (VerificationMode)Mockito.never())).initialiseUiCells();
    }

    private List<Decision> setupDecisionWithTopLevelFunction() {
        ArrayList<Decision> drgElements = new ArrayList<Decision>();
        Decision decision1 = new Decision();
        decision1.setExpression((Expression)new LiteralExpression());
        Decision decision2 = new Decision();
        decision2.setExpression((Expression)this.makeTopLevelPMMLFunctionDefinition(DOCUMENT_NAME_ORIGINAL, MODEL_NAME));
        Decision decision3 = new Decision();
        decision3.setExpression((Expression)this.makeTopLevelPMMLFunctionDefinition(UNAFFECTED_DOCUMENT, UNAFFECTED_MODEL));
        decision1.getId().setValue(NODE1_UUID);
        decision2.getId().setValue(NODE2_UUID);
        decision3.getId().setValue(NODE3_UUID);
        drgElements.add(decision1);
        drgElements.add(decision2);
        drgElements.add(decision3);
        Mockito.when((Object)this.dmnGraphUtils.getModelDRGElements()).thenReturn(drgElements);
        return Arrays.asList(decision1, decision2, decision3);
    }

    private List<Decision> setupDecisionWithNestedFunction() {
        ArrayList<Decision> drgElements = new ArrayList<Decision>();
        Decision decision1 = new Decision();
        decision1.setExpression((Expression)this.makeNestedLiteralExpression());
        Decision decision2 = new Decision();
        decision2.setExpression((Expression)this.makeNestedPMMLFunctionDefinition(DOCUMENT_NAME_ORIGINAL, MODEL_NAME));
        Decision decision3 = new Decision();
        decision3.setExpression((Expression)this.makeNestedPMMLFunctionDefinition(UNAFFECTED_DOCUMENT, UNAFFECTED_MODEL));
        drgElements.add(decision1);
        drgElements.add(decision2);
        drgElements.add(decision3);
        Mockito.when((Object)this.dmnGraphUtils.getModelDRGElements()).thenReturn(drgElements);
        return Arrays.asList(decision1, decision2, decision3);
    }

    private List<BusinessKnowledgeModel> setupBusinessKnowledgeModelWithTopLevelFunction() {
        ArrayList<BusinessKnowledgeModel> drgElements = new ArrayList<BusinessKnowledgeModel>();
        BusinessKnowledgeModel bkm1 = new BusinessKnowledgeModel();
        FunctionDefinition bkm1Function = new FunctionDefinition();
        bkm1Function.setKind(FunctionDefinition.Kind.FEEL);
        bkm1Function.setExpression((Expression)new LiteralExpression());
        bkm1.setEncapsulatedLogic(bkm1Function);
        BusinessKnowledgeModel bkm2 = new BusinessKnowledgeModel();
        bkm2.setEncapsulatedLogic(this.makeTopLevelPMMLFunctionDefinition(DOCUMENT_NAME_ORIGINAL, MODEL_NAME));
        BusinessKnowledgeModel bkm3 = new BusinessKnowledgeModel();
        bkm3.setEncapsulatedLogic(this.makeTopLevelPMMLFunctionDefinition(UNAFFECTED_DOCUMENT, UNAFFECTED_MODEL));
        bkm1.getId().setValue(NODE1_UUID);
        bkm2.getId().setValue(NODE2_UUID);
        bkm3.getId().setValue(NODE3_UUID);
        drgElements.add(bkm1);
        drgElements.add(bkm2);
        drgElements.add(bkm3);
        Mockito.when((Object)this.dmnGraphUtils.getModelDRGElements()).thenReturn(drgElements);
        return Arrays.asList(bkm1, bkm2, bkm3);
    }

    private List<BusinessKnowledgeModel> setupBusinessKnowledgeModelWithNestedFunction() {
        ArrayList<BusinessKnowledgeModel> drgElements = new ArrayList<BusinessKnowledgeModel>();
        BusinessKnowledgeModel bkm1 = new BusinessKnowledgeModel();
        FunctionDefinition bkm1Function = new FunctionDefinition();
        bkm1Function.setKind(FunctionDefinition.Kind.FEEL);
        bkm1Function.setExpression((Expression)this.makeNestedLiteralExpression());
        bkm1.setEncapsulatedLogic(bkm1Function);
        BusinessKnowledgeModel bkm2 = new BusinessKnowledgeModel();
        FunctionDefinition bkm2Function = new FunctionDefinition();
        bkm2Function.setKind(FunctionDefinition.Kind.FEEL);
        bkm2Function.setExpression((Expression)this.makeNestedPMMLFunctionDefinition(DOCUMENT_NAME_ORIGINAL, MODEL_NAME));
        bkm2.setEncapsulatedLogic(bkm2Function);
        BusinessKnowledgeModel bkm3 = new BusinessKnowledgeModel();
        FunctionDefinition bkm3Function = new FunctionDefinition();
        bkm3Function.setKind(FunctionDefinition.Kind.FEEL);
        bkm3Function.setExpression((Expression)this.makeNestedPMMLFunctionDefinition(UNAFFECTED_DOCUMENT, UNAFFECTED_MODEL));
        bkm3.setEncapsulatedLogic(bkm3Function);
        drgElements.add(bkm1);
        drgElements.add(bkm2);
        drgElements.add(bkm3);
        Mockito.when((Object)this.dmnGraphUtils.getModelDRGElements()).thenReturn(drgElements);
        return Arrays.asList(bkm1, bkm2, bkm3);
    }

    private Context makeNestedLiteralExpression() {
        Context context = new Context();
        ContextEntry contextEntry = new ContextEntry();
        InformationItem variable = new InformationItem();
        variable.getName().setValue("variable");
        contextEntry.setVariable(variable);
        contextEntry.setExpression((Expression)new LiteralExpression());
        context.getContextEntry().add(contextEntry);
        return context;
    }

    private Context makeNestedPMMLFunctionDefinition(String documentName, String modelName) {
        Context context = new Context();
        ContextEntry contextEntry = new ContextEntry();
        InformationItem variable = new InformationItem();
        variable.getName().setValue("variable");
        contextEntry.setVariable(variable);
        contextEntry.setExpression((Expression)this.makeTopLevelPMMLFunctionDefinition(documentName, modelName));
        context.getContextEntry().add(contextEntry);
        return context;
    }

    private FunctionDefinition makeTopLevelPMMLFunctionDefinition(String documentName, String modelName) {
        FunctionDefinition function = new FunctionDefinition();
        function.setKind(FunctionDefinition.Kind.PMML);
        Context functionExpression = new Context();
        function.setExpression((Expression)functionExpression);
        ContextEntry functionContextEntry1 = new ContextEntry();
        InformationItem functionContextEntry1Variable = new InformationItem();
        LiteralExpressionPMMLDocument functionContextEntry1Value = new LiteralExpressionPMMLDocument();
        functionContextEntry1Variable.getName().setValue("document");
        functionContextEntry1.setVariable(functionContextEntry1Variable);
        functionContextEntry1Value.getText().setValue("\"" + documentName + "\"");
        functionContextEntry1.setExpression((Expression)functionContextEntry1Value);
        ContextEntry functionContextEntry2 = new ContextEntry();
        InformationItem functionContextEntry2Variable = new InformationItem();
        LiteralExpressionPMMLDocumentModel functionContextEntry2Value = new LiteralExpressionPMMLDocumentModel();
        functionContextEntry2Variable.getName().setValue(MODEL_NAME);
        functionContextEntry2.setVariable(functionContextEntry2Variable);
        functionContextEntry2Value.getText().setValue("\"" + modelName + "\"");
        functionContextEntry2.setExpression((Expression)functionContextEntry2Value);
        functionExpression.getContextEntry().add(functionContextEntry1);
        functionExpression.getContextEntry().add(functionContextEntry2);
        return function;
    }

    private void assertTopLevelLiteralExpression(Decision decision) {
        Assertions.assertThat((Object)decision.getExpression()).isInstanceOf(LiteralExpression.class);
        Assertions.assertThat((String)((LiteralExpression)decision.getExpression()).getText().getValue()).isEmpty();
    }

    private void assertTopLevelLiteralExpression(BusinessKnowledgeModel bkm) {
        FunctionDefinition function = bkm.getEncapsulatedLogic();
        Assertions.assertThat((Object)function.getExpression()).isInstanceOf(LiteralExpression.class);
        Assertions.assertThat((String)((LiteralExpression)function.getExpression()).getText().getValue()).isEmpty();
    }

    private void assertNestedLiteralExpression(Decision decision) {
        Assertions.assertThat((Object)decision.getExpression()).isInstanceOf(Context.class);
        Context context = (Context)decision.getExpression();
        Assertions.assertThat((List)context.getContextEntry()).hasSize(1);
        ContextEntry contextEntry = (ContextEntry)context.getContextEntry().get(0);
        Assertions.assertThat((Object)contextEntry.getExpression()).isInstanceOf(LiteralExpression.class);
        Assertions.assertThat((String)((LiteralExpression)contextEntry.getExpression()).getText().getValue()).isEmpty();
    }

    private void assertNestedLiteralExpression(BusinessKnowledgeModel bkm) {
        FunctionDefinition function = bkm.getEncapsulatedLogic();
        Assertions.assertThat((Object)function.getExpression()).isInstanceOf(Context.class);
        Context context = (Context)function.getExpression();
        Assertions.assertThat((List)context.getContextEntry()).hasSize(1);
        ContextEntry contextEntry = (ContextEntry)context.getContextEntry().get(0);
        Assertions.assertThat((Object)contextEntry.getExpression()).isInstanceOf(LiteralExpression.class);
        Assertions.assertThat((String)((LiteralExpression)contextEntry.getExpression()).getText().getValue()).isEmpty();
    }

    private void assertTopLevelFunctionDefinition(Decision decision, String expectedDocumentValue, String expectedModelValue) {
        Assertions.assertThat((Object)decision.getExpression()).isInstanceOf(FunctionDefinition.class);
        this.assertPMMLContextDefinition((FunctionDefinition)decision.getExpression(), expectedDocumentValue, expectedModelValue);
    }

    private void assertNestedFunctionDefinition(Decision decision, String expectedDocumentValue, String expectedModelValue) {
        Assertions.assertThat((Object)decision.getExpression()).isInstanceOf(Context.class);
        Context context = (Context)decision.getExpression();
        Assertions.assertThat((List)context.getContextEntry()).hasSize(1);
        ContextEntry contextEntry = (ContextEntry)context.getContextEntry().get(0);
        Assertions.assertThat((Object)contextEntry.getExpression()).isInstanceOf(FunctionDefinition.class);
        this.assertPMMLContextDefinition((FunctionDefinition)contextEntry.getExpression(), expectedDocumentValue, expectedModelValue);
    }

    private void assertNestedFunctionDefinition(BusinessKnowledgeModel bkm, String expectedDocumentValue, String expectedModelValue) {
        FunctionDefinition function = bkm.getEncapsulatedLogic();
        Assertions.assertThat((Object)function.getExpression()).isInstanceOf(Context.class);
        Context context = (Context)function.getExpression();
        Assertions.assertThat((List)context.getContextEntry()).hasSize(1);
        ContextEntry contextEntry = (ContextEntry)context.getContextEntry().get(0);
        Assertions.assertThat((Object)contextEntry.getExpression()).isInstanceOf(FunctionDefinition.class);
        this.assertPMMLContextDefinition((FunctionDefinition)contextEntry.getExpression(), expectedDocumentValue, expectedModelValue);
    }

    private void assertPMMLContextDefinition(FunctionDefinition function, String expectedDocumentValue, String expectedModelValue) {
        Assertions.assertThat((Object)function.getExpression()).isInstanceOf(Context.class);
        Context context = (Context)function.getExpression();
        Assertions.assertThat((Object)((ContextEntry)context.getContextEntry().get(0)).getExpression()).isInstanceOf(LiteralExpressionPMMLDocument.class);
        LiteralExpressionPMMLDocument functionDocument = (LiteralExpressionPMMLDocument)((ContextEntry)context.getContextEntry().get(0)).getExpression();
        Assertions.assertThat((String)functionDocument.getText().getValue()).isEqualTo(this.wrap(expectedDocumentValue));
        Assertions.assertThat((Object)((ContextEntry)context.getContextEntry().get(1)).getExpression()).isInstanceOf(LiteralExpressionPMMLDocumentModel.class);
        LiteralExpressionPMMLDocumentModel functionDocumentModel = (LiteralExpressionPMMLDocumentModel)((ContextEntry)context.getContextEntry().get(1)).getExpression();
        Assertions.assertThat((String)functionDocumentModel.getText().getValue()).isEqualTo(this.wrap(expectedModelValue));
    }

    private String wrap(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return value;
        }
        return StringUtils.createQuotedString((String)value);
    }
}

