/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.modal;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.Node;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.included.modal.IncludedModelModal;
import org.kie.workbench.common.dmn.client.editors.included.modal.IncludedModelModalView;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class IncludedModelModalViewTest {
    @Mock
    private HTMLDivElement header;
    @Mock
    private HTMLDivElement body;
    @Mock
    private HTMLDivElement footer;
    @Mock
    private HTMLDivElement dropdown;
    @Mock
    private HTMLInputElement modelNameInput;
    @Mock
    private HTMLButtonElement includeButton;
    @Mock
    private HTMLButtonElement cancelButton;
    @Mock
    private IncludedModelModal presenter;
    private IncludedModelModalView view;

    @Before
    public void setup() {
        this.view = new IncludedModelModalView(this.header, this.body, this.footer, this.dropdown, this.modelNameInput, this.includeButton, this.cancelButton);
        this.view.init(this.presenter);
    }

    @Test
    public void testInitialize() {
        this.modelNameInput.value = "something";
        this.view.initialize();
        Assert.assertEquals((Object)"", (Object)this.modelNameInput.value);
    }

    @Test
    public void testGetHeader() {
        String expectedHeader = "expectedHeader";
        this.header.textContent = "expectedHeader";
        String actualHeader = this.view.getHeader();
        Assert.assertEquals((Object)"expectedHeader", (Object)actualHeader);
    }

    @Test
    public void testGetBody() {
        Assert.assertEquals((Object)this.body, (Object)this.view.getBody());
    }

    @Test
    public void testGetFooter() {
        Assert.assertEquals((Object)this.footer, (Object)this.view.getFooter());
    }

    @Test
    public void testGetModelNameInput() {
        String expected = "name";
        this.modelNameInput.value = "name";
        String actual = this.view.getModelNameInput();
        Assert.assertEquals((Object)"name", (Object)actual);
    }

    @Test
    public void testSetupAssetsDropdown() {
        HTMLElement dropdownElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        this.view.setupAssetsDropdown(dropdownElement);
        ((HTMLDivElement)Mockito.verify((Object)this.dropdown)).appendChild((Node)dropdownElement);
    }

    @Test
    public void testDisableIncludeButton() {
        this.includeButton.disabled = false;
        this.view.disableIncludeButton();
        Assert.assertTrue((boolean)this.includeButton.disabled);
    }

    @Test
    public void testEnableIncludeButton() {
        this.includeButton.disabled = true;
        this.view.enableIncludeButton();
        Assert.assertFalse((boolean)this.includeButton.disabled);
    }

    @Test
    public void testOnModelNameInputChanged() {
        this.view.onModelNameInputChanged((KeyUpEvent)Mockito.mock(KeyUpEvent.class));
        ((IncludedModelModal)Mockito.verify((Object)this.presenter)).onValueChanged();
    }

    @Test
    public void testOnIncludeButtonClick() {
        this.view.onIncludeButtonClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((IncludedModelModal)Mockito.verify((Object)this.presenter)).include();
    }

    @Test
    public void testOnCancelButtonClick() {
        this.view.onCancelButtonClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((IncludedModelModal)Mockito.verify((Object)this.presenter)).hide();
    }
}

