/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.common.errors;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.errors.DataTypeNameIsDefaultTypeMessage;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeNameIsDefaultTypeMessageTest {
    @Mock
    private TranslationService translationService;

    @Test
    public void testGetStrongMessage() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String expectedErrorMessage = "*Expected strong message.*";
        DataTypeNameIsDefaultTypeMessage errorMessage = new DataTypeNameIsDefaultTypeMessage(this.translationService);
        Mockito.when((Object)this.translationService.format("DataTypeNameIsDefaultTypeMessage.StrongMessage", new Object[0])).thenReturn((Object)"*Expected strong message.*");
        String actualErrorMessage = errorMessage.getStrongMessage(dataType);
        Assert.assertEquals((Object)"*Expected strong message.*", (Object)actualErrorMessage);
    }

    @Test
    public void testGetRegularMessage() {
        String expectedErrorMessage = "Expected regular message.";
        DataTypeNameIsDefaultTypeMessage errorMessage = new DataTypeNameIsDefaultTypeMessage(this.translationService);
        Mockito.when((Object)this.translationService.format("DataTypeNameIsDefaultTypeMessage.RegularMessage", new Object[0])).thenReturn((Object)"Expected regular message.");
        String actualErrorMessage = errorMessage.getRegularMessage();
        Assert.assertEquals((Object)"Expected regular message.", (Object)actualErrorMessage);
    }
}

