/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import elemental2.dom.NodeList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeUtils;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListHighlightHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeListHighlightHelperTest {
    @Mock
    private DataTypeList dataTypeList;
    @Mock
    private DataTypeUtils dataTypeUtils;
    private DataTypeListHighlightHelper helper;

    @Before
    public void setup() {
        this.helper = (DataTypeListHighlightHelper)Mockito.spy((Object)new DataTypeListHighlightHelper(this.dataTypeUtils));
        this.helper.init(this.dataTypeList);
    }

    @Test
    public void testHighlight() {
        Element element = (Element)Mockito.mock(Element.class);
        element.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DataTypeListHighlightHelper)Mockito.doNothing().when((Object)this.helper)).cleanHighlightClass();
        this.helper.highlight(element);
        ((DataTypeListHighlightHelper)Mockito.verify((Object)this.helper)).cleanHighlightClass();
        ((DOMTokenList)Mockito.verify((Object)element.classList)).add(new String[]{"key-highlight"});
    }

    @Test
    public void testGetDataTypeListItemWhenListItemIsPresent() {
        String uuid1 = "uuid1";
        String uuid2 = "uuid2";
        String uuid3 = "uuid3";
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem3 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataType dataType3 = (DataType)Mockito.mock(DataType.class);
        List<DataTypeListItem> listItems = Arrays.asList(listItem1, listItem2, listItem3);
        Mockito.when((Object)this.dataTypeList.getItems()).thenReturn(listItems);
        Mockito.when((Object)listItem1.getDataType()).thenReturn((Object)dataType1);
        Mockito.when((Object)listItem2.getDataType()).thenReturn((Object)dataType2);
        Mockito.when((Object)listItem3.getDataType()).thenReturn((Object)dataType3);
        Mockito.when((Object)dataType1.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)dataType2.getUUID()).thenReturn((Object)"uuid2");
        Mockito.when((Object)dataType3.getUUID()).thenReturn((Object)"uuid3");
        Optional dataTypeListItem = this.helper.getDataTypeListItem("uuid2");
        Assert.assertTrue((boolean)dataTypeListItem.isPresent());
        Assert.assertEquals((Object)listItem2, dataTypeListItem.get());
    }

    @Test
    public void testGetDataTypeListItemWhenListItemIsNotPresent() {
        String uuid1 = "uuid1";
        String uuid2 = "uuid2";
        String uuid3 = "uuid3";
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem3 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataType dataType3 = (DataType)Mockito.mock(DataType.class);
        List<DataTypeListItem> listItems = Arrays.asList(listItem1, listItem2, listItem3);
        Mockito.when((Object)this.dataTypeList.getItems()).thenReturn(listItems);
        Mockito.when((Object)listItem1.getDataType()).thenReturn((Object)dataType1);
        Mockito.when((Object)listItem2.getDataType()).thenReturn((Object)dataType2);
        Mockito.when((Object)listItem3.getDataType()).thenReturn((Object)dataType3);
        Mockito.when((Object)dataType1.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)dataType2.getUUID()).thenReturn((Object)"uuid2");
        Mockito.when((Object)dataType3.getUUID()).thenReturn((Object)"uuid3");
        Optional dataTypeListItem = this.helper.getDataTypeListItem("1234");
        Assert.assertFalse((boolean)dataTypeListItem.isPresent());
    }

    @Test
    public void testHighlightLevel() {
        DataTypeListItem personListItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem personNameListItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem parsonAgeListItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType personDataType = (DataType)Mockito.mock(DataType.class);
        DataType personNameDataType = (DataType)Mockito.mock(DataType.class);
        DataType parsonAgeDataType = (DataType)Mockito.mock(DataType.class);
        String personUUID = "0000";
        String personNameUUID = "1111";
        String parsonAgeUUID = "2222";
        HTMLElement personElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement personNameElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement parsonAgeElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        ((DataTypeListHighlightHelper)Mockito.doReturn(Optional.of(personListItem)).when((Object)this.helper)).getDataTypeListItem("0000");
        ((DataTypeListHighlightHelper)Mockito.doReturn(Optional.of(personNameListItem)).when((Object)this.helper)).getDataTypeListItem("1111");
        ((DataTypeListHighlightHelper)Mockito.doReturn(Optional.of(parsonAgeListItem)).when((Object)this.helper)).getDataTypeListItem("2222");
        ((DataTypeListHighlightHelper)Mockito.doNothing().when((Object)this.helper)).cleanLevelHighlightClass();
        ((DataTypeListHighlightHelper)Mockito.doNothing().when((Object)this.helper)).appendBackgroundLine((DataType)Matchers.any(), (HTMLElement)Matchers.any());
        personElement.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        personNameElement.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        parsonAgeElement.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)personElement.getAttribute("data-row-uuid")).thenReturn((Object)"0000");
        Mockito.when((Object)personNameElement.getAttribute("data-row-uuid")).thenReturn((Object)"1111");
        Mockito.when((Object)parsonAgeElement.getAttribute("data-row-uuid")).thenReturn((Object)"2222");
        Mockito.when((Object)personDataType.getUUID()).thenReturn((Object)"0000");
        Mockito.when((Object)personNameDataType.getUUID()).thenReturn((Object)"1111");
        Mockito.when((Object)parsonAgeDataType.getUUID()).thenReturn((Object)"2222");
        Mockito.when((Object)personDataType.isTopLevel()).thenReturn((Object)true);
        Mockito.when((Object)personNameDataType.isTopLevel()).thenReturn((Object)false);
        Mockito.when((Object)parsonAgeDataType.isTopLevel()).thenReturn((Object)false);
        Mockito.when((Object)personListItem.getDataType()).thenReturn((Object)personDataType);
        Mockito.when((Object)personNameListItem.getDataType()).thenReturn((Object)personNameDataType);
        Mockito.when((Object)parsonAgeListItem.getDataType()).thenReturn((Object)parsonAgeDataType);
        Mockito.when((Object)personListItem.getDragAndDropElement()).thenReturn((Object)personElement);
        Mockito.when((Object)personNameListItem.getDragAndDropElement()).thenReturn((Object)personNameElement);
        Mockito.when((Object)parsonAgeListItem.getDragAndDropElement()).thenReturn((Object)parsonAgeElement);
        Mockito.when((Object)personDataType.getSubDataTypes()).thenReturn(Arrays.asList(personNameDataType, parsonAgeDataType));
        Mockito.when((Object)this.dataTypeUtils.getTopLevelParent(personNameDataType)).thenReturn((Object)personDataType);
        this.helper.highlightLevel((Element)personNameElement);
        ((DataTypeListHighlightHelper)Mockito.verify((Object)this.helper)).cleanLevelHighlightClass();
        ((DataTypeListHighlightHelper)Mockito.verify((Object)this.helper, (VerificationMode)Mockito.times((int)1))).appendBackgroundLine(personDataType, personElement);
        ((DOMTokenList)Mockito.verify((Object)personElement.classList)).add(new String[]{"kie-level-highlight"});
        ((DOMTokenList)Mockito.verify((Object)personNameElement.classList)).add(new String[]{"kie-level-highlight"});
        ((DOMTokenList)Mockito.verify((Object)parsonAgeElement.classList)).add(new String[]{"kie-level-highlight"});
    }

    @Test
    public void testHighlightLevelWhenDataTypeListIsNull() {
        this.helper.init(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.helper.highlightLevel((Element)Mockito.mock(HTMLElement.class))).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("DataTypeListHighlightHelper error 'dataTypeList' must be initialized.");
    }

    @Test
    public void testCleanHighlightClass() {
        Element element1 = (Element)Mockito.mock(Element.class);
        Element element2 = (Element)Mockito.mock(Element.class);
        NodeList elements = (NodeList)Mockito.spy((Object)new NodeList());
        element1.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        element2.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        elements.length = 2;
        ((NodeList)Mockito.doReturn((Object)element1).when((Object)elements)).getAt(0);
        ((NodeList)Mockito.doReturn((Object)element2).when((Object)elements)).getAt(1);
        ((DataTypeListHighlightHelper)Mockito.doReturn((Object)elements).when((Object)this.helper)).querySelectorAll(".key-highlight");
        this.helper.cleanHighlightClass();
        ((DOMTokenList)Mockito.verify((Object)element1.classList)).remove(new String[]{"key-highlight"});
        ((DOMTokenList)Mockito.verify((Object)element2.classList)).remove(new String[]{"key-highlight"});
    }

    @Test
    public void testCleanLevelHighlightClass() {
        Element element1 = (Element)Mockito.mock(Element.class);
        Element element2 = (Element)Mockito.mock(Element.class);
        Element backgroundLine1 = (Element)Mockito.mock(Element.class);
        Element backgroundLine2 = (Element)Mockito.mock(Element.class);
        Node parentNode = (Node)Mockito.mock(Node.class);
        NodeList highlightedElements = (NodeList)Mockito.spy((Object)new NodeList());
        NodeList backgroundLines = (NodeList)Mockito.spy((Object)new NodeList());
        element1.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        element2.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        backgroundLine1.parentNode = parentNode;
        backgroundLine2.parentNode = parentNode;
        highlightedElements.length = 2;
        backgroundLines.length = 2;
        ((NodeList)Mockito.doReturn((Object)element1).when((Object)highlightedElements)).getAt(0);
        ((NodeList)Mockito.doReturn((Object)element2).when((Object)highlightedElements)).getAt(1);
        ((NodeList)Mockito.doReturn((Object)backgroundLine1).when((Object)backgroundLines)).getAt(0);
        ((NodeList)Mockito.doReturn((Object)backgroundLine2).when((Object)backgroundLines)).getAt(1);
        ((DataTypeListHighlightHelper)Mockito.doReturn((Object)highlightedElements).when((Object)this.helper)).querySelectorAll(".kie-level-highlight");
        ((DataTypeListHighlightHelper)Mockito.doReturn((Object)backgroundLines).when((Object)this.helper)).querySelectorAll(".kie-level-background-line");
        this.helper.cleanLevelHighlightClass();
        ((DOMTokenList)Mockito.verify((Object)element1.classList)).remove(new String[]{"kie-level-highlight"});
        ((DOMTokenList)Mockito.verify((Object)element2.classList)).remove(new String[]{"kie-level-highlight"});
        ((Node)Mockito.verify((Object)parentNode)).removeChild((Node)backgroundLine1);
        ((Node)Mockito.verify((Object)parentNode)).removeChild((Node)backgroundLine2);
    }

    @Test
    public void testAppendBackgroundLine() {
        DataType person = (DataType)Mockito.mock(DataType.class);
        DataType personAge = (DataType)Mockito.mock(DataType.class);
        DataType personName = (DataType)Mockito.mock(DataType.class);
        DataType personAddress = (DataType)Mockito.mock(DataType.class);
        String personUUID = "0000";
        String personAgeUUID = "1111";
        String personNameUUID = "2222";
        String personAddressUUID = "3333";
        String personAddressStreetUUID = "4444";
        DataType personAddressStreet = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem personItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem personAgeItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem personNameItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem personAddressItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem personAddressStreetItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        Element backgroundLine = (Element)Mockito.mock(Element.class);
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        NodeList nodeList = new NodeList();
        backgroundLine.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        element.offsetHeight = 70;
        nodeList.length = 3;
        ((DataTypeListHighlightHelper)Mockito.doReturn((Object)backgroundLine).when((Object)this.helper)).createElement("div");
        ((DataTypeListHighlightHelper)Mockito.doReturn((Object)nodeList).when((Object)this.helper)).querySelectorAll(".kie-dnd-current-dragging");
        ((DataTypeListHighlightHelper)Mockito.doReturn(Optional.of(personItem)).when((Object)this.helper)).getDataTypeListItem("0000");
        ((DataTypeListHighlightHelper)Mockito.doReturn(Optional.of(personAgeItem)).when((Object)this.helper)).getDataTypeListItem("1111");
        ((DataTypeListHighlightHelper)Mockito.doReturn(Optional.of(personNameItem)).when((Object)this.helper)).getDataTypeListItem("2222");
        ((DataTypeListHighlightHelper)Mockito.doReturn(Optional.of(personAddressItem)).when((Object)this.helper)).getDataTypeListItem("3333");
        ((DataTypeListHighlightHelper)Mockito.doReturn(Optional.of(personAddressStreetItem)).when((Object)this.helper)).getDataTypeListItem("4444");
        Mockito.when((Object)person.getUUID()).thenReturn((Object)"0000");
        Mockito.when((Object)personAge.getUUID()).thenReturn((Object)"1111");
        Mockito.when((Object)personName.getUUID()).thenReturn((Object)"2222");
        Mockito.when((Object)personAddress.getUUID()).thenReturn((Object)"3333");
        Mockito.when((Object)personAddressStreet.getUUID()).thenReturn((Object)"4444");
        Mockito.when((Object)personItem.isCollapsed()).thenReturn((Object)false);
        Mockito.when((Object)personAgeItem.isCollapsed()).thenReturn((Object)false);
        Mockito.when((Object)personNameItem.isCollapsed()).thenReturn((Object)false);
        Mockito.when((Object)personAddressItem.isCollapsed()).thenReturn((Object)true);
        Mockito.when((Object)personAddressStreetItem.isCollapsed()).thenReturn((Object)false);
        Mockito.when((Object)person.getSubDataTypes()).thenReturn(Arrays.asList(personAge, personName, personAddress));
        Mockito.when((Object)personAddress.getSubDataTypes()).thenReturn(Collections.singletonList(personAddressStreet));
        this.helper.appendBackgroundLine(person, element);
        ((DOMTokenList)Mockito.verify((Object)backgroundLine.classList)).add(new String[]{"kie-level-background-line"});
        ((HTMLElement)Mockito.verify((Object)element)).appendChild((Node)backgroundLine);
        ((Element)Mockito.verify((Object)backgroundLine)).setAttribute("style", "height: 490px");
    }

    @Test
    public void testHasBackgroundLineWhenItReturnsTrue() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement line = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)element.querySelector(".kie-level-background-line")).thenReturn((Object)line);
        Assert.assertTrue((boolean)this.helper.hasBackgroundLine(element));
    }

    @Test
    public void testHasBackgroundLineWhenItReturnsFalse() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        Assert.assertFalse((boolean)this.helper.hasBackgroundLine(element));
    }
}

