/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.text.DateFormatSymbols;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.DateValueFormatter;

@RunWith(value=GwtMockitoTestRunner.class)
public class DateValueFormatterTest {
    private DateValueFormatter dateValueFormatter;
    private String[] localizedShortMonths;

    @Before
    public void setup() {
        this.dateValueFormatter = new DateValueFormatter();
        this.localizedShortMonths = new DateFormatSymbols().getShortMonths();
    }

    @Test
    public void testToDisplayNull() {
        this.testToDisplay(null, "");
    }

    @Test
    public void testToDisplayInvalidDateString() {
        this.testToDisplay("someInvalidDate", "");
    }

    @Test
    public void testToDisplayValidDates() {
        this.testToDisplay("date(\"2019-1-1\")", "01 " + this.localizedShortMonths[0] + " 2019");
        this.testToDisplay("date(\"2019-6-2\")", "02 " + this.localizedShortMonths[5] + " 2019");
        this.testToDisplay("date(\"2019-12-31\")", "31 " + this.localizedShortMonths[11] + " 2019");
    }

    @Test
    public void testToDisplayValidDateTwoDigitsMonthAndDay() {
        this.testToDisplay("date(\"2019-02-01\")", "01 " + this.localizedShortMonths[1] + " 2019");
    }

    @Test
    public void testToRawValidDates() {
        String input = "28 " + this.localizedShortMonths[1] + " 2019";
        this.testToRaw(input, this.addPrefixAndSuffix("2019-02-28"));
        input = "31 " + this.localizedShortMonths[11] + " 2019";
        this.testToRaw(input, this.addPrefixAndSuffix("2019-12-31"));
        input = "1 " + this.localizedShortMonths[0] + " 2019";
        this.testToRaw(input, this.addPrefixAndSuffix("2019-01-01"));
    }

    @Test
    public void testToRawInvalidValue() {
        this.testToRaw("randomString", "");
    }

    @Test
    public void testRemovePrefixAndSuffix() {
        String date = "2019-12-25";
        String input = this.addPrefixAndSuffix("2019-12-25");
        String actual = this.dateValueFormatter.removePrefixAndSuffix(input);
        Assert.assertEquals((Object)"2019-12-25", (Object)actual);
    }

    @Test
    public void testRemovePrefixAndSuffixWithSpaces() {
        String date = "   2019-12-25   ";
        String expected = "2019-12-25";
        String input = this.addPrefixAndSuffix("   2019-12-25   ");
        String actual = this.dateValueFormatter.removePrefixAndSuffix(input);
        Assert.assertEquals((Object)"2019-12-25", (Object)actual);
    }

    @Test
    public void testAddPrefixAndSuffix() {
        String input = "2019-12-25";
        String expected = this.addPrefixAndSuffix("2019-12-25");
        String actual = this.dateValueFormatter.addPrefixAndSuffix("2019-12-25");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private String addPrefixAndSuffix(String date) {
        return "date(\"" + date + "\")";
    }

    private void testToRaw(String input, String expected) {
        String actual = this.dateValueFormatter.toRaw(input);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private void testToDisplay(String input, String expected) {
        String actual = this.dateValueFormatter.toDisplay(input);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

