/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.day.time;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.dom.client.BlurEvent;
import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.HTMLInputElement;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.common.MinMaxValueHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.day.time.DayTimeSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.day.time.DayTimeSelectorView;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.day.time.DayTimeValue;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DayTimeSelectorViewTest {
    @Mock
    private HTMLInputElement daysInput;
    @Mock
    private HTMLInputElement hoursInput;
    @Mock
    private HTMLInputElement minutesInput;
    @Mock
    private HTMLInputElement secondsInput;
    @Mock
    private DayTimeSelector presenter;
    @Mock
    private Consumer<Event> consumerEvent;
    @Mock
    private Consumer<BlurEvent> consumerBlurEvent;
    private DayTimeSelectorView view;

    @Before
    public void setup() {
        this.daysInput = (HTMLInputElement)Mockito.spy((Object)new HTMLInputElement());
        this.hoursInput = (HTMLInputElement)Mockito.spy((Object)new HTMLInputElement());
        this.minutesInput = (HTMLInputElement)Mockito.spy((Object)new HTMLInputElement());
        this.secondsInput = (HTMLInputElement)Mockito.spy((Object)new HTMLInputElement());
        this.view = (DayTimeSelectorView)Mockito.spy((Object)new DayTimeSelectorView(this.daysInput, this.hoursInput, this.minutesInput, this.secondsInput));
        this.view.init(this.presenter);
    }

    @Test
    public void testSetupEventHandlers() {
        this.daysInput.value = "2";
        this.hoursInput.value = "4";
        this.minutesInput.value = "8";
        this.secondsInput.value = "16";
        Mockito.when((Object)this.daysInput.getAttribute("data-old")).thenReturn((Object)"getAttribute was invoked");
        Mockito.when((Object)this.hoursInput.getAttribute("data-old")).thenReturn((Object)"getAttribute was invoked");
        Mockito.when((Object)this.minutesInput.getAttribute("data-old")).thenReturn((Object)"getAttribute was invoked");
        Mockito.when((Object)this.secondsInput.getAttribute("data-old")).thenReturn((Object)"getAttribute was invoked");
        ((HTMLInputElement)Mockito.doNothing().when((Object)this.daysInput)).setAttribute("data-old", this.daysInput.value);
        ((HTMLInputElement)Mockito.doNothing().when((Object)this.hoursInput)).setAttribute("data-old", this.hoursInput.value);
        ((HTMLInputElement)Mockito.doNothing().when((Object)this.minutesInput)).setAttribute("data-old", this.minutesInput.value);
        ((HTMLInputElement)Mockito.doNothing().when((Object)this.secondsInput)).setAttribute("data-old", this.secondsInput.value);
        Element.OnchangeFn onChangeHandler = (Element.OnchangeFn)Mockito.mock(Element.OnchangeFn.class);
        ((DayTimeSelectorView)Mockito.doReturn((Object)onChangeHandler).when((Object)this.view)).getOnChangeHandler();
        this.daysInput.onchange = null;
        this.hoursInput.onchange = null;
        this.minutesInput.onchange = null;
        this.secondsInput.onchange = null;
        this.view.setupEventHandlers();
        Assert.assertEquals((Object)this.daysInput.onchange, (Object)onChangeHandler);
        Assert.assertEquals((Object)this.hoursInput.onchange, (Object)onChangeHandler);
        Assert.assertEquals((Object)this.minutesInput.onchange, (Object)onChangeHandler);
        Assert.assertEquals((Object)this.secondsInput.onchange, (Object)onChangeHandler);
        MinMaxValueHelper.setupMinMaxHandlers((HTMLInputElement)this.daysInput);
        this.daysInput.onfocusout.onInvoke(null);
        this.daysInput.onkeydown.onInvoke(null);
        this.daysInput.onkeyup.onInvoke(null);
        ((HTMLInputElement)Mockito.verify((Object)this.daysInput)).setAttribute("data-old", this.daysInput.value);
        ((HTMLInputElement)Mockito.verify((Object)this.daysInput, (VerificationMode)Mockito.times((int)2))).getAttribute("data-old");
        MinMaxValueHelper.setupMinMaxHandlers((HTMLInputElement)this.hoursInput);
        this.hoursInput.onfocusout.onInvoke(null);
        this.hoursInput.onkeydown.onInvoke(null);
        this.hoursInput.onkeyup.onInvoke(null);
        ((HTMLInputElement)Mockito.verify((Object)this.hoursInput)).setAttribute("data-old", this.hoursInput.value);
        ((HTMLInputElement)Mockito.verify((Object)this.hoursInput, (VerificationMode)Mockito.times((int)2))).getAttribute("data-old");
        MinMaxValueHelper.setupMinMaxHandlers((HTMLInputElement)this.minutesInput);
        this.minutesInput.onfocusout.onInvoke(null);
        this.minutesInput.onkeydown.onInvoke(null);
        this.minutesInput.onkeyup.onInvoke(null);
        ((HTMLInputElement)Mockito.verify((Object)this.minutesInput)).setAttribute("data-old", this.minutesInput.value);
        ((HTMLInputElement)Mockito.verify((Object)this.minutesInput, (VerificationMode)Mockito.times((int)2))).getAttribute("data-old");
        MinMaxValueHelper.setupMinMaxHandlers((HTMLInputElement)this.secondsInput);
        this.secondsInput.onfocusout.onInvoke(null);
        this.secondsInput.onkeydown.onInvoke(null);
        this.secondsInput.onkeyup.onInvoke(null);
        ((HTMLInputElement)Mockito.verify((Object)this.secondsInput)).setAttribute("data-old", this.secondsInput.value);
        ((HTMLInputElement)Mockito.verify((Object)this.secondsInput, (VerificationMode)Mockito.times((int)2))).getAttribute("data-old");
    }

    @Test
    public void testGetValue() {
        this.daysInput.value = "2";
        this.hoursInput.value = "4";
        this.minutesInput.value = "8";
        this.secondsInput.value = "16";
        DayTimeValue value = this.view.getValue();
        Assert.assertEquals((Object)value.getDays(), (Object)new Integer(2));
        Assert.assertEquals((Object)value.getHours(), (Object)new Integer(4));
        Assert.assertEquals((Object)value.getMinutes(), (Object)new Integer(8));
        Assert.assertEquals((Object)value.getSeconds(), (Object)new Integer(16));
    }

    @Test
    public void testGetValueWhenValuesAreBlank() {
        this.daysInput.value = "";
        this.hoursInput.value = "";
        this.minutesInput.value = "";
        this.secondsInput.value = "";
        DayTimeValue value = this.view.getValue();
        Assert.assertEquals((Object)value.getDays(), (Object)DayTimeValue.NONE);
        Assert.assertEquals((Object)value.getHours(), (Object)DayTimeValue.NONE);
        Assert.assertEquals((Object)value.getMinutes(), (Object)DayTimeValue.NONE);
        Assert.assertEquals((Object)value.getSeconds(), (Object)DayTimeValue.NONE);
    }

    @Test
    public void testSetValue() {
        this.daysInput.value = "something";
        this.hoursInput.value = "something";
        this.minutesInput.value = "something";
        this.secondsInput.value = "something";
        this.view.setValue(new DayTimeValue(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8), Integer.valueOf(16)));
        Assert.assertEquals((Object)this.daysInput.value, (Object)"2");
        Assert.assertEquals((Object)this.hoursInput.value, (Object)"4");
        Assert.assertEquals((Object)this.minutesInput.value, (Object)"8");
        Assert.assertEquals((Object)this.secondsInput.value, (Object)"16");
    }

    @Test
    public void testSetValueWithZeroValues() {
        this.daysInput.value = "something";
        this.hoursInput.value = "something";
        this.minutesInput.value = "something";
        this.secondsInput.value = "something";
        this.view.setValue(new DayTimeValue());
        Assert.assertEquals((Object)this.daysInput.value, (Object)"");
        Assert.assertEquals((Object)this.hoursInput.value, (Object)"");
        Assert.assertEquals((Object)this.minutesInput.value, (Object)"");
        Assert.assertEquals((Object)this.secondsInput.value, (Object)"");
    }

    @Test
    public void testSetOnValueChanged() {
        Consumer<Event> expected = e -> {};
        this.view.setOnValueChanged(expected);
        Optional actual = this.view.getOnValueChangedConsumer();
        Assert.assertTrue((boolean)actual.isPresent());
        Assert.assertEquals(expected, actual.get());
    }

    @Test
    public void testSetOnValueInputBlur() {
        Consumer<BlurEvent> expected = e -> {};
        this.view.setOnValueInputBlur(expected);
        Optional actual = this.view.getOnValueInputBlurConsumer();
        Assert.assertTrue((boolean)actual.isPresent());
        Assert.assertEquals(expected, actual.get());
    }

    @Test
    public void testOnDaysInputBlurEvent() {
        BlurEvent blurEvent = (BlurEvent)Mockito.mock(BlurEvent.class);
        ((DayTimeSelectorView)Mockito.doNothing().when((Object)this.view)).onBlurHandler((BlurEvent)Matchers.any());
        this.view.onDaysInputBlurEvent(blurEvent);
        ((DayTimeSelectorView)Mockito.verify((Object)this.view)).onBlurHandler(blurEvent);
    }

    @Test
    public void testOnHoursInputBlurEvent() {
        BlurEvent blurEvent = (BlurEvent)Mockito.mock(BlurEvent.class);
        ((DayTimeSelectorView)Mockito.doNothing().when((Object)this.view)).onBlurHandler((BlurEvent)Matchers.any());
        this.view.onHoursInputBlurEvent(blurEvent);
        ((DayTimeSelectorView)Mockito.verify((Object)this.view)).onBlurHandler(blurEvent);
    }

    @Test
    public void testOnMinutesInputBlurEvent() {
        BlurEvent blurEvent = (BlurEvent)Mockito.mock(BlurEvent.class);
        ((DayTimeSelectorView)Mockito.doNothing().when((Object)this.view)).onBlurHandler((BlurEvent)Matchers.any());
        this.view.onMinutesInputBlurEvent(blurEvent);
        ((DayTimeSelectorView)Mockito.verify((Object)this.view)).onBlurHandler(blurEvent);
    }

    @Test
    public void testOnSecondsInputBlurEvent() {
        BlurEvent blurEvent = (BlurEvent)Mockito.mock(BlurEvent.class);
        ((DayTimeSelectorView)Mockito.doNothing().when((Object)this.view)).onBlurHandler((BlurEvent)Matchers.any());
        this.view.onSecondsInputBlurEvent(blurEvent);
        ((DayTimeSelectorView)Mockito.verify((Object)this.view)).onBlurHandler(blurEvent);
    }

    @Test
    public void testSelect() {
        this.view.select();
        ((HTMLInputElement)Mockito.verify((Object)this.daysInput)).select();
    }

    @Test
    public void testGetOnChangeHandler() {
        Event event = (Event)Mockito.mock(Event.class);
        Optional<Consumer<Event>> optionalConsumer = Optional.of(this.consumerEvent);
        ((DayTimeSelectorView)Mockito.doReturn(optionalConsumer).when((Object)this.view)).getOnValueChangedConsumer();
        this.view.getOnChangeHandler().onInvoke(event);
        ((Consumer)Mockito.verify(this.consumerEvent)).accept(event);
    }

    @Test
    public void testOnBlurHandlerWhenTargetIsNotDayTimeInput() {
        BlurEvent blurEvent = (BlurEvent)Mockito.mock(BlurEvent.class);
        Object target = Mockito.mock(Object.class);
        Optional<Consumer<BlurEvent>> optionalConsumer = Optional.of(this.consumerBlurEvent);
        ((DayTimeSelectorView)Mockito.doReturn(optionalConsumer).when((Object)this.view)).getOnValueInputBlurConsumer();
        ((DayTimeSelectorView)Mockito.doReturn((Object)target).when((Object)this.view)).getEventTarget(blurEvent);
        this.view.onBlurHandler(blurEvent);
        ((Consumer)Mockito.verify(this.consumerBlurEvent)).accept(blurEvent);
    }

    @Test
    public void testOnBlurHandlerWhenTargetIsDayTimeInput() {
        BlurEvent blurEvent = (BlurEvent)Mockito.mock(BlurEvent.class);
        Optional<Consumer<BlurEvent>> optionalConsumer = Optional.of(this.consumerBlurEvent);
        ((DayTimeSelectorView)Mockito.doReturn(optionalConsumer).when((Object)this.view)).getOnValueInputBlurConsumer();
        ((DayTimeSelectorView)Mockito.doReturn((Object)this.daysInput).when((Object)this.view)).getEventTarget(blurEvent);
        this.view.onBlurHandler(blurEvent);
        ((Consumer)Mockito.verify(this.consumerBlurEvent, (VerificationMode)Mockito.never())).accept(blurEvent);
    }
}

