/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence.handlers;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.ConstraintType;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.definition.model.UnaryTests;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.client.editors.types.DataTypeChangedEvent;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.ItemDefinitionUpdateHandler;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.common.PropertiesPanelNotifier;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ItemDefinitionUpdateHandlerTest {
    @Mock
    private DataTypeManager dataTypeManager;
    @Mock
    private DMNGraphUtils dmnGraphUtils;
    @Mock
    private ItemDefinitionUtils itemDefinitionUtils;
    @Mock
    private PropertiesPanelNotifier panelNotifier;
    @Mock
    private EventSourceMock<DataTypeChangedEvent> dataTypeChangedEvent;
    private ItemDefinitionUpdateHandler handler;

    @Before
    public void setup() {
        this.itemDefinitionUtils = (ItemDefinitionUtils)Mockito.spy((Object)new ItemDefinitionUtils(this.dmnGraphUtils));
        this.handler = (ItemDefinitionUpdateHandler)Mockito.spy((Object)new ItemDefinitionUpdateHandler(this.dataTypeManager, this.itemDefinitionUtils, this.panelNotifier, this.dataTypeChangedEvent));
    }

    @Test
    public void testUpdateWhenDataTypeIsStructure() {
        String structure = "Structure";
        String oldNameValue = "name";
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Name name = (Name)Mockito.mock(Name.class);
        Name oldName = (Name)Mockito.mock(Name.class);
        QName newQName = (QName)Mockito.mock(QName.class);
        Mockito.when((Object)dataType.getType()).thenReturn((Object)"Structure");
        Mockito.when((Object)this.dataTypeManager.structure()).thenReturn((Object)"Structure");
        Mockito.when((Object)itemDefinition.getName()).thenReturn((Object)oldName);
        Mockito.when((Object)oldName.getValue()).thenReturn((Object)"name");
        Mockito.when((Object)this.panelNotifier.withOldLocalPart("name")).thenReturn((Object)this.panelNotifier);
        Mockito.when((Object)this.panelNotifier.withNewQName(newQName)).thenReturn((Object)this.panelNotifier);
        ((ItemDefinitionUpdateHandler)Mockito.doReturn((Object)name).when((Object)this.handler)).makeName(dataType);
        ((ItemDefinitionUpdateHandler)Mockito.doReturn((Object)newQName).when((Object)this.handler)).makeQName(itemDefinition);
        this.handler.update(dataType, itemDefinition);
        ((ItemDefinition)Mockito.verify((Object)itemDefinition)).setTypeRef(null);
        ((ItemDefinition)Mockito.verify((Object)itemDefinition)).setName(name);
        ((PropertiesPanelNotifier)Mockito.verify((Object)this.panelNotifier)).notifyPanel();
        ((EventSourceMock)Mockito.verify(this.dataTypeChangedEvent)).fire(Matchers.any());
    }

    @Test
    public void testUpdateWhenDataTypeIsNotStructure() {
        String structure = "Structure";
        String type = "type";
        String oldNameValue = "name";
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        QName qName = (QName)Mockito.mock(QName.class);
        Name name = (Name)Mockito.mock(Name.class);
        Name oldName = (Name)Mockito.mock(Name.class);
        QName newQName = (QName)Mockito.mock(QName.class);
        ArrayList<ItemDefinition> itemDefinitions = new ArrayList<ItemDefinition>(){
            {
                this.add(Mockito.mock(ItemDefinition.class));
            }
        };
        Mockito.when((Object)dataType.getType()).thenReturn((Object)"type");
        Mockito.when((Object)this.dataTypeManager.structure()).thenReturn((Object)"Structure");
        Mockito.when((Object)itemDefinition.getItemComponent()).thenReturn((Object)itemDefinitions);
        Mockito.when((Object)itemDefinition.getName()).thenReturn((Object)oldName);
        Mockito.when((Object)oldName.getValue()).thenReturn((Object)"name");
        Mockito.when((Object)this.panelNotifier.withOldLocalPart("name")).thenReturn((Object)this.panelNotifier);
        Mockito.when((Object)this.panelNotifier.withNewQName(newQName)).thenReturn((Object)this.panelNotifier);
        ((ItemDefinitionUpdateHandler)Mockito.doReturn((Object)newQName).when((Object)this.handler)).makeQName(itemDefinition);
        ((ItemDefinitionUpdateHandler)Mockito.doReturn((Object)qName).when((Object)this.handler)).makeQName(dataType);
        ((ItemDefinitionUpdateHandler)Mockito.doReturn((Object)name).when((Object)this.handler)).makeName(dataType);
        this.handler.update(dataType, itemDefinition);
        ((ItemDefinition)Mockito.verify((Object)itemDefinition)).setTypeRef(qName);
        ((ItemDefinition)Mockito.verify((Object)itemDefinition)).setName(name);
        ((PropertiesPanelNotifier)Mockito.verify((Object)this.panelNotifier)).notifyPanel();
        ((EventSourceMock)Mockito.verify(this.dataTypeChangedEvent)).fire(Matchers.any());
        Assert.assertTrue((boolean)itemDefinitions.isEmpty());
    }

    @Test
    public void testMakeName() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String expectedName = "name";
        Mockito.when((Object)dataType.getName()).thenReturn((Object)"name");
        Name name = this.handler.makeName(dataType);
        Assert.assertEquals((Object)"name", (Object)name.getValue());
    }

    @Test
    public void testMakeQNameWhenDataTypeIsDefault() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String expectedName = "string";
        Mockito.when((Object)dataType.getType()).thenReturn((Object)"string");
        QName name = this.handler.makeQName(dataType);
        String actualName = name.getLocalPart();
        Assert.assertEquals((Object)"string", (Object)actualName);
        Assert.assertEquals((Object)"", (Object)name.getNamespaceURI());
    }

    @Test
    public void testMakeQNameWhenDataTypeIsNotDefault() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String expectedName = "tAddress";
        Mockito.when((Object)dataType.getType()).thenReturn((Object)"tAddress");
        QName name = this.handler.makeQName(dataType);
        String actual = name.toString();
        String expected = "tAddress";
        Assert.assertEquals((Object)"tAddress", (Object)actual);
        Assert.assertEquals((Object)"", (Object)name.getNamespaceURI());
    }

    @Test
    public void testMakeQNameWithItemDefinition() {
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Name itemDefinitionName = (Name)Mockito.mock(Name.class);
        String expectedName = "tAddress";
        Mockito.when((Object)itemDefinitionName.getValue()).thenReturn((Object)"tAddress");
        Mockito.when((Object)itemDefinition.getName()).thenReturn((Object)itemDefinitionName);
        QName name = this.handler.makeQName(itemDefinition);
        String actual = name.toString();
        String expected = "tAddress";
        Assert.assertEquals((Object)"tAddress", (Object)actual);
        Assert.assertEquals((Object)"", (Object)name.getNamespaceURI());
    }

    @Test
    public void testMakeAllowedValuesWhenDataTypeConstraintIsBlank() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Mockito.when((Object)dataType.getConstraint()).thenReturn((Object)"");
        UnaryTests actualAllowedValues = this.handler.makeAllowedValues(dataType, itemDefinition);
        Assert.assertNull((Object)actualAllowedValues);
    }

    @Test
    public void testMakeAllowedValuesWhenDataTypeConstraintIsNull() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Mockito.when((Object)dataType.getConstraint()).thenReturn(null);
        Mockito.when((Object)dataType.getConstraintType()).thenReturn(null);
        UnaryTests actualAllowedValues = this.handler.makeAllowedValues(dataType, itemDefinition);
        Assert.assertNull((Object)actualAllowedValues);
    }

    @Test
    public void testMakeAllowedValuesWhenDataTypeAndItemDefinitionConstraintAreEqual() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        UnaryTests expectedAllowedValues = (UnaryTests)Mockito.mock(UnaryTests.class);
        String expectedText = "(1..20)";
        ConstraintType expectedConstraintType = ConstraintType.RANGE;
        Mockito.when((Object)itemDefinition.getAllowedValues()).thenReturn((Object)expectedAllowedValues);
        Mockito.when((Object)expectedAllowedValues.getConstraintType()).thenReturn((Object)expectedConstraintType);
        Mockito.when((Object)expectedAllowedValues.getText()).thenReturn((Object)new Text("(1..20)"));
        Mockito.when((Object)dataType.getConstraint()).thenReturn((Object)"(1..20)");
        UnaryTests actualAllowedValues = this.handler.makeAllowedValues(dataType, itemDefinition);
        Assert.assertEquals((Object)expectedAllowedValues, (Object)actualAllowedValues);
        Assert.assertEquals((Object)expectedConstraintType, (Object)actualAllowedValues.getConstraintType());
    }

    @Test
    public void testMakeAllowedValuesWhenDataTypeAndItemDefinitionConstraintAreNotEqual() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        String expectedText = "(1..20)";
        ConstraintType expectedConstraintType = ConstraintType.RANGE;
        Mockito.when((Object)dataType.getConstraint()).thenReturn((Object)"(1..20)");
        Mockito.when((Object)dataType.getConstraintType()).thenReturn((Object)expectedConstraintType);
        UnaryTests actualAllowedValues = this.handler.makeAllowedValues(dataType, itemDefinition);
        Assert.assertNotNull((Object)actualAllowedValues.getId());
        Assert.assertNotNull((Object)actualAllowedValues.getDescription());
        Assert.assertEquals((Object)"(1..20)", (Object)actualAllowedValues.getText().getValue());
        Assert.assertNull((Object)actualAllowedValues.getExpressionLanguage());
        Assert.assertEquals((Object)expectedConstraintType, (Object)actualAllowedValues.getConstraintType());
    }
}

