/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.graph;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.DiagramImpl;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.impl.GraphImpl;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStore;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStoreImpl;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNGraphUtilsTest {
    private static final String NAME = "name";
    @Mock
    private SessionManager sessionManager;
    @Mock
    private DMNDiagramUtils dmnDiagramUtils;
    @Mock
    private ClientSession clientSession;
    @Mock
    private CanvasHandler canvasHandler;
    @Mock
    private DMNDiagramsSession dmnDiagramsSession;
    @Mock
    private Metadata metadata;
    private DMNGraphUtils utils;
    private GraphImpl<DefinitionSet> graph;
    private DiagramImpl diagram;

    @Before
    public void setup() {
        this.utils = new DMNGraphUtils(this.sessionManager, this.dmnDiagramUtils, this.dmnDiagramsSession);
        this.graph = new GraphImpl(UUID.uuid(), (GraphNodeStore)new GraphNodeStoreImpl());
        this.diagram = new DiagramImpl(NAME, this.graph, this.metadata);
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.clientSession);
        Mockito.when((Object)this.clientSession.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
    }

    @Test
    public void testGetDefinitions() {
        Definitions expectedDefinitions = (Definitions)Mockito.mock(Definitions.class);
        Mockito.when((Object)this.dmnDiagramsSession.getDRGDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.dmnDiagramUtils.getDefinitions((Diagram)this.diagram)).thenReturn((Object)expectedDefinitions);
        Definitions actualDefinitions = this.utils.getModelDefinitions();
        Assert.assertNotNull((Object)actualDefinitions);
        Assert.assertEquals((Object)expectedDefinitions, (Object)actualDefinitions);
    }

    @Test
    public void testGetDefinitionsWithDiagram() {
        Definitions expectedDefinitions = (Definitions)Mockito.mock(Definitions.class);
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        Mockito.when((Object)this.dmnDiagramUtils.getDefinitions(diagram)).thenReturn((Object)expectedDefinitions);
        Definitions actualDefinitions = this.utils.getDefinitions(diagram);
        Assert.assertNotNull((Object)actualDefinitions);
        Assert.assertEquals((Object)expectedDefinitions, (Object)actualDefinitions);
    }

    @Test
    public void testGetDefinitionsWithNoNodes() {
        Assert.assertNull((Object)this.utils.getModelDefinitions());
    }

    @Test
    public void testGetCanvasHandler() {
        CanvasHandler actualCanvasHandler = this.utils.getCanvasHandler();
        Assert.assertEquals((Object)this.canvasHandler, (Object)actualCanvasHandler);
    }

    @Test
    public void testGetModelDRGElements() {
        List<DRGElement> expectedDRGElements = Arrays.asList((DRGElement)Mockito.mock(DRGElement.class), (DRGElement)Mockito.mock(DRGElement.class));
        Mockito.when((Object)this.dmnDiagramsSession.getModelDRGElements()).thenReturn(expectedDRGElements);
        List actualDRGElements = this.utils.getModelDRGElements();
        Assert.assertEquals(expectedDRGElements, (Object)actualDRGElements);
    }

    @Test
    public void testGetNodeStream() {
        Stream<Object> expectedStream = Stream.of(Mockito.mock(Node.class));
        Mockito.when((Object)this.dmnDiagramsSession.getCurrentGraphDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.dmnDiagramUtils.getNodeStream((Diagram)this.diagram)).thenReturn(expectedStream);
        Stream actualStream = this.utils.getNodeStream();
        Assert.assertEquals(expectedStream, (Object)actualStream);
    }
}

