/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.converters;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.OutputClauseUnaryTests;
import org.kie.workbench.common.dmn.client.marshaller.converters.OutputClauseUnaryTestsPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.UnaryTestsPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITUnaryTests;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class OutputClauseUnaryTestsPropertyConverterTest {
    private static final String TEXT = "text";
    private static final JSITUnaryTests jsitUnaryTests = (JSITUnaryTests)Mockito.mock(JSITUnaryTests.class);

    @BeforeClass
    public static void setupAttributesCast() {
        UnaryTestsPropertyConverter.UNARY_TESTS_FACTORY = new UnaryTestsPropertyConverter.UnaryTestsFactory(){

            JSITUnaryTests make() {
                return jsitUnaryTests;
            }
        };
        UnaryTestsPropertyConverter.ATTRIBUTES_UTILS = new UnaryTestsPropertyConverter.AttributesUtils(){

            Map<QName, String> cast(Map<QName, String> o) {
                return new HashMap<QName, String>();
            }
        };
    }

    @AfterClass
    public static void restoreAttributesCast() {
        UnaryTestsPropertyConverter.UNARY_TESTS_FACTORY = new UnaryTestsPropertyConverter.UnaryTestsFactory();
        UnaryTestsPropertyConverter.ATTRIBUTES_UTILS = new UnaryTestsPropertyConverter.AttributesUtils();
    }

    @Test
    public void testWBFromDMNWhenNull() {
        OutputClauseUnaryTests wb = OutputClauseUnaryTestsPropertyConverter.wbFromDMN(null);
        Assertions.assertThat((Object)wb).isNotNull();
    }

    @Test
    public void testWBFromDMNWhenNonNull() {
        Mockito.when((Object)jsitUnaryTests.getText()).thenReturn((Object)TEXT);
        OutputClauseUnaryTests wb = OutputClauseUnaryTestsPropertyConverter.wbFromDMN((JSITUnaryTests)jsitUnaryTests);
        Assertions.assertThat((Object)wb).isNotNull();
        Assertions.assertThat((String)wb.getText().getValue()).isEqualTo(TEXT);
    }

    @Test
    public void testDMNFromWBWhenNull() {
        JSITUnaryTests dmn = OutputClauseUnaryTestsPropertyConverter.dmnFromWB(null);
        Assertions.assertThat((Object)dmn).isNull();
    }

    @Test
    public void testDMNFromWBWhenTextIsNull() {
        OutputClauseUnaryTests wb = new OutputClauseUnaryTests();
        wb.setText(null);
        JSITUnaryTests dmn = OutputClauseUnaryTestsPropertyConverter.dmnFromWB((OutputClauseUnaryTests)wb);
        Assertions.assertThat((Object)dmn).isNull();
    }

    @Test
    public void testDMNFromWBWhenNonNullWithEmptyString() {
        OutputClauseUnaryTests wb = new OutputClauseUnaryTests();
        wb.getText().setValue("");
        JSITUnaryTests dmn = OutputClauseUnaryTestsPropertyConverter.dmnFromWB((OutputClauseUnaryTests)wb);
        Assertions.assertThat((Object)dmn).isNull();
    }

    @Test
    public void testDMNFromWBWhenNonNullWithNonEmptyString() {
        OutputClauseUnaryTests wb = new OutputClauseUnaryTests();
        wb.getText().setValue(TEXT);
        JSITUnaryTests dmn = OutputClauseUnaryTestsPropertyConverter.dmnFromWB((OutputClauseUnaryTests)wb);
        Assertions.assertThat((Object)dmn).isNotNull();
        ((JSITUnaryTests)Mockito.verify((Object)jsitUnaryTests)).setText(TEXT);
    }
}

