/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.property.dmn;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.NamedElement;
import org.kie.workbench.common.dmn.api.definition.model.TextAnnotation;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.property.dmn.DefaultValueUtilities;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.GraphImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStore;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStoreImpl;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultValueUtilitiesTest {
    private final String PREFIX = "prefix-";
    private Graph<?, Node> graph;

    @Before
    public void setup() {
        this.graph = new GraphImpl(UUID.randomUUID().toString(), (GraphNodeStore)new GraphNodeStoreImpl());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUpdateNewNodeName_UnhandledType() {
        DefaultValueUtilities.updateNewNodeName(this.graph, (DMNModelInstrumentedBase)new LiteralExpression());
    }

    @Test
    public void testUpdateNewNodeName_BusinessKnowledgeModel() {
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new Decision()));
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new InputData()));
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new KnowledgeSource()));
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new TextAnnotation()));
        BusinessKnowledgeModel bkm1 = new BusinessKnowledgeModel();
        BusinessKnowledgeModel bkm2 = new BusinessKnowledgeModel();
        BusinessKnowledgeModel bkm3 = new BusinessKnowledgeModel();
        BusinessKnowledgeModel bkm4 = new BusinessKnowledgeModel();
        this.assertUpdateNewNodeName(bkm1, bkm2, bkm -> bkm.getName().getValue(), () -> BusinessKnowledgeModel.class.getSimpleName() + "-1", () -> BusinessKnowledgeModel.class.getSimpleName() + "-2");
        bkm1.getName().setValue("bkm");
        bkm2.getName().setValue(BusinessKnowledgeModel.class.getSimpleName() + "-5");
        this.assertUpdateNewNodeName(bkm3, bkm4, bkm -> bkm.getName().getValue(), () -> BusinessKnowledgeModel.class.getSimpleName() + "-6", () -> BusinessKnowledgeModel.class.getSimpleName() + "-7");
    }

    @Test
    public void testUpdateNewNodeName_Decision() {
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new BusinessKnowledgeModel()));
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new InputData()));
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new KnowledgeSource()));
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new TextAnnotation()));
        Decision decision1 = new Decision();
        Decision decision2 = new Decision();
        Decision decision3 = new Decision();
        Decision decision4 = new Decision();
        this.assertUpdateNewNodeName(decision1, decision2, decision -> decision.getName().getValue(), () -> Decision.class.getSimpleName() + "-1", () -> Decision.class.getSimpleName() + "-2");
        decision1.getName().setValue("decision");
        decision2.getName().setValue(Decision.class.getSimpleName() + "-5");
        this.assertUpdateNewNodeName(decision3, decision4, decision -> decision.getName().getValue(), () -> Decision.class.getSimpleName() + "-6", () -> Decision.class.getSimpleName() + "-7");
    }

    @Test
    public void testUpdateNewNodeName_InputData() {
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new BusinessKnowledgeModel()));
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new Decision()));
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new KnowledgeSource()));
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new TextAnnotation()));
        InputData inputData1 = new InputData();
        InputData inputData2 = new InputData();
        InputData inputData3 = new InputData();
        InputData inputData4 = new InputData();
        this.assertUpdateNewNodeName(inputData1, inputData2, inputData -> inputData.getName().getValue(), () -> InputData.class.getSimpleName() + "-1", () -> InputData.class.getSimpleName() + "-2");
        inputData1.getName().setValue("inputData");
        inputData2.getName().setValue(InputData.class.getSimpleName() + "-5");
        this.assertUpdateNewNodeName(inputData3, inputData4, inputData -> inputData.getName().getValue(), () -> InputData.class.getSimpleName() + "-6", () -> InputData.class.getSimpleName() + "-7");
    }

    @Test
    public void testUpdateNewNodeName_KnowledgeSource() {
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new BusinessKnowledgeModel()));
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new Decision()));
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new InputData()));
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new TextAnnotation()));
        KnowledgeSource knowledgeSource1 = new KnowledgeSource();
        KnowledgeSource knowledgeSource2 = new KnowledgeSource();
        KnowledgeSource knowledgeSource3 = new KnowledgeSource();
        KnowledgeSource knowledgeSource4 = new KnowledgeSource();
        this.assertUpdateNewNodeName(knowledgeSource1, knowledgeSource2, knowledgeSource -> knowledgeSource.getName().getValue(), () -> KnowledgeSource.class.getSimpleName() + "-1", () -> KnowledgeSource.class.getSimpleName() + "-2");
        knowledgeSource1.getName().setValue("knowledgeSource");
        knowledgeSource2.getName().setValue(KnowledgeSource.class.getSimpleName() + "-5");
        this.assertUpdateNewNodeName(knowledgeSource3, knowledgeSource4, knowledgeSource -> knowledgeSource.getName().getValue(), () -> KnowledgeSource.class.getSimpleName() + "-6", () -> KnowledgeSource.class.getSimpleName() + "-7");
    }

    @Test
    public void testUpdateNewNodeName_TextAnnotation() {
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new BusinessKnowledgeModel()));
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new Decision()));
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new InputData()));
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new KnowledgeSource()));
        TextAnnotation textAnnotation1 = new TextAnnotation();
        TextAnnotation textAnnotation2 = new TextAnnotation();
        TextAnnotation textAnnotation3 = new TextAnnotation();
        TextAnnotation textAnnotation4 = new TextAnnotation();
        this.assertUpdateNewNodeName(textAnnotation1, textAnnotation2, textAnnotation -> textAnnotation.getText().getValue(), () -> TextAnnotation.class.getSimpleName() + "-1", () -> TextAnnotation.class.getSimpleName() + "-2");
        textAnnotation1.getText().setValue("textAnnotation");
        textAnnotation2.getText().setValue(TextAnnotation.class.getSimpleName() + "-5");
        this.assertUpdateNewNodeName(textAnnotation3, textAnnotation4, textAnnotation -> textAnnotation.getText().getValue(), () -> TextAnnotation.class.getSimpleName() + "-6", () -> TextAnnotation.class.getSimpleName() + "-7");
    }

    @Test
    public void testUpdateNewNodeName_DecisionService() {
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new BusinessKnowledgeModel()));
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new Decision()));
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new InputData()));
        this.graph.addNode(this.makeMockNode((DMNModelInstrumentedBase)new KnowledgeSource()));
        DecisionService decisionService1 = new DecisionService();
        DecisionService decisionService2 = new DecisionService();
        DecisionService decisionService3 = new DecisionService();
        DecisionService decisionService4 = new DecisionService();
        this.assertUpdateNewNodeName(decisionService1, decisionService2, decisionService -> decisionService.getName().getValue(), () -> DecisionService.class.getSimpleName() + "-1", () -> DecisionService.class.getSimpleName() + "-2");
        decisionService1.getName().setValue("decisionService");
        decisionService2.getName().setValue(DecisionService.class.getSimpleName() + "-5");
        this.assertUpdateNewNodeName(decisionService3, decisionService4, decisionService -> decisionService.getName().getValue(), () -> DecisionService.class.getSimpleName() + "-6", () -> DecisionService.class.getSimpleName() + "-7");
    }

    private <T extends DMNModelInstrumentedBase> void assertUpdateNewNodeName(T content1, T content2, Function<T, String> nameExtractor, Supplier<String> content1NameSupplier, Supplier<String> content2NameSupplier) {
        this.graph.addNode(this.makeMockNode(content1));
        DefaultValueUtilities.updateNewNodeName(this.graph, content1);
        Assertions.assertThat((String)nameExtractor.apply(content1)).isEqualTo(content1NameSupplier.get());
        this.graph.addNode(this.makeMockNode(content2));
        DefaultValueUtilities.updateNewNodeName(this.graph, content2);
        Assertions.assertThat((String)nameExtractor.apply(content2)).isEqualTo(content2NameSupplier.get());
    }

    @Test
    public void testExtractIndex() {
        Assertions.assertThat((Optional)DefaultValueUtilities.extractIndex((String)"", (String)"prefix-")).isNotPresent();
        Assertions.assertThat((Optional)DefaultValueUtilities.extractIndex((String)"1", (String)"prefix-")).isNotPresent();
        Assertions.assertThat((Optional)DefaultValueUtilities.extractIndex((String)"a", (String)"prefix-")).isNotPresent();
        Assertions.assertThat((Optional)DefaultValueUtilities.extractIndex((String)"prefix-a", (String)"prefix-")).isNotPresent();
        ((OptionalAssert)Assertions.assertThat((Optional)DefaultValueUtilities.extractIndex((String)"prefix-1", (String)"prefix-")).isPresent()).hasValue((Object)1);
        ((OptionalAssert)Assertions.assertThat((Optional)DefaultValueUtilities.extractIndex((String)"prefix-55", (String)"prefix-")).isPresent()).hasValue((Object)55);
    }

    private Node makeMockNode(DMNModelInstrumentedBase dmnModel) {
        ViewImpl view = new ViewImpl((Object)dmnModel, Bounds.create((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        NodeImpl node = new NodeImpl(UUID.randomUUID().toString());
        node.setContent((Object)view);
        return node;
    }

    @Test
    public void testUpdateNewNodeNameWhenNomeIsAlreadySet() {
        String existingName = "existingName";
        NamedElement dec = (NamedElement)Mockito.mock(NamedElement.class);
        Name name = new Name();
        name.setValue("existingName");
        Mockito.when((Object)dec.getName()).thenReturn((Object)name);
        DefaultValueUtilities.updateNewNodeName(this.graph, (DMNModelInstrumentedBase)dec);
        Assert.assertEquals((Object)"existingName", (Object)dec.getName().getValue());
    }
}

