/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.session;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.session.DMNCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.diagram.GraphsProvider;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.HasContentDefinitionId;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNCanvasHandlerTest {
    @Mock
    private DMNCanvasHandler canvasHandler;
    @Mock
    private Element parent;
    @Mock
    private Element child;
    @Mock
    private AbstractCanvas canvas;
    @Mock
    private Shape shape;
    private final String parentUuid = "parent uuid";

    @Before
    public void setup() {
        Mockito.when((Object)this.parent.getUUID()).thenReturn((Object)"parent uuid");
        ((DMNCanvasHandler)Mockito.doCallRealMethod().when((Object)this.canvasHandler)).addChild(this.parent, this.child);
        ((DMNCanvasHandler)Mockito.doCallRealMethod().when((Object)this.canvasHandler)).updateDiagramId((Element)Matchers.any());
    }

    @Test
    public void testAddChildWhenItIsElementFromThisCanvas() {
        ((DMNCanvasHandler)Mockito.doReturn((Object)false).when((Object)this.canvasHandler)).isCanvasRoot(this.parent);
        ((DMNCanvasHandler)Mockito.doReturn((Object)this.canvas).when((Object)this.canvasHandler)).getCanvas();
        Mockito.when((Object)this.canvas.getShape("parent uuid")).thenReturn((Object)this.shape);
        this.canvasHandler.addChild(this.parent, this.child);
        ((DMNCanvasHandler)Mockito.verify((Object)this.canvasHandler)).superAddChild(this.parent, this.child);
    }

    @Test
    public void testAddChildWhenItIsNotElementFromThisCanvas() {
        ((DMNCanvasHandler)Mockito.doReturn((Object)false).when((Object)this.canvasHandler)).isCanvasRoot(this.parent);
        ((DMNCanvasHandler)Mockito.doReturn((Object)this.canvas).when((Object)this.canvasHandler)).getCanvas();
        Mockito.when((Object)this.canvas.getShape("parent uuid")).thenReturn(null);
        this.canvasHandler.addChild(this.parent, this.child);
        ((DMNCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.never())).superAddChild(this.parent, this.child);
    }

    @Test
    public void testAddChildWhenItIsCanvasRoot() {
        ((DMNCanvasHandler)Mockito.doReturn((Object)true).when((Object)this.canvasHandler)).isCanvasRoot(this.parent);
        ((DMNCanvasHandler)Mockito.doReturn((Object)this.canvas).when((Object)this.canvasHandler)).getCanvas();
        Mockito.when((Object)this.canvas.getShape("parent uuid")).thenReturn(null);
        this.canvasHandler.addChild(this.parent, this.child);
        ((DMNCanvasHandler)Mockito.verify((Object)this.canvasHandler)).superAddChild(this.parent, this.child);
    }

    @Test
    public void testUpdateDiagramIdWhenDiagramIdIsNull() {
        String diagramId = "diagram id";
        HasContentDefinitionId hasContentDefinitionId = (HasContentDefinitionId)Mockito.mock(HasContentDefinitionId.class);
        Element element = this.getElementForTestUpdateDiagramId("diagram id", null, hasContentDefinitionId);
        this.canvasHandler.updateDiagramId(element);
        ((HasContentDefinitionId)Mockito.verify((Object)hasContentDefinitionId)).setDiagramId("diagram id");
    }

    @Test
    public void testUpdateDiagramIdWhenDiagramIdIsSet() {
        String diagramId = "diagram id";
        String currentDiagramId = "some set diagram";
        HasContentDefinitionId hasContentDefinitionId = (HasContentDefinitionId)Mockito.mock(HasContentDefinitionId.class);
        Element element = this.getElementForTestUpdateDiagramId("diagram id", "some set diagram", hasContentDefinitionId);
        this.canvasHandler.updateDiagramId(element);
        ((HasContentDefinitionId)Mockito.verify((Object)hasContentDefinitionId, (VerificationMode)Mockito.never())).setDiagramId(Matchers.anyString());
    }

    @Test
    public void testUpdateDiagramIdWhenDiagramIdIsEmpty() {
        String diagramId = "diagram id";
        String currentDiagramId = "";
        HasContentDefinitionId hasContentDefinitionId = (HasContentDefinitionId)Mockito.mock(HasContentDefinitionId.class);
        Element element = this.getElementForTestUpdateDiagramId("diagram id", "", hasContentDefinitionId);
        this.canvasHandler.updateDiagramId(element);
        ((HasContentDefinitionId)Mockito.verify((Object)hasContentDefinitionId)).setDiagramId("diagram id");
    }

    private Element getElementForTestUpdateDiagramId(String diagramId, String currentDiagramId, HasContentDefinitionId hasContentDefinitionId) {
        Element element = (Element)Mockito.mock(Element.class);
        Definition definition = (Definition)Mockito.mock(Definition.class);
        GraphsProvider graphsProvider = (GraphsProvider)Mockito.mock(GraphsProvider.class);
        Mockito.when((Object)graphsProvider.getCurrentDiagramId()).thenReturn((Object)diagramId);
        Mockito.when((Object)definition.getDefinition()).thenReturn((Object)hasContentDefinitionId);
        Mockito.when((Object)element.getContent()).thenReturn((Object)definition);
        Mockito.when((Object)hasContentDefinitionId.getDiagramId()).thenReturn((Object)currentDiagramId);
        Mockito.when((Object)this.canvasHandler.getGraphsProvider()).thenReturn((Object)graphsProvider);
        return element;
    }
}

