/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.session;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.appformer.client.stateControl.registry.Registry;
import org.appformer.client.stateControl.registry.RegistryChangeListener;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.session.CommandRegistryHolder;
import org.kie.workbench.common.dmn.client.session.RegistryProvider;
import org.kie.workbench.common.stunner.core.diagram.GraphsProvider;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class RegistryProviderTest {
    @Mock
    private ManagedInstance<CommandRegistryHolder> registryHolders;
    @Mock
    private GraphsProvider graphsProvider;
    private RegistryProvider provider;

    @Before
    public void setup() {
        this.provider = (RegistryProvider)Mockito.spy((Object)new RegistryProvider(this.registryHolders, this.graphsProvider));
    }

    @Test
    public void testInitializeRegistry() {
        String id = "id";
        Registry registry = (Registry)Mockito.mock(Registry.class);
        ((RegistryProvider)Mockito.doReturn((Object)registry).when((Object)this.provider)).createRegistry();
        this.provider.initializeRegistry("id");
        Assert.assertTrue((boolean)this.provider.getRegistryMap().containsKey("id"));
        Assert.assertEquals((Object)registry, this.provider.getRegistryMap().get("id"));
    }

    @Test
    public void testGetCurrentCommandRegistryWhenItIsInitialized() {
        String diagramId = "diagram id";
        Registry registry = (Registry)Mockito.mock(Registry.class);
        Mockito.when((Object)this.graphsProvider.getCurrentDiagramId()).thenReturn((Object)"diagram id");
        this.provider.getRegistryMap().put("diagram id", registry);
        Registry currentCommandRegistry = this.provider.getCurrentCommandRegistry();
        Assert.assertEquals((Object)registry, (Object)currentCommandRegistry);
        ((RegistryProvider)Mockito.verify((Object)this.provider, (VerificationMode)Mockito.never())).initializeRegistry("diagram id");
    }

    @Test
    public void testGetCurrentCommandRegistryWhenItIsNotPresent() {
        String diagramId = "diagram id";
        Registry createdRegistry = (Registry)Mockito.mock(Registry.class);
        Mockito.when((Object)this.graphsProvider.getCurrentDiagramId()).thenReturn((Object)"diagram id");
        ((RegistryProvider)Mockito.doReturn((Object)createdRegistry).when((Object)this.provider)).createRegistry();
        Registry currentCommandRegistry = this.provider.getCurrentCommandRegistry();
        Assert.assertEquals((Object)createdRegistry, (Object)currentCommandRegistry);
        ((RegistryProvider)Mockito.verify((Object)this.provider)).initializeRegistry("diagram id");
    }

    @Test
    public void testCreateRegistry() {
        CommandRegistryHolder registryHolder = (CommandRegistryHolder)Mockito.mock(CommandRegistryHolder.class);
        Registry registry = (Registry)Mockito.mock(Registry.class);
        Mockito.when((Object)this.registryHolders.get()).thenReturn((Object)registryHolder);
        Mockito.when((Object)registryHolder.getRegistry()).thenReturn((Object)registry);
        Registry createdRegistry = this.provider.createRegistry();
        Assert.assertEquals((Object)registry, (Object)createdRegistry);
        ((Registry)Mockito.verify((Object)createdRegistry, (VerificationMode)Mockito.never())).setRegistryChangeListener((RegistryChangeListener)Matchers.any());
    }

    @Test
    public void testCreateRegistryWhenRegistryChangeListenerIsSet() {
        CommandRegistryHolder registryHolder = (CommandRegistryHolder)Mockito.mock(CommandRegistryHolder.class);
        Registry registry = (Registry)Mockito.mock(Registry.class);
        RegistryChangeListener listener = (RegistryChangeListener)Mockito.mock(RegistryChangeListener.class);
        this.provider.setRegistryChangeListener(listener);
        Mockito.when((Object)this.registryHolders.get()).thenReturn((Object)registryHolder);
        Mockito.when((Object)registryHolder.getRegistry()).thenReturn((Object)registry);
        Registry createdRegistry = this.provider.createRegistry();
        Assert.assertEquals((Object)registry, (Object)createdRegistry);
        ((Registry)Mockito.verify((Object)createdRegistry)).setRegistryChangeListener(listener);
    }
}

