/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.codecompletion;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.core.client.JavaScriptObject;
import java.util.function.Consumer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoFEELInitializer;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoFEELVariableSuggestions;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoPropertiesFactory;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.monaco.MonacoEditorInitializer;
import org.uberfire.client.views.pfly.monaco.jsinterop.Monaco;
import org.uberfire.client.views.pfly.monaco.jsinterop.MonacoEditor;
import org.uberfire.client.views.pfly.monaco.jsinterop.MonacoLanguages;

@RunWith(value=LienzoMockitoTestRunner.class)
public class MonacoFEELInitializerTest {
    private MonacoFEELInitializer initializer;
    @Mock
    private MonacoFEELVariableSuggestions variableSuggestions;

    @Before
    public void setup() {
        this.initializer = (MonacoFEELInitializer)Mockito.spy((Object)new MonacoFEELInitializer(this.variableSuggestions));
    }

    @Test
    public void testInitializeFEELEditorWhenEditorIsNotInitialized() {
        MonacoEditorInitializer monacoEditorInitializer = (MonacoEditorInitializer)Mockito.mock(MonacoEditorInitializer.class);
        Consumer<Monaco> onMonacoLoaded = m -> {};
        ((MonacoFEELInitializer)Mockito.doReturn(onMonacoLoaded).when((Object)this.initializer)).onMonacoLoaded();
        ((MonacoFEELInitializer)Mockito.doReturn((Object)monacoEditorInitializer).when((Object)this.initializer)).makeMonacoEditorInitializer();
        ((MonacoFEELInitializer)Mockito.doReturn((Object)MonacoFEELInitializer.MonacoFEELInitializationStatus.NOT_INITIALIZED).when((Object)this.initializer)).getInitializationStatus();
        this.initializer.initializeFEELEditor();
        ((MonacoEditorInitializer)Mockito.verify((Object)monacoEditorInitializer)).require(onMonacoLoaded, new String[0]);
    }

    @Test
    public void testInitializeFEELEditorWhenEditorIsInitializing() {
        MonacoEditorInitializer monacoEditorInitializer = (MonacoEditorInitializer)Mockito.mock(MonacoEditorInitializer.class);
        ((MonacoFEELInitializer)Mockito.doReturn((Object)monacoEditorInitializer).when((Object)this.initializer)).makeMonacoEditorInitializer();
        ((MonacoFEELInitializer)Mockito.doReturn((Object)MonacoFEELInitializer.MonacoFEELInitializationStatus.INITIALIZING).when((Object)this.initializer)).getInitializationStatus();
        this.initializer.initializeFEELEditor();
        ((MonacoEditorInitializer)Mockito.verify((Object)monacoEditorInitializer, (VerificationMode)Mockito.never())).require((Consumer)Matchers.any(), new String[0]);
    }

    @Test
    public void testInitializeFEELEditorWhenEditorIsInitialized() {
        MonacoEditorInitializer monacoEditorInitializer = (MonacoEditorInitializer)Mockito.mock(MonacoEditorInitializer.class);
        ((MonacoFEELInitializer)Mockito.doReturn((Object)monacoEditorInitializer).when((Object)this.initializer)).makeMonacoEditorInitializer();
        ((MonacoFEELInitializer)Mockito.doReturn((Object)MonacoFEELInitializer.MonacoFEELInitializationStatus.INITIALIZED).when((Object)this.initializer)).getInitializationStatus();
        this.initializer.initializeFEELEditor();
        ((MonacoEditorInitializer)Mockito.verify((Object)monacoEditorInitializer, (VerificationMode)Mockito.never())).require((Consumer)Matchers.any(), new String[0]);
    }

    @Test
    public void testOnMonacoLoaded() {
        MonacoPropertiesFactory properties = (MonacoPropertiesFactory)Mockito.mock(MonacoPropertiesFactory.class);
        MonacoLanguages languages = (MonacoLanguages)Mockito.mock(MonacoLanguages.class);
        JavaScriptObject language = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        JavaScriptObject languageDefinition = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        JavaScriptObject completionItemProvider = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        JavaScriptObject themeData = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        JavaScriptObject constructionOptions = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        MonacoEditor editor = (MonacoEditor)Mockito.mock(MonacoEditor.class);
        Monaco monaco = (Monaco)Mockito.mock(Monaco.class);
        monaco.languages = languages;
        monaco.editor = editor;
        Mockito.when((Object)properties.getLanguage()).thenReturn((Object)language);
        Mockito.when((Object)properties.getLanguageDefinition()).thenReturn((Object)languageDefinition);
        Mockito.when((Object)properties.getCompletionItemProvider(this.variableSuggestions)).thenReturn((Object)completionItemProvider);
        Mockito.when((Object)properties.getThemeData()).thenReturn((Object)themeData);
        Mockito.when((Object)properties.getConstructionOptions()).thenReturn((Object)constructionOptions);
        Mockito.when((Object)properties.getConstructionOptions()).thenReturn((Object)constructionOptions);
        ((MonacoFEELInitializer)Mockito.doReturn((Object)properties).when((Object)this.initializer)).makeMonacoPropertiesFactory();
        this.initializer.onMonacoLoaded().accept(monaco);
        ((MonacoLanguages)Mockito.verify((Object)languages)).register(language);
        ((MonacoLanguages)Mockito.verify((Object)languages)).setMonarchTokensProvider("feel-language", languageDefinition);
        ((MonacoLanguages)Mockito.verify((Object)languages)).registerCompletionItemProvider("feel-language", completionItemProvider);
        ((MonacoLanguages)Mockito.verify((Object)languages)).register(language);
        ((MonacoEditor)Mockito.verify((Object)editor)).defineTheme("feel-theme", themeData);
        ((MonacoFEELInitializer)Mockito.verify((Object)this.initializer)).setFEELAsInitialized();
    }
}

