/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.codecompletion;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONBoolean;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.core.JsRegExp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoFEELVariableSuggestions;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoPropertiesFactory;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.views.pfly.monaco.jsinterop.MonacoLanguages;

@RunWith(value=GwtMockitoTestRunner.class)
public class MonacoPropertiesFactoryTest {
    private MonacoPropertiesFactory factory;
    @Mock
    private MonacoFEELVariableSuggestions variableSuggestions;

    @Before
    public void setup() {
        this.factory = (MonacoPropertiesFactory)Mockito.spy((Object)new MonacoPropertiesFactory());
    }

    @Test
    public void testGetConstructionOptions() {
        JSONObject options = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject scrollbar = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject miniMap = (JSONObject)Mockito.mock(JSONObject.class);
        JSONString language = (JSONString)Mockito.mock(JSONString.class);
        JSONString theme = (JSONString)Mockito.mock(JSONString.class);
        JSONString renderLineHighlight = (JSONString)Mockito.mock(JSONString.class);
        JSONString lineNumbers = (JSONString)Mockito.mock(JSONString.class);
        JSONBoolean overviewRulerBorder = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JSONBoolean scrollBeyondLastLine = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JSONBoolean snippetSuggestions = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JSONBoolean useTabStops = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JSONBoolean contextmenu = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JSONBoolean folding = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JSONBoolean enabled = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JSONBoolean useShadows = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JSONValue fontSize = (JSONValue)Mockito.mock(JSONValue.class);
        JSONValue lineNumbersMinChars = (JSONValue)Mockito.mock(JSONValue.class);
        JSONValue lineDecorationsWidth = (JSONValue)Mockito.mock(JSONValue.class);
        JSONBoolean automaticLayout = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JSONBoolean renderWhitespace = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JSONBoolean hideCursorInOverviewRuler = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JavaScriptObject expectedOptions = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)language).when((Object)this.factory)).makeJSONString("feel-language");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)theme).when((Object)this.factory)).makeJSONString("feel-theme");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)renderLineHighlight).when((Object)this.factory)).makeJSONString("none");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)lineNumbers).when((Object)this.factory)).makeJSONString("off");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)fontSize).when((Object)this.factory)).makeJSONNumber(12);
        Mockito.when((Object)options.getJavaScriptObject()).thenReturn((Object)expectedOptions);
        Mockito.when((Object)this.factory.makeJSONObject()).thenReturn((Object)options, (Object[])new JSONObject[]{scrollbar, miniMap});
        Mockito.when((Object)this.factory.makeJSONNumber(1)).thenReturn((Object)lineNumbersMinChars, (Object[])new JSONValue[]{lineDecorationsWidth});
        Mockito.when((Object)this.factory.makeJSONBoolean(false)).thenReturn((Object)overviewRulerBorder, (Object[])new JSONBoolean[]{scrollBeyondLastLine, snippetSuggestions, useTabStops, contextmenu, folding, enabled, useShadows});
        Mockito.when((Object)this.factory.makeJSONBoolean(true)).thenReturn((Object)automaticLayout, (Object[])new JSONBoolean[]{renderWhitespace, hideCursorInOverviewRuler});
        JavaScriptObject actualOptions = this.factory.getConstructionOptions();
        ((JSONObject)Mockito.verify((Object)options)).put("language", (JSONValue)language);
        ((JSONObject)Mockito.verify((Object)options)).put("theme", (JSONValue)theme);
        ((JSONObject)Mockito.verify((Object)options)).put("renderLineHighlight", (JSONValue)renderLineHighlight);
        ((JSONObject)Mockito.verify((Object)options)).put("fontSize", fontSize);
        ((JSONObject)Mockito.verify((Object)options)).put("lineNumbersMinChars", lineNumbersMinChars);
        ((JSONObject)Mockito.verify((Object)options)).put("lineDecorationsWidth", lineDecorationsWidth);
        ((JSONObject)Mockito.verify((Object)options)).put("overviewRulerBorder", (JSONValue)overviewRulerBorder);
        ((JSONObject)Mockito.verify((Object)options)).put("scrollBeyondLastLine", (JSONValue)scrollBeyondLastLine);
        ((JSONObject)Mockito.verify((Object)options)).put("snippetSuggestions", (JSONValue)snippetSuggestions);
        ((JSONObject)Mockito.verify((Object)options)).put("useTabStops", (JSONValue)useTabStops);
        ((JSONObject)Mockito.verify((Object)options)).put("contextmenu", (JSONValue)contextmenu);
        ((JSONObject)Mockito.verify((Object)options)).put("folding", (JSONValue)folding);
        ((JSONObject)Mockito.verify((Object)miniMap)).put("enabled", (JSONValue)enabled);
        ((JSONObject)Mockito.verify((Object)scrollbar)).put("useShadows", (JSONValue)useShadows);
        ((JSONObject)Mockito.verify((Object)options)).put("automaticLayout", (JSONValue)automaticLayout);
        ((JSONObject)Mockito.verify((Object)options)).put("renderWhitespace", (JSONValue)renderWhitespace);
        ((JSONObject)Mockito.verify((Object)options)).put("hideCursorInOverviewRuler", (JSONValue)hideCursorInOverviewRuler);
        Assert.assertEquals((Object)expectedOptions, (Object)actualOptions);
    }

    @Test
    public void testGetThemeData() {
        JSONObject themeDefinition = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject colors = (JSONObject)Mockito.mock(JSONObject.class);
        JSONString colorHEXCode = (JSONString)Mockito.mock(JSONString.class);
        JSONString base = (JSONString)Mockito.mock(JSONString.class);
        JSONBoolean inherit = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JSONArray rules = (JSONArray)Mockito.mock(JSONArray.class);
        JavaScriptObject expectedEditorThemeData = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)colorHEXCode).when((Object)this.factory)).makeJSONString("#000000");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)base).when((Object)this.factory)).makeJSONString("vs");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)inherit).when((Object)this.factory)).makeJSONBoolean(false);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)rules).when((Object)this.factory)).getRules();
        Mockito.when((Object)themeDefinition.getJavaScriptObject()).thenReturn((Object)expectedEditorThemeData);
        Mockito.when((Object)this.factory.makeJSONObject()).thenReturn((Object)themeDefinition, (Object[])new JSONObject[]{colors});
        JavaScriptObject actualEditorThemeData = this.factory.getThemeData();
        ((JSONObject)Mockito.verify((Object)colors)).put("editorLineNumber.foreground", (JSONValue)colorHEXCode);
        ((JSONObject)Mockito.verify((Object)themeDefinition)).put("base", (JSONValue)base);
        ((JSONObject)Mockito.verify((Object)themeDefinition)).put("inherit", (JSONValue)inherit);
        ((JSONObject)Mockito.verify((Object)themeDefinition)).put("rules", (JSONValue)rules);
        ((JSONObject)Mockito.verify((Object)themeDefinition)).put("colors", (JSONValue)colors);
        Assert.assertEquals((Object)expectedEditorThemeData, (Object)actualEditorThemeData);
    }

    @Test
    public void testGetRules() {
        JSONObject rule1 = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject rule2 = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject rule3 = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject rule4 = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject rule5 = (JSONObject)Mockito.mock(JSONObject.class);
        JSONString token1 = (JSONString)Mockito.mock(JSONString.class);
        JSONString foreground1 = (JSONString)Mockito.mock(JSONString.class);
        JSONString token2 = (JSONString)Mockito.mock(JSONString.class);
        JSONString foreground2 = (JSONString)Mockito.mock(JSONString.class);
        JSONString token3 = (JSONString)Mockito.mock(JSONString.class);
        JSONString foreground3 = (JSONString)Mockito.mock(JSONString.class);
        JSONString token4 = (JSONString)Mockito.mock(JSONString.class);
        JSONString foreground4 = (JSONString)Mockito.mock(JSONString.class);
        JSONString token5 = (JSONString)Mockito.mock(JSONString.class);
        JSONString foreground5 = (JSONString)Mockito.mock(JSONString.class);
        JSONArray expectedRules = (JSONArray)Mockito.mock(JSONArray.class);
        JSONString bold = (JSONString)Mockito.mock(JSONString.class);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)token1).when((Object)this.factory)).makeJSONString("feel-keyword");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)token2).when((Object)this.factory)).makeJSONString("feel-numeric");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)token3).when((Object)this.factory)).makeJSONString("feel-boolean");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)token4).when((Object)this.factory)).makeJSONString("feel-string");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)token5).when((Object)this.factory)).makeJSONString("feel-function");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)foreground1).when((Object)this.factory)).makeJSONString("26268C");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)foreground2).when((Object)this.factory)).makeJSONString("3232E7");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)foreground3).when((Object)this.factory)).makeJSONString("26268D");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)foreground4).when((Object)this.factory)).makeJSONString("2A9343");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)foreground5).when((Object)this.factory)).makeJSONString("3232E8");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)expectedRules).when((Object)this.factory)).makeJSONArray();
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)bold).when((Object)this.factory)).makeJSONString("bold");
        Mockito.when((Object)this.factory.makeJSONObject()).thenReturn((Object)rule1, (Object[])new JSONObject[]{rule2, rule3, rule4, rule5});
        JSONArray actualRules = this.factory.getRules();
        ((JSONObject)Mockito.verify((Object)rule1)).put("token", (JSONValue)token1);
        ((JSONObject)Mockito.verify((Object)rule2)).put("token", (JSONValue)token2);
        ((JSONObject)Mockito.verify((Object)rule3)).put("token", (JSONValue)token3);
        ((JSONObject)Mockito.verify((Object)rule4)).put("token", (JSONValue)token4);
        ((JSONObject)Mockito.verify((Object)rule5)).put("token", (JSONValue)token5);
        ((JSONObject)Mockito.verify((Object)rule1)).put("foreground", (JSONValue)foreground1);
        ((JSONObject)Mockito.verify((Object)rule2)).put("foreground", (JSONValue)foreground2);
        ((JSONObject)Mockito.verify((Object)rule3)).put("foreground", (JSONValue)foreground3);
        ((JSONObject)Mockito.verify((Object)rule4)).put("foreground", (JSONValue)foreground4);
        ((JSONObject)Mockito.verify((Object)rule5)).put("foreground", (JSONValue)foreground5);
        ((JSONObject)Mockito.verify((Object)rule1)).put("fontStyle", (JSONValue)bold);
        ((JSONObject)Mockito.verify((Object)rule4)).put("fontStyle", (JSONValue)bold);
        ((JSONObject)Mockito.verify((Object)rule3)).put("fontStyle", (JSONValue)bold);
        ((MonacoPropertiesFactory)Mockito.verify((Object)this.factory)).push(expectedRules, (JSONValue)rule1);
        ((MonacoPropertiesFactory)Mockito.verify((Object)this.factory)).push(expectedRules, (JSONValue)rule2);
        ((MonacoPropertiesFactory)Mockito.verify((Object)this.factory)).push(expectedRules, (JSONValue)rule3);
        ((MonacoPropertiesFactory)Mockito.verify((Object)this.factory)).push(expectedRules, (JSONValue)rule4);
        ((MonacoPropertiesFactory)Mockito.verify((Object)this.factory)).push(expectedRules, (JSONValue)rule5);
        Assert.assertEquals((Object)expectedRules, (Object)actualRules);
    }

    @Test
    public void testGetSuggestions() {
        JSONArray expectedSuggestions = (JSONArray)Mockito.mock(JSONArray.class);
        ArrayList suggestions = new ArrayList();
        List<String> variableSuggestions = this.buildVariableSuggestions();
        Mockito.when((Object)this.variableSuggestions.getSuggestions()).thenReturn(variableSuggestions);
        this.buildKeywordSuggestions().forEach(suggestion -> {
            JSONValue keyword = (JSONValue)Mockito.mock(JSONValue.class);
            suggestions.add(keyword);
            ((MonacoPropertiesFactory)Mockito.doReturn((Object)keyword).when((Object)this.factory)).getKeywordSuggestion(suggestion);
        });
        this.buildFunctionSuggestions().forEach(suggestion -> {
            JSONValue function = (JSONValue)Mockito.mock(JSONValue.class);
            suggestions.add(function);
            ((MonacoPropertiesFactory)Mockito.doReturn((Object)function).when((Object)this.factory)).getFunctionSuggestion((String)suggestion.get(0), (String)suggestion.get(1));
        });
        variableSuggestions.forEach(suggestion -> {
            JSONValue variable = (JSONValue)Mockito.mock(JSONValue.class);
            suggestions.add(variable);
            ((MonacoPropertiesFactory)Mockito.doReturn((Object)variable).when((Object)this.factory)).getVariableSuggestion(suggestion);
        });
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)expectedSuggestions).when((Object)this.factory)).makeJSONArray();
        JSONArray actualSuggestions = this.factory.getSuggestions(this.variableSuggestions);
        suggestions.forEach(suggestion -> ((MonacoPropertiesFactory)Mockito.verify((Object)this.factory)).push(expectedSuggestions, suggestion));
        Assert.assertEquals((Object)expectedSuggestions, (Object)actualSuggestions);
    }

    private List<String> buildVariableSuggestions() {
        return Arrays.asList("Decision-1", "Decision-2", "Decision-3", "Input-Data-1", "Input-Data-2", "Input-Data-3", "Data-Type-1", "Data-Type-2", "Data-Type-3");
    }

    private List<List<String>> buildFunctionSuggestions() {
        return Arrays.asList(Arrays.asList("abs(duration)", "abs($1)"), Arrays.asList("abs(number)", "abs($1)"), Arrays.asList("after(range, value)", "after($1, $2)"), Arrays.asList("after(range1, range2)", "after($1, $2)"), Arrays.asList("after(value, range)", "after($1, $2)"), Arrays.asList("after(value1, value2)", "after($1, $2)"), Arrays.asList("all(b)", "all($1)"), Arrays.asList("all(list)", "all($1)"), Arrays.asList("any(b)", "any($1)"), Arrays.asList("any(list)", "any($1)"), Arrays.asList("append(list, item)", "append($1, $2)"), Arrays.asList("before(range, value)", "before($1, $2)"), Arrays.asList("before(range1, range2)", "before($1, $2)"), Arrays.asList("before(value, range)", "before($1, $2)"), Arrays.asList("before(value1, value2)", "before($1, $2)"), Arrays.asList("ceiling(n)", "ceiling($1)"), Arrays.asList("code(value)", "code($1)"), Arrays.asList("coincides(range1, range2)", "coincides($1, $2)"), Arrays.asList("coincides(value1, value2)", "coincides($1, $2)"), Arrays.asList("concatenate(list)", "concatenate($1)"), Arrays.asList("contains(string, match)", "contains($1, $2)"), Arrays.asList("count(c)", "count($1)"), Arrays.asList("count(list)", "count($1)"), Arrays.asList("date and time(date, time)", "date and time($1, $2)"), Arrays.asList("date and time(from)", "date and time($1)"), Arrays.asList("date and time(year, month, day, hour, minute, second)", "date and time($1, $2, $3, $4, $5, $6)"), Arrays.asList("date and time(year, month, day, hour, minute, second, hour offset)", "date and time($1, $2, $3, $4, $5, $6, $7)"), Arrays.asList("date and time(year, month, day, hour, minute, second, timezone)", "date and time($1, $2, $3, $4, $5, $6, $7)"), Arrays.asList("date(from)", "date($1)"), Arrays.asList("date(year, month, day)", "date($1, $2, $3)"), Arrays.asList("day of week(date)", "day of week($1)"), Arrays.asList("day of year(date)", "day of year($1)"), Arrays.asList("decimal(n, scale)", "decimal($1, $2)"), Arrays.asList("decision table(ctx, outputs, input expression list, input values list, output values, rule list, hit policy, default output value)", "decision table($1, $2, $3, $4, $5, $6, $7, $8)"), Arrays.asList("distinct values(list)", "distinct values($1)"), Arrays.asList("duration(from)", "duration($1)"), Arrays.asList("during(range1, range2)", "during($1, $2)"), Arrays.asList("during(value, range)", "during($1, $2)"), Arrays.asList("ends with(string, match)", "ends with($1, $2)"), Arrays.asList("even(number)", "even($1)"), Arrays.asList("exp(number)", "exp($1)"), Arrays.asList("finished by(range, value)", "finished by($1, $2)"), Arrays.asList("finished by(range1, range2)", "finished by($1, $2)"), Arrays.asList("finishes(range1, range2)", "finishes($1, $2)"), Arrays.asList("finishes(value, range)", "finishes($1, $2)"), Arrays.asList("flatten(list)", "flatten($1)"), Arrays.asList("floor(n)", "floor($1)"), Arrays.asList("get entries(m)", "get entries($1)"), Arrays.asList("get value(m, key)", "get value($1, $2)"), Arrays.asList("includes(range, value)", "includes($1, $2)"), Arrays.asList("includes(range1, range2)", "includes($1, $2)"), Arrays.asList("index of(list, match)", "index of($1, $2)"), Arrays.asList("insert before(list, position, newItem)", "insert before($1, $2, $3)"), Arrays.asList("invoke(ctx, namespace, model name, decision name, parameters)", "invoke($1, $2, $3, $4, $5)"), Arrays.asList("list contains(list, element)", "list contains($1, $2)"), Arrays.asList("log(number)", "log($1)"), Arrays.asList("lower case(string)", "lower case($1)"), Arrays.asList("matches(input, pattern)", "matches($1, $2)"), Arrays.asList("matches(input, pattern, flags)", "matches($1, $2, $3)"), Arrays.asList("max(c)", "max($1)"), Arrays.asList("max(list)", "max($1)"), Arrays.asList("mean(list)", "mean($1)"), Arrays.asList("mean(n)", "mean($1)"), Arrays.asList("median(list)", "median($1)"), Arrays.asList("median(n)", "median($1)"), Arrays.asList("meets(range1, range2)", "meets($1, $2)"), Arrays.asList("met by(range1, range2)", "met by($1, $2)"), Arrays.asList("min(c)", "min($1)"), Arrays.asList("min(list)", "min($1)"), Arrays.asList("mode(list)", "mode($1)"), Arrays.asList("mode(n)", "mode($1)"), Arrays.asList("modulo(dividend, divisor)", "modulo($1, $2)"), Arrays.asList("month of year(date)", "month of year($1)"), Arrays.asList("nn all(b)", "nn all($1)"), Arrays.asList("nn all(list)", "nn all($1)"), Arrays.asList("nn any(b)", "nn any($1)"), Arrays.asList("nn any(list)", "nn any($1)"), Arrays.asList("nn count(c)", "nn count($1)"), Arrays.asList("nn count(list)", "nn count($1)"), Arrays.asList("nn max(c)", "nn max($1)"), Arrays.asList("nn max(list)", "nn max($1)"), Arrays.asList("nn mean(list)", "nn mean($1)"), Arrays.asList("nn mean(n)", "nn mean($1)"), Arrays.asList("nn median(list)", "nn median($1)"), Arrays.asList("nn median(n)", "nn median($1)"), Arrays.asList("nn min(c)", "nn min($1)"), Arrays.asList("nn min(list)", "nn min($1)"), Arrays.asList("nn mode(list)", "nn mode($1)"), Arrays.asList("nn mode(n)", "nn mode($1)"), Arrays.asList("nn stddev(list)", "nn stddev($1)"), Arrays.asList("nn stddev(n)", "nn stddev($1)"), Arrays.asList("nn sum(list)", "nn sum($1)"), Arrays.asList("nn sum(n)", "nn sum($1)"), Arrays.asList("not(negand)", "not($1)"), Arrays.asList("now()", "now()"), Arrays.asList("number(from, grouping separator, decimal separator)", "number($1, $2, $3)"), Arrays.asList("odd(number)", "odd($1)"), Arrays.asList("overlapped after by(range1, range2)", "overlapped after by($1, $2)"), Arrays.asList("overlapped before by(range1, range2)", "overlapped before by($1, $2)"), Arrays.asList("overlapped by(range1, range2)", "overlapped by($1, $2)"), Arrays.asList("overlaps after(range1, range2)", "overlaps after($1, $2)"), Arrays.asList("overlaps before(range1, range2)", "overlaps before($1, $2)"), Arrays.asList("overlaps(range1, range2)", "overlaps($1, $2)"), Arrays.asList("product(list)", "product($1)"), Arrays.asList("product(n)", "product($1)"), Arrays.asList("remove(list, position)", "remove($1, $2)"), Arrays.asList("replace(input, pattern, replacement)", "replace($1, $2, $3)"), Arrays.asList("replace(input, pattern, replacement, flags)", "replace($1, $2, $3, $4)"), Arrays.asList("reverse(list)", "reverse($1)"), Arrays.asList("sort()", "sort()"), Arrays.asList("sort(ctx, list, precedes)", "sort($1, $2, $3)"), Arrays.asList("sort(list)", "sort($1)"), Arrays.asList("split(string, delimiter)", "split($1, $2)"), Arrays.asList("split(string, delimiter, flags)", "split($1, $2, $3)"), Arrays.asList("sqrt(number)", "sqrt($1)"), Arrays.asList("started by(range, value)", "started by($1, $2)"), Arrays.asList("started by(range1, range2)", "started by($1, $2)"), Arrays.asList("starts with(string, match)", "starts with($1, $2)"), Arrays.asList("starts(range1, range2)", "starts($1, $2)"), Arrays.asList("starts(value, range)", "starts($1, $2)"), Arrays.asList("stddev(list)", "stddev($1)"), Arrays.asList("stddev(n)", "stddev($1)"), Arrays.asList("string length(string)", "string length($1)"), Arrays.asList("string(from)", "string($1)"), Arrays.asList("string(mask, p)", "string($1, $2)"), Arrays.asList("sublist(list, start position)", "sublist($1, $2)"), Arrays.asList("sublist(list, start position, length)", "sublist($1, $2, $3)"), Arrays.asList("substring after(string, match)", "substring after($1, $2)"), Arrays.asList("substring before(string, match)", "substring before($1, $2)"), Arrays.asList("substring(string, start position)", "substring($1, $2)"), Arrays.asList("substring(string, start position, length)", "substring($1, $2, $3)"), Arrays.asList("sum(list)", "sum($1)"), Arrays.asList("sum(n)", "sum($1)"), Arrays.asList("time(from)", "time($1)"), Arrays.asList("time(hour, minute, second)", "time($1, $2, $3)"), Arrays.asList("time(hour, minute, second, offset)", "time($1, $2, $3, $4)"), Arrays.asList("today()", "today()"), Arrays.asList("union(list)", "union($1)"), Arrays.asList("upper case(string)", "upper case($1)"), Arrays.asList("week of year(date)", "week of year($1)"), Arrays.asList("years and months duration(from, to)", "years and months duration($1, $2)"));
    }

    private List<String> buildKeywordSuggestions() {
        return Arrays.asList("for", "return", "if", "then", "else", "some", "every", "satisfies", "instance", "of", "in", "function", "external", "or", "and", "between", "not", "null", "true", "false");
    }

    @Test
    public void testGetKeywordSuggestion() {
        String keyword = "keyword";
        JSONValue kind = (JSONValue)Mockito.mock(JSONValue.class);
        JSONValue insertTextRules = (JSONValue)Mockito.mock(JSONValue.class);
        JSONObject expectedSuggestion = (JSONObject)Mockito.mock(JSONObject.class);
        JSONString keywordStringValue = (JSONString)Mockito.mock(JSONString.class);
        Mockito.when((Object)this.factory.makeJSONNumber(17)).thenReturn((Object)kind);
        Mockito.when((Object)this.factory.makeJSONNumber(4)).thenReturn((Object)insertTextRules);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)expectedSuggestion).when((Object)this.factory)).makeJSONObject();
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)keywordStringValue).when((Object)this.factory)).makeJSONString("keyword");
        JSONValue actualSuggestion = this.factory.getKeywordSuggestion("keyword");
        ((JSONObject)Mockito.verify((Object)expectedSuggestion)).put("kind", kind);
        ((JSONObject)Mockito.verify((Object)expectedSuggestion)).put("insertTextRules", insertTextRules);
        ((JSONObject)Mockito.verify((Object)expectedSuggestion)).put("label", (JSONValue)keywordStringValue);
        ((JSONObject)Mockito.verify((Object)expectedSuggestion)).put("insertText", (JSONValue)keywordStringValue);
        Assert.assertEquals((Object)expectedSuggestion, (Object)actualSuggestion);
    }

    @Test
    public void testGetFunctionSuggestion() {
        String label = "label";
        String insertText = "insertText";
        JSONValue kind = (JSONValue)Mockito.mock(JSONValue.class);
        JSONValue insertTextRules = (JSONValue)Mockito.mock(JSONValue.class);
        JSONObject expectedSuggestion = (JSONObject)Mockito.mock(JSONObject.class);
        JSONString labelString = (JSONString)Mockito.mock(JSONString.class);
        JSONString insertTextString = (JSONString)Mockito.mock(JSONString.class);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)expectedSuggestion).when((Object)this.factory)).makeJSONObject();
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)kind).when((Object)this.factory)).makeJSONNumber(1);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)insertTextRules).when((Object)this.factory)).makeJSONNumber(4);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)labelString).when((Object)this.factory)).makeJSONString("label");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)insertTextString).when((Object)this.factory)).makeJSONString("insertText");
        JSONValue actualSuggestion = this.factory.getFunctionSuggestion("label", "insertText");
        ((JSONObject)Mockito.verify((Object)expectedSuggestion)).put("kind", kind);
        ((JSONObject)Mockito.verify((Object)expectedSuggestion)).put("insertTextRules", insertTextRules);
        ((JSONObject)Mockito.verify((Object)expectedSuggestion)).put("label", (JSONValue)labelString);
        ((JSONObject)Mockito.verify((Object)expectedSuggestion)).put("insertText", (JSONValue)insertTextString);
        Assert.assertEquals((Object)expectedSuggestion, (Object)actualSuggestion);
    }

    @Test
    public void testGetVariableSuggestion() {
        String variable = "variable";
        JSONValue kind = (JSONValue)Mockito.mock(JSONValue.class);
        JSONValue insertTextRules = (JSONValue)Mockito.mock(JSONValue.class);
        JSONObject expectedSuggestion = (JSONObject)Mockito.mock(JSONObject.class);
        JSONString variableStringValue = (JSONString)Mockito.mock(JSONString.class);
        Mockito.when((Object)this.factory.makeJSONNumber(4)).thenReturn((Object)kind, (Object[])new JSONValue[]{insertTextRules});
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)expectedSuggestion).when((Object)this.factory)).makeJSONObject();
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)variableStringValue).when((Object)this.factory)).makeJSONString("variable");
        JSONValue actualSuggestion = this.factory.getVariableSuggestion("variable");
        ((JSONObject)Mockito.verify((Object)expectedSuggestion)).put("kind", kind);
        ((JSONObject)Mockito.verify((Object)expectedSuggestion)).put("insertTextRules", insertTextRules);
        ((JSONObject)Mockito.verify((Object)expectedSuggestion)).put("label", (JSONValue)variableStringValue);
        ((JSONObject)Mockito.verify((Object)expectedSuggestion)).put("insertText", (JSONValue)variableStringValue);
        Assert.assertEquals((Object)expectedSuggestion, (Object)actualSuggestion);
    }

    @Test
    public void testRow() {
        String pattern = "pattern";
        String name = "name";
        JsRegExp regExp = (JsRegExp)Mockito.mock(JsRegExp.class);
        JSONObject jsonRegExp = (JSONObject)Mockito.mock(JSONObject.class);
        JSONString jsonName = (JSONString)Mockito.mock(JSONString.class);
        JSONArray expectedRow = (JSONArray)Mockito.mock(JSONArray.class);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)regExp).when((Object)this.factory)).makeRegExp("pattern");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)jsonRegExp).when((Object)this.factory)).makeJSONObject((Object)regExp);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)jsonName).when((Object)this.factory)).makeJSONString("name");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)expectedRow).when((Object)this.factory)).makeJSONArray();
        JSONArray actualRow = this.factory.row("pattern", "name");
        ((JSONArray)Mockito.verify((Object)expectedRow)).set(0, (JSONValue)jsonRegExp);
        ((JSONArray)Mockito.verify((Object)expectedRow)).set(1, (JSONValue)jsonName);
        Assert.assertEquals((Object)expectedRow, (Object)actualRow);
    }

    @Test
    public void testGetLanguage() {
        JSONString languageId = (JSONString)Mockito.mock(JSONString.class);
        JavaScriptObject expectedLanguage = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)languageId).when((Object)this.factory)).makeJSONString("feel-language");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)expectedLanguage).when((Object)this.factory)).makeJavaScriptObject("id", (JSONValue)languageId);
        JavaScriptObject actualLanguage = this.factory.getLanguage();
        Assert.assertEquals((Object)expectedLanguage, (Object)actualLanguage);
    }

    @Test
    public void testGetCompletionItemProvider() {
        MonacoLanguages.ProvideCompletionItemsFunction provideCompletionItemsFunction = (MonacoLanguages.ProvideCompletionItemsFunction)Mockito.mock(MonacoLanguages.ProvideCompletionItemsFunction.class);
        JSONObject functionObject = (JSONObject)Mockito.mock(JSONObject.class);
        JavaScriptObject expectedCompletionItemProvider = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)provideCompletionItemsFunction).when((Object)this.factory)).getProvideCompletionItemsFunction(this.variableSuggestions);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)functionObject).when((Object)this.factory)).makeJSONObject((Object)provideCompletionItemsFunction);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)expectedCompletionItemProvider).when((Object)this.factory)).makeJavaScriptObject("provideCompletionItems", (JSONValue)functionObject);
        JavaScriptObject actualCompletionItemProvider = this.factory.getCompletionItemProvider(this.variableSuggestions);
        Assert.assertEquals((Object)expectedCompletionItemProvider, (Object)actualCompletionItemProvider);
    }

    @Test
    public void testGetProvideCompletionItemsFunction() {
        JavaScriptObject expectedSuggestions = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        JSONObject expectedJSONObjectSuggestions = (JSONObject)Mockito.mock(JSONObject.class);
        JSONArray suggestions = (JSONArray)Mockito.mock(JSONArray.class);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)expectedJSONObjectSuggestions).when((Object)this.factory)).makeJSONObject();
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)suggestions).when((Object)this.factory)).getSuggestions(this.variableSuggestions);
        Mockito.when((Object)expectedJSONObjectSuggestions.getJavaScriptObject()).thenReturn((Object)expectedSuggestions);
        JavaScriptObject actualSuggestions = this.factory.getProvideCompletionItemsFunction(this.variableSuggestions).call();
        ((JSONObject)Mockito.verify((Object)expectedJSONObjectSuggestions)).put("suggestions", (JSONValue)suggestions);
        Assert.assertEquals((Object)expectedSuggestions, (Object)actualSuggestions);
    }

    @Test
    public void testGetLanguageDefinition() {
        JSONValue tokenizer = (JSONValue)Mockito.mock(JSONValue.class);
        JavaScriptObject expectedLanguageDefinition = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)expectedLanguageDefinition).when((Object)this.factory)).makeJavaScriptObject("tokenizer", tokenizer);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)tokenizer).when((Object)this.factory)).getTokenizer();
        JavaScriptObject actualLanguageDefinition = this.factory.getLanguageDefinition();
        Assert.assertEquals((Object)expectedLanguageDefinition, (Object)actualLanguageDefinition);
    }

    @Test
    public void testGetTokenizer() {
        JSONObject expectedTokenizer = (JSONObject)Mockito.mock(JSONObject.class);
        JSONArray root = (JSONArray)Mockito.mock(JSONArray.class);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)expectedTokenizer).when((Object)this.factory)).makeJSONObject();
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)root).when((Object)this.factory)).getRoot();
        JSONValue actualTokenizer = this.factory.getTokenizer();
        ((JSONObject)Mockito.verify((Object)expectedTokenizer)).put("root", (JSONValue)root);
        Assert.assertEquals((Object)expectedTokenizer, (Object)actualTokenizer);
    }

    @Test
    public void testGetRoot() {
        JSONArray expectedRoot = (JSONArray)Mockito.mock(JSONArray.class);
        JSONArray row1 = (JSONArray)Mockito.mock(JSONArray.class);
        JSONArray row2 = (JSONArray)Mockito.mock(JSONArray.class);
        JSONArray row3 = (JSONArray)Mockito.mock(JSONArray.class);
        JSONArray row4 = (JSONArray)Mockito.mock(JSONArray.class);
        JSONArray row5 = (JSONArray)Mockito.mock(JSONArray.class);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)expectedRoot).when((Object)this.factory)).makeJSONArray();
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)row1).when((Object)this.factory)).row("(?:(\\btrue\\b)|(\\bfalse\\b))", "feel-boolean");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)row2).when((Object)this.factory)).row("[0-9]+", "feel-numeric");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)row3).when((Object)this.factory)).row("(?:\\\"(?:.*?)\\\")", "feel-string");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)row4).when((Object)this.factory)).row("(?:(?:[a-z ]+\\()|(?:\\()|(?:\\)))", "feel-function");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)row5).when((Object)this.factory)).row("(?:(\\bfor\\b)|(\\breturn\\b)|(\\bif\\b)|(\\bthen\\b)|(\\belse\\b)|(\\bsome\\b)|(\\bevery\\b)|(\\bsatisfies\\b)|(\\binstance\\b)|(\\bof\\b)|(\\bin\\b)|(\\bfunction\\b)|(\\bexternal\\b)|(\\bor\\b)|(\\band\\b)|(\\bbetween\\b)|(\\bnot\\b)|(\\bnull\\b)|(\\btrue\\b)|(\\bfalse\\b))", "feel-keyword");
        JSONArray actualRoot = this.factory.getRoot();
        ((MonacoPropertiesFactory)Mockito.verify((Object)this.factory)).push(expectedRoot, (JSONValue)row1);
        ((MonacoPropertiesFactory)Mockito.verify((Object)this.factory)).push(expectedRoot, (JSONValue)row2);
        ((MonacoPropertiesFactory)Mockito.verify((Object)this.factory)).push(expectedRoot, (JSONValue)row3);
        ((MonacoPropertiesFactory)Mockito.verify((Object)this.factory)).push(expectedRoot, (JSONValue)row4);
        ((MonacoPropertiesFactory)Mockito.verify((Object)this.factory)).push(expectedRoot, (JSONValue)row5);
        Assert.assertEquals((Object)expectedRoot, (Object)actualRoot);
    }
}

