/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns;

import com.ait.lienzo.client.core.shape.Text;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.BaseValueAndDataTypeHeaderMetaDataTest;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.GridRendererTheme;

public abstract class BaseNameAndDataTypeHeaderMetaDataTest
extends BaseValueAndDataTypeHeaderMetaDataTest<Name, HasName> {
    protected static final String NAME_DATA_TYPE_COLUMN_GROUP = "NameAndDataTypeHeaderMetaDataTest$NameAndDataTypeColumn";
    protected static final Name NAME = new Name("name");
    protected static final double SPACING = 8.0;
    protected static final String FONT_STYLE_TYPE_REF = "italic";
    protected Decision hasExpression = new Decision();

    @Override
    protected Name makeValue() {
        return NAME;
    }

    @Override
    protected Name makeEmptyValue() {
        return new Name();
    }

    @Override
    protected HasName makeHasValue() {
        return this.hasExpression;
    }

    @Test
    public void testGetTitleWithHasName() {
        Decision decision = new Decision();
        decision.setName(NAME);
        this.setup(Optional.of(decision));
        Assertions.assertThat((String)this.metaData.getTitle()).isEqualTo(NAME.getValue());
    }

    @Test
    public void testGetDisplayNameWithHasName() {
        Decision decision = new Decision();
        decision.setName(NAME);
        this.setup(Optional.of(decision));
        Assertions.assertThat((Object)this.metaData.getValue()).isEqualTo((Object)NAME);
    }

    @Test
    public void testSetDisplayNameWithHasName() {
        Decision decision = new Decision();
        this.setup(Optional.of(decision));
        this.metaData.setValue((Object)NAME);
        ((BiConsumer)Mockito.verify((Object)this.setValueConsumer)).accept(Matchers.eq((Object)decision), Matchers.eq((Object)NAME));
    }

    @Test
    public void testSetValueWithHasNameWithEmptyValue() {
        Decision decision = new Decision();
        decision.setName(NAME);
        this.setup(Optional.of(decision));
        this.metaData.setValue((Object)new Name());
        ((Consumer)Mockito.verify((Object)this.clearValueConsumer)).accept(Matchers.eq((Object)decision));
    }

    @Test
    public void testSetValueWithHasNameWithoutChange() {
        Decision decision = new Decision();
        decision.setName(NAME);
        this.setup(Optional.of(decision));
        this.metaData.setValue((Object)NAME);
        ((Consumer)Mockito.verify((Object)this.clearValueConsumer, (VerificationMode)Mockito.never())).accept(Matchers.any(HasName.class));
        ((BiConsumer)Mockito.verify((Object)this.setValueConsumer, (VerificationMode)Mockito.never())).accept(Matchers.any(HasName.class), Matchers.any(Name.class));
    }

    @Test
    public void testSetValueWithoutHasName() {
        this.setup(Optional.empty());
        this.metaData.setValue((Object)NAME);
        ((BiConsumer)Mockito.verify((Object)this.setValueConsumer, (VerificationMode)Mockito.never())).accept(Matchers.any(HasName.class), Matchers.any(Name.class));
    }

    @Override
    @Test
    public void testToModelValue() {
        this.setup(Optional.empty());
        Assertions.assertThat((Object)this.metaData.toModelValue(NAME.getValue())).isEqualTo((Object)NAME);
    }

    @Override
    @Test
    public void testToWidgetValue() {
        this.setup(Optional.empty());
        Assertions.assertThat((String)this.metaData.toWidgetValue((Object)NAME)).isEqualTo(NAME.getValue());
    }

    @Override
    @Test
    public void testGetValueLabel() {
        this.setup(Optional.empty());
        Assertions.assertThat((String)this.metaData.getValueLabel()).isEqualTo("NameAndDataTypePopover.NameLabel");
    }

    @Override
    @Test
    public void testNormaliseValue() {
        this.setup(Optional.empty());
        String value = "   " + NAME.getValue() + "   ";
        Assertions.assertThat((String)this.metaData.normaliseValue(value)).isEqualTo(NAME.getValue());
    }

    @Override
    @Test
    public void testRender() {
        QName typeRef = BuiltInType.DATE.asQName();
        GridRenderer renderer = (GridRenderer)Mockito.mock(GridRenderer.class);
        GridRendererTheme theme = (GridRendererTheme)Mockito.mock(GridRendererTheme.class);
        Text tName = (Text)Mockito.mock(Text.class);
        InformationItemPrimary hasExpressionVariable = new InformationItemPrimary();
        hasExpressionVariable.setTypeRef(typeRef);
        this.hasExpression.setVariable(hasExpressionVariable);
        Decision decision = new Decision();
        decision.setName(NAME);
        this.setup(Optional.of(decision));
        Mockito.when((Object)theme.getHeaderText()).thenReturn((Object)tName);
        Mockito.when((Object)this.context.getRenderer()).thenReturn((Object)renderer);
        Mockito.when((Object)renderer.getTheme()).thenReturn((Object)theme);
        Mockito.when((Object)this.hasTypeRef.getTypeRef()).thenReturn((Object)typeRef);
        this.metaData.render(this.context, 10.0, 20.0);
        ((Text)Mockito.verify((Object)tName)).setText(NAME.getValue());
        ((Text)Mockito.verify((Object)tName, (VerificationMode)Mockito.times((int)2))).setListening(false);
        ((Text)Mockito.verify((Object)tName, (VerificationMode)Mockito.times((int)2))).setX(5.0);
        ((Text)Mockito.verify((Object)tName)).setY(2.0);
        ((Text)Mockito.verify((Object)tName)).setFontStyle(FONT_STYLE_TYPE_REF);
        ((Text)Mockito.verify((Object)tName)).setFontSize(8.0);
        ((Text)Mockito.verify((Object)tName)).setText("(" + typeRef.toString() + ")");
        ((Text)Mockito.verify((Object)tName)).setY(18.0);
    }
}

