/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns;

import com.ait.lienzo.client.core.shape.Text;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.HasValue;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.types.ValueAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.ValueAndDataTypeHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridHeaderColumnRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.GridRendererTheme;

public abstract class BaseValueAndDataTypeHeaderMetaDataTest<V, HV extends HasValue<V>> {
    protected static final double BLOCK_WIDTH = 10.0;
    protected static final double BLOCK_HEIGHT = 20.0;
    protected final String PLACEHOLDER = "placeholder";
    protected static final String POPOVER_TITLE = "title";
    @Mock
    protected HasTypeRef hasTypeRef;
    @Mock
    protected Consumer<HV> clearValueConsumer;
    @Mock
    protected BiConsumer<HV, V> setValueConsumer;
    @Mock
    protected BiConsumer<HasTypeRef, QName> setTypeRefConsumer;
    @Mock
    protected TranslationService translationService;
    @Mock
    protected CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    protected ValueAndDataTypePopoverView.Presenter headerEditor;
    @Mock
    protected EditableHeaderMetaData headerMetaData;
    @Mock
    protected GridHeaderColumnRenderContext context;
    @Mock
    protected ValueAndDataTypeHeaderMetaData<V, HV> metaData;

    protected abstract V makeValue();

    protected abstract V makeEmptyValue();

    protected abstract HV makeHasValue();

    protected abstract void setup(Optional<HV> var1);

    @Test
    public abstract void testToModelValue();

    @Test
    public abstract void testToWidgetValue();

    @Test
    public abstract void testGetValueLabel();

    @Test
    public abstract void testNormaliseValue();

    @Test
    public abstract void testRender();

    @Test
    public void testGetPresenter() {
        this.setup(Optional.empty());
        Assertions.assertThat((Object)this.metaData.getPresenter()).isEqualTo(this.metaData);
    }

    @Test
    public void testGetTitleWithoutHasName() {
        this.setup(Optional.empty());
        Assertions.assertThat((String)this.metaData.getTitle()).isEqualTo(HasName.NOP.getName().getValue());
    }

    @Test
    public void testGetDisplayNameWithoutHasName() {
        this.setup(Optional.empty());
        Assertions.assertThat((Object)this.metaData.getValue()).isEqualTo((Object)HasName.NOP.getName());
    }

    @Test
    public void testGetTypeRef() {
        this.setup(Optional.empty());
        this.metaData.getTypeRef();
        ((HasTypeRef)Mockito.verify((Object)this.hasTypeRef)).getTypeRef();
    }

    @Test
    public void testSetDisplayNameWithHasValue() {
        V value = this.makeValue();
        HV hasValue = this.makeHasValue();
        this.setup(Optional.of(hasValue));
        this.metaData.setValue(value);
        ((BiConsumer)Mockito.verify(this.setValueConsumer)).accept(Matchers.eq(hasValue), Matchers.eq(value));
    }

    @Test
    public void testSetValueWithHasValueWithEmptyValue() {
        V value = this.makeValue();
        V emptyValue = this.makeEmptyValue();
        HV hasValue = this.makeHasValue();
        hasValue.setValue(value);
        this.setup(Optional.of(hasValue));
        this.metaData.setValue(emptyValue);
        ((Consumer)Mockito.verify(this.clearValueConsumer)).accept(Matchers.eq(hasValue));
    }

    @Test
    public void testSetValueWithHasValueWithoutChange() {
        HV hasValue = this.makeHasValue();
        this.setup(Optional.of(hasValue));
        this.metaData.setValue(hasValue.getValue());
        ((Consumer)Mockito.verify(this.clearValueConsumer, (VerificationMode)Mockito.never())).accept(Matchers.any());
        ((BiConsumer)Mockito.verify(this.setValueConsumer, (VerificationMode)Mockito.never())).accept(Matchers.any(), Matchers.any());
    }

    @Test
    public void testSetValueWithoutHasValue() {
        this.setup(Optional.empty());
        this.metaData.setValue(this.makeValue());
        ((BiConsumer)Mockito.verify(this.setValueConsumer, (VerificationMode)Mockito.never())).accept(Matchers.any(), Matchers.any());
    }

    @Test
    public void testSetTypeRef() {
        this.setup(Optional.empty());
        QName typeRef = new QName();
        this.metaData.setTypeRef(typeRef);
        ((BiConsumer)Mockito.verify(this.setTypeRefConsumer)).accept(Matchers.eq((Object)this.hasTypeRef), Matchers.eq((Object)typeRef));
    }

    @Test
    public void testSetTypeRefWithoutChange() {
        this.setup(Optional.empty());
        QName typeRef = new QName();
        Mockito.when((Object)this.hasTypeRef.getTypeRef()).thenReturn((Object)typeRef);
        this.metaData.setTypeRef(typeRef);
        ((BiConsumer)Mockito.verify(this.setTypeRefConsumer, (VerificationMode)Mockito.never())).accept(Matchers.any(HasTypeRef.class), Matchers.any(QName.class));
    }

    @Test
    public void testIsEmptyValue_WhenNull() {
        this.setup(Optional.empty());
        Assertions.assertThat((boolean)this.metaData.isEmptyValue(null)).isTrue();
    }

    @Test
    public void testIsEmptyValue_WhenEmptyString() {
        this.setup(Optional.empty());
        Assertions.assertThat((boolean)this.metaData.isEmptyValue(this.makeEmptyValue())).isTrue();
    }

    @Test
    public void testGetValue() {
        V value = this.makeEmptyValue();
        HV hasValue = this.makeHasValue();
        this.setup(Optional.of(hasValue));
        hasValue.setValue(value);
        Assertions.assertThat((Object)this.metaData.getValue()).isNotNull();
        Assertions.assertThat((Object)this.metaData.getValue()).isEqualTo(value);
    }

    @Test
    public void testGetPopoverTitle() {
        this.setup(Optional.empty());
        Assertions.assertThat((String)this.metaData.getPopoverTitle()).isEqualTo(POPOVER_TITLE);
    }

    @Test
    public void testAsDMNModelInstrumentedBase() {
        Decision decision = new Decision();
        this.setup(Optional.empty());
        Mockito.when((Object)this.hasTypeRef.asDMNModelInstrumentedBase()).thenReturn((Object)decision);
        Assertions.assertThat((Object)this.metaData.asDMNModelInstrumentedBase()).isEqualTo((Object)decision);
    }

    @Test
    public void testRenderPlaceHolder() {
        GridRenderer renderer = (GridRenderer)Mockito.mock(GridRenderer.class);
        GridRendererTheme theme = (GridRendererTheme)Mockito.mock(GridRendererTheme.class);
        Text text = (Text)Mockito.mock(Text.class);
        this.setup(Optional.empty());
        Mockito.when((Object)this.context.getRenderer()).thenReturn((Object)renderer);
        Mockito.when((Object)renderer.getTheme()).thenReturn((Object)theme);
        Mockito.when((Object)theme.getPlaceholderText()).thenReturn((Object)text);
        this.metaData.renderPlaceHolder(this.context, 10.0, 20.0);
        ((Text)Mockito.verify((Object)text)).setX(5.0);
        ((Text)Mockito.verify((Object)text)).setY(10.0);
        ((Text)Mockito.verify((Object)text)).setText("placeholder");
        ((Text)Mockito.verify((Object)text)).setListening(false);
    }
}

