/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.controls.container;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Element;
import java.util.Optional;
import java.util.function.Consumer;
import org.jboss.errai.common.client.dom.Body;
import org.jboss.errai.common.client.dom.CSSStyleDeclaration;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Document;
import org.jboss.errai.common.client.dom.EventListener;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.CanBeClosedByKeyboard;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.PopupEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsViewImpl;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class CellEditorControlsViewImplTest {
    @Mock
    private Document document;
    @Mock
    private Div cellEditorControls;
    @Mock
    private Div cellEditorControlsContainer;
    @Mock
    private Body body;
    @Mock
    private ElementWrapperWidget<?> elementWrapperWidget;
    @Captor
    private ArgumentCaptor<EventListener> mouseDownListenerCaptor;
    @Captor
    private ArgumentCaptor<EventListener> mouseWheelListenerCaptor;
    private CellEditorControlsViewImpl view;

    @Before
    public void setup() {
        Mockito.when((Object)this.document.getBody()).thenReturn((Object)this.body);
        this.view = (CellEditorControlsViewImpl)Mockito.spy((Object)new CellEditorControlsViewImpl(this.document, this.cellEditorControls, this.cellEditorControlsContainer));
        ((CellEditorControlsViewImpl)Mockito.doReturn(this.elementWrapperWidget).when((Object)this.view)).getWidget();
        ((CellEditorControlsViewImpl)Mockito.doNothing().when((Object)this.view)).addWidgetToRootPanel((ElementWrapperWidget)Matchers.any());
        ((CellEditorControlsViewImpl)Mockito.doNothing().when((Object)this.view)).removeWidgetFromRootPanel((ElementWrapperWidget)Matchers.any());
    }

    @Test
    public void testPostConstruct() {
        this.view.setup();
        ((CellEditorControlsViewImpl)Mockito.verify((Object)this.view)).addWidgetToRootPanel(this.elementWrapperWidget);
        ((Body)Mockito.verify((Object)this.body)).addEventListener((String)Matchers.eq((Object)"mousedown"), (EventListener)this.mouseDownListenerCaptor.capture(), Matchers.eq((boolean)false));
        ((Body)Mockito.verify((Object)this.body)).addEventListener((String)Matchers.eq((Object)"mousewheel"), (EventListener)this.mouseWheelListenerCaptor.capture(), Matchers.eq((boolean)false));
    }

    @Test
    public void testPreDestroy() {
        this.testPostConstruct();
        this.view.destroy();
        ((CellEditorControlsViewImpl)Mockito.verify((Object)this.view)).removeWidgetFromRootPanel(this.elementWrapperWidget);
        ((Body)Mockito.verify((Object)this.body)).removeEventListener((String)Matchers.eq((Object)"mousedown"), (EventListener)Matchers.eq((Object)this.mouseDownListenerCaptor.getValue()), Matchers.eq((boolean)false));
        ((Body)Mockito.verify((Object)this.body)).removeEventListener((String)Matchers.eq((Object)"mousewheel"), (EventListener)Matchers.eq((Object)this.mouseWheelListenerCaptor.getValue()), Matchers.eq((boolean)false));
    }

    @Test
    public void testShow() {
        PopupEditorControls editor = (PopupEditorControls)Mockito.mock(PopupEditorControls.class);
        int x = 10;
        int y = 20;
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        ((CellEditorControlsViewImpl)Mockito.doReturn((Object)element).when((Object)this.view)).getElement();
        CSSStyleDeclaration style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        Mockito.when((Object)element.getStyle()).thenReturn((Object)style);
        this.view.show(editor, 10, 20);
        ((CSSStyleDeclaration)Mockito.verify((Object)style)).setProperty("left", "10px");
        ((CSSStyleDeclaration)Mockito.verify((Object)style)).setProperty("top", "20px");
        ((CellEditorControlsViewImpl)Mockito.verify((Object)this.view)).setOnClosedByKeyboardCallback(editor);
        ((PopupEditorControls)Mockito.verify((Object)editor)).show();
    }

    @Test
    public void testSetOnClosedByKeyboardCallback() {
        PopupEditorControls editor = (PopupEditorControls)Mockito.mock(PopupEditorControls.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{CanBeClosedByKeyboard.class}));
        this.view.setOnClosedByKeyboardCallback(editor);
        ((CanBeClosedByKeyboard)Mockito.verify((Object)editor)).setOnClosedByKeyboardCallback((Consumer)Matchers.any());
    }

    @Test
    public void testRemoveOnClosedByKeyboardCallback() {
        PopupEditorControls editor = (PopupEditorControls)Mockito.mock(PopupEditorControls.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{CanBeClosedByKeyboard.class}));
        this.view.removeOnClosedByKeyboardCallback(editor);
        ((CanBeClosedByKeyboard)Mockito.verify((Object)editor)).setOnClosedByKeyboardCallback(null);
    }

    @Test
    public void testFocusOnDMNContainer() {
        Element dmnContainerElement = (Element)Mockito.mock(Element.class);
        ((CellEditorControlsViewImpl)Mockito.doReturn((Object)dmnContainerElement).when((Object)this.view)).getDMNContainer();
        this.view.focusOnDMNContainer(null);
        ((Element)Mockito.verify((Object)dmnContainerElement)).focus();
    }

    @Test
    public void testHide() {
        PopupEditorControls editor = (PopupEditorControls)Mockito.mock(PopupEditorControls.class);
        Optional<PopupEditorControls> activeEditor = Optional.of(editor);
        ((CellEditorControlsViewImpl)Mockito.doReturn(activeEditor).when((Object)this.view)).getActiveEditor();
        this.view.hide();
        ((PopupEditorControls)Mockito.verify((Object)editor)).hide();
        ((CellEditorControlsViewImpl)Mockito.verify((Object)this.view)).removeOnClosedByKeyboardCallback(editor);
        ((CellEditorControlsViewImpl)Mockito.verify((Object)this.view)).setActiveEditor(Optional.empty());
    }
}

