/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.controls.popover;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Event;
import elemental2.dom.KeyboardEvent;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.popover.AbstractPopoverViewImpl;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.PopoverOptions;

@RunWith(value=GwtMockitoTestRunner.class)
public class AbstractPopoverViewImplTest {
    private AbstractPopoverViewImpl view;

    @Before
    public void setup() {
        this.view = (AbstractPopoverViewImpl)Mockito.spy((Object)new AbstractPopoverViewImpl(){});
    }

    @Test
    public void testCreateOptions() {
        PopoverOptions options = (PopoverOptions)Mockito.mock(PopoverOptions.class);
        ((AbstractPopoverViewImpl)Mockito.doReturn((Object)options).when((Object)this.view)).createPopoverOptionsInstance();
        this.view.createOptions();
        ((PopoverOptions)Mockito.verify((Object)options)).setAnimation(Boolean.valueOf(false));
        ((PopoverOptions)Mockito.verify((Object)options)).setHtml(Boolean.valueOf(true));
        ((PopoverOptions)Mockito.verify((Object)options)).setPlacement("auto top");
    }

    @Test
    public void testOnClosedByKeyboard() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        Optional<Consumer> opt = Optional.of(consumer);
        ((AbstractPopoverViewImpl)Mockito.doReturn(opt).when((Object)this.view)).getClosedByKeyboardCallback();
        this.view.onClosedByKeyboard();
        ((Consumer)Mockito.verify((Object)consumer)).accept(this.view);
    }

    @Test
    public void testSetOnClosedByKeyboardCallback() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        this.view.setOnClosedByKeyboardCallback(consumer);
        Optional actual = this.view.getClosedByKeyboardCallback();
        Assert.assertTrue((boolean)actual.isPresent());
        Assert.assertEquals((Object)consumer, actual.get());
    }

    @Test
    public void testSetOnClosedByKeyboardCallbackNullCallback() {
        this.view.setOnClosedByKeyboardCallback(null);
        Optional actual = this.view.getClosedByKeyboardCallback();
        Assert.assertFalse((boolean)actual.isPresent());
        Assert.assertEquals(Optional.empty(), (Object)actual);
    }

    @Test
    public void testKeyDownEventListenerEnterKey() {
        KeyboardEvent event = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        ((AbstractPopoverViewImpl)Mockito.doNothing().when((Object)this.view)).hide();
        ((AbstractPopoverViewImpl)Mockito.doNothing().when((Object)this.view)).onClosedByKeyboard();
        ((AbstractPopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isEnterKeyPressed(event);
        this.view.keyDownEventListener((Object)event);
        ((AbstractPopoverViewImpl)Mockito.verify((Object)this.view)).hide();
        ((KeyboardEvent)Mockito.verify((Object)event)).stopPropagation();
        ((AbstractPopoverViewImpl)Mockito.verify((Object)this.view)).onClosedByKeyboard();
        ((AbstractPopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).isEscapeKeyPressed(event);
    }

    @Test
    public void testKeyDownEventListenerEscKey() {
        KeyboardEvent event = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        ((AbstractPopoverViewImpl)Mockito.doNothing().when((Object)this.view)).hide();
        ((AbstractPopoverViewImpl)Mockito.doNothing().when((Object)this.view)).reset();
        ((AbstractPopoverViewImpl)Mockito.doNothing().when((Object)this.view)).onClosedByKeyboard();
        ((AbstractPopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEnterKeyPressed(event);
        ((AbstractPopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isEscapeKeyPressed(event);
        this.view.keyDownEventListener((Object)event);
        ((AbstractPopoverViewImpl)Mockito.verify((Object)this.view)).hide();
        ((AbstractPopoverViewImpl)Mockito.verify((Object)this.view)).reset();
        ((AbstractPopoverViewImpl)Mockito.verify((Object)this.view)).onClosedByKeyboard();
    }

    @Test
    public void testKeyDownEventListenerWhenIsNotAHandledKey() {
        KeyboardEvent event = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        ((AbstractPopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEnterKeyPressed(event);
        ((AbstractPopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEscapeKeyPressed(event);
        this.view.keyDownEventListener((Object)event);
        ((AbstractPopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide();
        ((KeyboardEvent)Mockito.verify((Object)event, (VerificationMode)Mockito.never())).stopPropagation();
        ((AbstractPopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).onClosedByKeyboard();
        ((AbstractPopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).reset();
    }

    @Test
    public void testKeyDownEventListenerWhenIsNotKeyboardEvent() {
        Event event = (Event)Mockito.mock(Event.class);
        this.view.keyDownEventListener((Object)event);
        ((AbstractPopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide();
        ((Event)Mockito.verify((Object)event, (VerificationMode)Mockito.never())).stopPropagation();
        ((AbstractPopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).onClosedByKeyboard();
        ((AbstractPopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).isEscapeKeyPressed((KeyboardEvent)Matchers.any());
        ((AbstractPopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).reset();
    }
}

