/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.canvas.controls.actions;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.definition.model.TextAnnotation;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.client.canvas.controls.actions.TextAnnotationTextPropertyProviderImpl;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProvider;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TextAnnotationTextPropertyProviderImplTest {
    private static final String NAME_FIELD = "name";
    private static final String NAME_VALUE = "text";
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private DefaultCanvasCommandFactory canvasCommandFactory;
    @Mock
    private Element<Definition> element;
    @Mock
    private Definition content;
    @Mock
    private TextAnnotation definition;
    @Mock
    private Text text;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private CanvasCommandManager<AbstractCanvasHandler> commandManager;
    @Mock
    private CanvasCommand<AbstractCanvasHandler> command;
    private TextPropertyProvider provider;

    @Before
    public void setup() {
        this.provider = new TextAnnotationTextPropertyProviderImpl(this.canvasCommandFactory, this.definitionUtils);
        Mockito.when((Object)this.element.getContent()).thenReturn((Object)this.content);
        Mockito.when((Object)this.content.getDefinition()).thenReturn((Object)this.definition);
        Mockito.when((Object)this.definition.getText()).thenReturn((Object)this.text);
        Mockito.when((Object)this.definitionUtils.getNameIdentifier(ArgumentMatchers.eq((Object)this.definition))).thenReturn((Object)NAME_FIELD);
        Mockito.when((Object)this.canvasCommandFactory.updatePropertyValue((Element)ArgumentMatchers.eq(this.element), (String)Mockito.any(), Mockito.any())).thenReturn(this.command);
    }

    @Test
    public void checkPriorityLessThanCatchAll() {
        Assert.assertTrue((this.provider.getPriority() < Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    public void checkSupportsTextAnnotationElements() {
        Assert.assertTrue((boolean)this.provider.supports(this.element));
        Element other = (Element)Mockito.mock(Element.class);
        Definition otherContent = (Definition)Mockito.mock(Definition.class);
        InputData otherDefinition = (InputData)Mockito.mock(InputData.class);
        Mockito.when((Object)other.getContent()).thenReturn((Object)otherContent);
        Mockito.when((Object)otherContent.getDefinition()).thenReturn((Object)otherDefinition);
        Assert.assertFalse((boolean)this.provider.supports(other));
    }

    @Test
    public void checkReadGetsTextFromTextProperty() {
        this.provider.getText(this.element);
        ((Text)Mockito.verify((Object)this.text)).getValue();
    }

    @Test
    public void checkWriteUsesCommandToUpdateTextProperty() {
        this.provider.setText(this.canvasHandler, this.commandManager, this.element, NAME_VALUE);
        ((DefaultCanvasCommandFactory)Mockito.verify((Object)this.canvasCommandFactory)).updatePropertyValue(this.element, NAME_FIELD, (Object)NAME_VALUE);
        ((CanvasCommandManager)Mockito.verify(this.commandManager)).execute(ArgumentMatchers.eq((Object)this.canvasHandler), (Command)ArgumentMatchers.eq(this.command));
    }
}

