/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.canvas.controls.toolbox;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.client.canvas.controls.toolbox.DMNEditBusinessKnowledgeModelToolboxAction;
import org.kie.workbench.common.dmn.client.events.EditExpressionEvent;
import org.kie.workbench.common.stunner.core.client.ReadOnlyProvider;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.graph.processing.index.Index;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNEditBusinessKnowledgeModelToolboxActionTest {
    private static final String E_UUID = "e1";
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Index<?, ?> graphIndex;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private ClientSession session;
    @Mock
    private ClientTranslationService translationService;
    @Mock
    private EventSourceMock<EditExpressionEvent> editExpressionEvent;
    @Mock
    private MouseClickEvent mouseClickEvent;
    @Mock
    private ReadOnlyProvider readOnlyProvider;
    private DMNEditBusinessKnowledgeModelToolboxAction tested;
    private BusinessKnowledgeModel bkm;
    private Node<View<BusinessKnowledgeModel>, Edge> bkmNode;

    @Before
    public void setup() throws Exception {
        this.bkmNode = new NodeImpl(E_UUID);
        this.bkm = new BusinessKnowledgeModel();
        Bounds bounds = Bounds.create((double)0.0, (double)0.0, (double)100.0, (double)150.0);
        ViewImpl nodeContent = new ViewImpl((Object)this.bkm, bounds);
        this.bkmNode.setContent((Object)nodeContent);
        Mockito.when((Object)this.canvasHandler.getGraphIndex()).thenReturn(this.graphIndex);
        Mockito.when((Object)this.graphIndex.get((String)ArgumentMatchers.eq((Object)E_UUID))).thenReturn(this.bkmNode);
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        this.tested = new DMNEditBusinessKnowledgeModelToolboxAction(this.sessionManager, this.translationService, this.editExpressionEvent, this.readOnlyProvider);
    }

    @Test
    public void testTitle() {
        this.tested.getTitle(this.canvasHandler, E_UUID);
        ((ClientTranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.times((int)1))).getValue((String)ArgumentMatchers.eq((Object)"org.kie.workbench.common.stunner.core.edit"));
    }

    @Test
    public void testAction() {
        ToolboxAction cascade = this.tested.onMouseClick(this.canvasHandler, E_UUID, this.mouseClickEvent);
        Assert.assertEquals((Object)this.tested, (Object)cascade);
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(EditExpressionEvent.class);
        ((EventSourceMock)Mockito.verify(this.editExpressionEvent, (VerificationMode)Mockito.times((int)1))).fire(eventCaptor.capture());
        EditExpressionEvent editExprEvent = (EditExpressionEvent)eventCaptor.getValue();
        Assert.assertEquals((Object)E_UUID, (Object)editExprEvent.getNodeUUID());
        HasExpression hasExpression = editExprEvent.getHasExpression();
        Assert.assertEquals((Object)this.bkm.getEncapsulatedLogic(), (Object)hasExpression.getExpression());
        Assert.assertEquals((Object)this.bkm, (Object)hasExpression.asDMNModelInstrumentedBase());
        Assert.assertFalse((boolean)hasExpression.isClearSupported());
        Assert.assertEquals((Object)this.bkm, editExprEvent.getHasName().get());
        Assert.assertEquals((Object)this.session, (Object)editExprEvent.getSession());
        Assert.assertFalse((boolean)editExprEvent.isOnlyVisualChangeAllowed());
    }

    @Test
    public void testActionWhenIsReadOnlyDiagram() {
        Mockito.when((Object)this.readOnlyProvider.isReadOnlyDiagram()).thenReturn((Object)true);
        ToolboxAction cascade = this.tested.onMouseClick(this.canvasHandler, E_UUID, this.mouseClickEvent);
        Assert.assertEquals((Object)this.tested, (Object)cascade);
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(EditExpressionEvent.class);
        ((EventSourceMock)Mockito.verify(this.editExpressionEvent, (VerificationMode)Mockito.times((int)1))).fire(eventCaptor.capture());
        EditExpressionEvent editExprEvent = (EditExpressionEvent)eventCaptor.getValue();
        Assert.assertEquals((Object)E_UUID, (Object)editExprEvent.getNodeUUID());
        HasExpression hasExpression = editExprEvent.getHasExpression();
        Assert.assertEquals((Object)this.bkm.getEncapsulatedLogic(), (Object)hasExpression.getExpression());
        Assert.assertEquals((Object)this.bkm, (Object)hasExpression.asDMNModelInstrumentedBase());
        Assert.assertFalse((boolean)hasExpression.isClearSupported());
        Assert.assertEquals((Object)this.bkm, editExprEvent.getHasName().get());
        Assert.assertEquals((Object)this.session, (Object)editExprEvent.getSession());
        Assert.assertTrue((boolean)editExprEvent.isOnlyVisualChangeAllowed());
    }

    @Test
    public void testActionSetExpression() {
        this.tested.onMouseClick(this.canvasHandler, E_UUID, this.mouseClickEvent);
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(EditExpressionEvent.class);
        ((EventSourceMock)Mockito.verify(this.editExpressionEvent, (VerificationMode)Mockito.times((int)1))).fire(eventCaptor.capture());
        EditExpressionEvent editExprEvent = (EditExpressionEvent)eventCaptor.getValue();
        HasExpression hasExpression = editExprEvent.getHasExpression();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> hasExpression.setExpression((Expression)new DecisionTable())).isInstanceOf(UnsupportedOperationException.class)).hasMessage("It is not possible to set the EncapsulatedLogic of a BusinessKnowledgeModel.");
    }
}

