/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.canvas.controls.toolbox;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.CSSStyleDeclaration;
import elemental2.dom.DomGlobal;
import elemental2.dom.HTMLBodyElement;
import elemental2.dom.HTMLDocument;
import elemental2.dom.HTMLElement;
import java.lang.reflect.Field;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.canvas.controls.toolbox.DMNEditDRDToolboxAction;
import org.kie.workbench.common.dmn.client.editors.drd.DRDContextMenu;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.shape.ImageDataUriGlyph;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.graph.processing.index.Index;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNEditDRDToolboxActionTest {
    private static final String UUID = "UUID";
    private DMNEditDRDToolboxAction dmnEditDRDToolboxAction;
    private Element node;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Index<?, ?> graphIndex;
    @Mock
    private DRDContextMenu drdContextMenu;
    @Mock
    private MouseClickEvent mouseClickEvent;

    @Before
    public void setUp() {
        this.node = new NodeImpl(UUID);
        Mockito.when((Object)this.canvasHandler.getGraphIndex()).thenReturn(this.graphIndex);
        Mockito.when((Object)this.graphIndex.get((String)ArgumentMatchers.eq((Object)UUID))).thenReturn((Object)this.node);
        this.dmnEditDRDToolboxAction = new DMNEditDRDToolboxAction(this.drdContextMenu);
    }

    @Test
    public void testGetGlyph() {
        Assertions.assertThat((Object)this.dmnEditDRDToolboxAction.getGlyph(this.canvasHandler, UUID)).isNotNull();
        Assertions.assertThat((Object)this.dmnEditDRDToolboxAction.getGlyph(this.canvasHandler, UUID)).isInstanceOf(ImageDataUriGlyph.class);
    }

    @Test
    public void testGetTitle() {
        String title = "TITLE";
        Mockito.when((Object)this.drdContextMenu.getTitle()).thenReturn((Object)"TITLE");
        Assertions.assertThat((String)this.dmnEditDRDToolboxAction.getTitle(this.canvasHandler, UUID)).isEqualTo("TITLE");
    }

    @Test
    public void testOnMouseClick() throws NoSuchFieldException, IllegalAccessException {
        HTMLElement htmlElement = new HTMLElement();
        htmlElement.style = new CSSStyleDeclaration();
        HTMLDocument htmlDocument = new HTMLDocument();
        htmlDocument.body = new HTMLBodyElement();
        Field field = DomGlobal.class.getDeclaredField("document");
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(DomGlobal.class, htmlDocument);
        Mockito.when((Object)this.drdContextMenu.getElement()).thenReturn((Object)htmlElement);
        this.dmnEditDRDToolboxAction.onMouseClick(this.canvasHandler, UUID, this.mouseClickEvent);
        ((DRDContextMenu)Mockito.verify((Object)this.drdContextMenu, (VerificationMode)Mockito.times((int)1))).show((Collection)Mockito.any());
    }
}

