/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.canvas.controls.toolbox;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.canvas.controls.toolbox.DMNToolboxControl;
import org.kie.workbench.common.stunner.core.client.ManagedInstanceStub;
import org.kie.workbench.common.stunner.core.client.ReadOnlyProvider;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolboxFactory;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNToolboxControlTest {
    @Mock
    private ActionsToolboxFactory flowActionsToolboxFactoryInstance;
    private ManagedInstanceStub<ActionsToolboxFactory> flowActionsToolboxFactory;
    @Mock
    private ActionsToolboxFactory commonActionsToolboxFactoryInstance;
    private ManagedInstanceStub<ActionsToolboxFactory> commonActionsToolboxFactory;
    @Mock
    private ReadOnlyProvider readonlyProvider;
    private DMNToolboxControl tested;

    @Before
    public void setup() throws Exception {
        this.flowActionsToolboxFactory = (ManagedInstanceStub)Mockito.spy((Object)new ManagedInstanceStub((Object[])new ActionsToolboxFactory[]{this.flowActionsToolboxFactoryInstance}));
        this.commonActionsToolboxFactory = (ManagedInstanceStub)Mockito.spy((Object)new ManagedInstanceStub((Object[])new ActionsToolboxFactory[]{this.commonActionsToolboxFactoryInstance}));
        this.tested = new DMNToolboxControl(this.flowActionsToolboxFactory, this.commonActionsToolboxFactory, this.readonlyProvider);
    }

    @Test
    public void testRegisterTheRightFactories() {
        List factories = this.tested.getFactories();
        Assert.assertNotNull((Object)factories);
        Assert.assertEquals((long)2L, (long)factories.size());
        Assert.assertEquals((Object)this.flowActionsToolboxFactoryInstance, factories.get(0));
        Assert.assertEquals((Object)this.commonActionsToolboxFactoryInstance, factories.get(1));
    }

    @Test
    public void testGetFactoriesWhenIsReadOnlyDiagram() {
        Mockito.when((Object)this.readonlyProvider.isReadOnlyDiagram()).thenReturn((Object)true);
        this.tested.getFactories();
        ((ManagedInstanceStub)Mockito.verify(this.commonActionsToolboxFactory)).get();
        ((ManagedInstanceStub)Mockito.verify(this.flowActionsToolboxFactory, (VerificationMode)Mockito.never())).get();
    }

    @Test
    public void testGetFactoriesWhenIsNotReadOnlyDiagram() {
        Mockito.when((Object)this.readonlyProvider.isReadOnlyDiagram()).thenReturn((Object)false);
        this.tested.getFactories();
        ((ManagedInstanceStub)Mockito.verify(this.commonActionsToolboxFactory)).get();
        ((ManagedInstanceStub)Mockito.verify(this.flowActionsToolboxFactory)).get();
    }
}

