/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.clone;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasText;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource;
import org.kie.workbench.common.dmn.api.definition.model.NamedElement;
import org.kie.workbench.common.dmn.api.definition.model.TextAnnotation;
import org.kie.workbench.common.dmn.api.property.background.BackgroundSet;
import org.kie.workbench.common.dmn.api.property.dimensions.DecisionServiceRectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dimensions.GeneralRectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dmn.AllowedAnswers;
import org.kie.workbench.common.dmn.api.property.dmn.DMNExternalLink;
import org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceDividerLineY;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.KnowledgeSourceType;
import org.kie.workbench.common.dmn.api.property.dmn.LocationURI;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.Question;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.api.property.dmn.TextFormat;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.api.property.font.FontSet;
import org.kie.workbench.common.dmn.client.commands.clone.DMNDeepCloneProcess;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.definition.clone.AbstractCloneProcessTest;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.ClassUtils;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class DMNDeepCloneProcessTest
extends AbstractCloneProcessTest {
    private static final String SOURCE_ID = "source-id";
    private static final String INPUT_DATA_NAME = "input-data";
    private static final String FIRST_URL = "firstURL";
    private static final String SECOND_URL = "secondURL";
    private static final String DECISION_SERVICE_NAME = "decision-service";
    private static final String KNOWLEDGE_SOURCE_NAME = "knowledge-source";
    private static final String FUNCTION_ID = "function-id";
    private static final String CONTEXT_ID = "context-id";
    private static final String BKM_SOURCE_NAME = "bkm-source";
    private static final String DECISION_SOURCE_NAME = "decision-source";
    private static final String QUESTION = "question?";
    private static final String ANSWER = "answer";
    private static final String TEXT_DATA = "text-data";
    private static final String FIRST_INDEX_IN_SUFFIX = "-1";
    private static final String SECOND_INDEX_IN_SUFFIX = "-2";
    private static final String THIRD_INDEX_IN_SUFFIX = "-3";
    private static final String FORTH_INDEX_IN_SUFFIX = "-4";
    private DMNDeepCloneProcess dmnDeepCloneProcess;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private ClientSession currentSession;
    @Mock
    private CanvasHandler canvasHandler;
    @Mock
    private Diagram diagram;
    @Mock
    private Graph graph;
    @Mock
    private Node nodeWithName;
    @Mock
    private Node nodeWithText;
    @Mock
    private Node nodeWithNone;
    @Mock
    private View namedElementContent;
    @Mock
    private View textElementContent;
    @Mock
    private View noneContent;
    @Mock
    private NamedElement namedElementDefinition;
    @Mock
    private HasText hasTextDefinition;
    @Mock
    private Name name;
    @Mock
    private Text text;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.currentSession);
        Mockito.when((Object)this.currentSession.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.diagram.getGraph()).thenReturn((Object)this.graph);
        Mockito.when((Object)this.graph.nodes()).thenReturn(Collections.emptyList());
        this.dmnDeepCloneProcess = new DMNDeepCloneProcess(this.factoryManager, this.adapterManager, new ClassUtils(), this.sessionManager);
    }

    @Test
    public void testCloneWhenSourceIsInputData() {
        InputData source = this.buildInputData();
        this.setLinks((DRGElement)source, FIRST_URL, SECOND_URL);
        InputData cloned = (InputData)this.dmnDeepCloneProcess.clone((Object)source, (Object)new InputData());
        Assertions.assertThat((Object)cloned).isNotNull();
        Assertions.assertThat((String)cloned.getId().getValue()).isNotEqualTo((Object)SOURCE_ID);
        Assertions.assertThat((String)cloned.getName().getValue()).isEqualTo("input-data-1");
        Assertions.assertThat((Object)cloned.getVariable().getTypeRef()).isEqualTo((Object)BuiltInType.STRING.asQName());
        ((ListAssert)Assertions.assertThat((List)cloned.getLinksHolder().getValue().getLinks()).hasSize(2)).extracting(DMNExternalLink::getUrl).contains((Object[])new String[]{FIRST_URL, SECOND_URL});
    }

    private InputData buildInputData() {
        return new InputData(new Id(SOURCE_ID), new Description(), new Name(INPUT_DATA_NAME), this.buildInformationItemPrimary(BuiltInType.STRING), new BackgroundSet(), new FontSet(), new GeneralRectangleDimensionsSet());
    }

    @Test
    public void testCloneWhenSourceIsTextAnnotation() {
        TextAnnotation source = this.buildTextAnnotation();
        TextAnnotation cloned = (TextAnnotation)this.dmnDeepCloneProcess.clone((Object)source, (Object)new TextAnnotation());
        Assertions.assertThat((Object)cloned).isNotNull();
        Assertions.assertThat((String)cloned.getId().getValue()).isNotEqualTo((Object)SOURCE_ID);
        Assertions.assertThat((String)cloned.getText().getValue()).isEqualTo("text-data-1");
    }

    private TextAnnotation buildTextAnnotation() {
        return new TextAnnotation(new Id(SOURCE_ID), new Description(), new Text(TEXT_DATA), new TextFormat(), new BackgroundSet(), new FontSet(), new GeneralRectangleDimensionsSet());
    }

    @Test
    public void testCloneWhenSourceIsDecisionService() {
        DecisionService source = this.buildDecisionService();
        DecisionService cloned = (DecisionService)this.dmnDeepCloneProcess.clone((Object)source, (Object)new DecisionService());
        Assertions.assertThat((Object)cloned).isNotNull();
        Assertions.assertThat((String)cloned.getId().getValue()).isNotEqualTo((Object)SOURCE_ID);
        Assertions.assertThat((String)cloned.getName().getValue()).isEqualTo("decision-service-1");
        Assertions.assertThat((Object)cloned.getVariable().getTypeRef()).isEqualTo((Object)BuiltInType.BOOLEAN.asQName());
    }

    private DecisionService buildDecisionService() {
        return new DecisionService(new Id(SOURCE_ID), new Description(), new Name(DECISION_SERVICE_NAME), this.buildInformationItemPrimary(BuiltInType.BOOLEAN), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new BackgroundSet(), new FontSet(), new DecisionServiceRectangleDimensionsSet(), new DecisionServiceDividerLineY());
    }

    @Test
    public void testCloneWhenSourceIsKnowledgeSource() {
        KnowledgeSource source = this.buildKnowledgeSource();
        this.setLinks((DRGElement)source, FIRST_URL, SECOND_URL);
        KnowledgeSource cloned = (KnowledgeSource)this.dmnDeepCloneProcess.clone((Object)source, (Object)new KnowledgeSource());
        Assertions.assertThat((Object)cloned).isNotNull();
        Assertions.assertThat((String)cloned.getId().getValue()).isNotEqualTo((Object)SOURCE_ID);
        Assertions.assertThat((String)cloned.getName().getValue()).isEqualTo("knowledge-source-1");
        ((ListAssert)Assertions.assertThat((List)cloned.getLinksHolder().getValue().getLinks()).hasSize(2)).extracting(DMNExternalLink::getUrl).contains((Object[])new String[]{FIRST_URL, SECOND_URL});
    }

    private KnowledgeSource buildKnowledgeSource() {
        return new KnowledgeSource(new Id(SOURCE_ID), new Description(), new Name(KNOWLEDGE_SOURCE_NAME), new KnowledgeSourceType(), new LocationURI(), new BackgroundSet(), new FontSet(), new GeneralRectangleDimensionsSet());
    }

    @Test
    public void testCloneWhenSourceIsBusinessKnowledgeModel() {
        BusinessKnowledgeModel source = this.buildBusinessKnowledgeModel();
        this.setLinks((DRGElement)source, FIRST_URL, SECOND_URL);
        BusinessKnowledgeModel cloned = (BusinessKnowledgeModel)this.dmnDeepCloneProcess.clone((Object)source, (Object)new BusinessKnowledgeModel());
        Assertions.assertThat((Object)cloned).isNotNull();
        Assertions.assertThat((String)cloned.getId().getValue()).isNotEqualTo((Object)SOURCE_ID);
        Assertions.assertThat((String)cloned.getName().getValue()).isEqualTo("bkm-source-1");
        ((ListAssert)Assertions.assertThat((List)cloned.getLinksHolder().getValue().getLinks()).hasSize(2)).extracting(DMNExternalLink::getUrl).contains((Object[])new String[]{FIRST_URL, SECOND_URL});
        Assertions.assertThat((Object)cloned.getVariable().getTypeRef()).isEqualTo((Object)BuiltInType.BOOLEAN.asQName());
        Assertions.assertThat((Object)cloned.getEncapsulatedLogic()).isNotNull();
        Assertions.assertThat((String)cloned.getEncapsulatedLogic().getId().getValue()).isNotEqualTo((Object)FUNCTION_ID);
        Assertions.assertThat((Comparable)cloned.getEncapsulatedLogic().getKind()).isEqualTo((Object)FunctionDefinition.Kind.JAVA);
        Assertions.assertThat((Object)cloned.getEncapsulatedLogic().getTypeRef()).isEqualTo((Object)BuiltInType.BOOLEAN.asQName());
        Assertions.assertThat((Object)cloned.getEncapsulatedLogic().getExpression()).isInstanceOf(Context.class);
        Assertions.assertThat((Object)cloned.getEncapsulatedLogic().getExpression().getId()).isNotEqualTo((Object)CONTEXT_ID);
        Assertions.assertThat((Object)cloned.getEncapsulatedLogic().getExpression().getTypeRef()).isEqualTo((Object)BuiltInType.NUMBER.asQName());
    }

    @Test
    public void testCloneWhenSourceIsDecision() {
        Decision source = this.buildDecision();
        this.setLinks((DRGElement)source, FIRST_URL, SECOND_URL);
        Decision cloned = (Decision)this.dmnDeepCloneProcess.clone((Object)source, (Object)new Decision());
        Assertions.assertThat((Object)cloned).isNotNull();
        Assertions.assertThat((String)cloned.getId().getValue()).isNotEqualTo((Object)SOURCE_ID);
        Assertions.assertThat((String)cloned.getName().getValue()).isEqualTo("decision-source-1");
        ((ListAssert)Assertions.assertThat((List)cloned.getLinksHolder().getValue().getLinks()).hasSize(2)).extracting(DMNExternalLink::getUrl).contains((Object[])new String[]{FIRST_URL, SECOND_URL});
        Assertions.assertThat((Object)cloned.getVariable().getTypeRef()).isEqualTo((Object)BuiltInType.BOOLEAN.asQName());
        Assertions.assertThat((String)cloned.getQuestion().getValue()).isEqualTo(QUESTION);
        Assertions.assertThat((String)cloned.getAllowedAnswers().getValue()).isEqualTo(ANSWER);
        Assertions.assertThat((Object)cloned.getExpression()).isNotNull();
        Assertions.assertThat((Object)cloned.getExpression()).isInstanceOf(FunctionDefinition.class);
        Assertions.assertThat((String)cloned.getExpression().getId().getValue()).isNotEqualTo((Object)FUNCTION_ID);
        Assertions.assertThat((Object)cloned.getExpression().getTypeRef()).isEqualTo((Object)BuiltInType.BOOLEAN.asQName());
        Assertions.assertThat((Object)((FunctionDefinition)cloned.getExpression()).getExpression()).isInstanceOf(Context.class);
        Assertions.assertThat((Object)((FunctionDefinition)cloned.getExpression()).getExpression().getId()).isNotEqualTo((Object)CONTEXT_ID);
        Assertions.assertThat((Object)((FunctionDefinition)cloned.getExpression()).getExpression().getTypeRef()).isEqualTo((Object)BuiltInType.NUMBER.asQName());
    }

    private BusinessKnowledgeModel buildBusinessKnowledgeModel() {
        return new BusinessKnowledgeModel(new Id(SOURCE_ID), new Description(), new Name(BKM_SOURCE_NAME), this.buildInformationItemPrimary(BuiltInType.BOOLEAN), this.buildFunctionDefinition(), new BackgroundSet(), new FontSet(), new GeneralRectangleDimensionsSet());
    }

    private Decision buildDecision() {
        return new Decision(new Id(SOURCE_ID), new Description(), new Name(DECISION_SOURCE_NAME), new Question(QUESTION), new AllowedAnswers(ANSWER), this.buildInformationItemPrimary(BuiltInType.BOOLEAN), (Expression)this.buildFunctionDefinition(), new BackgroundSet(), new FontSet(), new GeneralRectangleDimensionsSet());
    }

    private FunctionDefinition buildFunctionDefinition() {
        FunctionDefinition encapsulatedLogic = new FunctionDefinition(new Id(FUNCTION_ID), new Description(), new QName(BuiltInType.BOOLEAN), (Expression)new Context(new Id(CONTEXT_ID), new Description(), new QName(BuiltInType.NUMBER)));
        encapsulatedLogic.setKind(FunctionDefinition.Kind.JAVA);
        return encapsulatedLogic;
    }

    private InformationItemPrimary buildInformationItemPrimary(BuiltInType builtInType) {
        InformationItemPrimary informationItemPrimary = new InformationItemPrimary();
        informationItemPrimary.setTypeRef(new QName(builtInType));
        return informationItemPrimary;
    }

    private void setLinks(DRGElement drgElement, String ... links) {
        Stream.of(links).forEach(link -> drgElement.getLinksHolder().getValue().getLinks().add(new DMNExternalLink(link, "description")));
    }

    @Test
    public void testComposingUniqueNodeName() {
        Assertions.assertThat((String)this.dmnDeepCloneProcess.composeUniqueNodeName(INPUT_DATA_NAME)).isEqualTo("input-data-1");
    }

    @Test
    public void testComposingUniqueNodeNameWhenItAlreadyContainsIndexedSuffix() {
        this.mockSingleNodeInTheGraph();
        Assertions.assertThat((String)this.dmnDeepCloneProcess.composeUniqueNodeName("input-data-1")).isEqualTo("input-data-2");
    }

    private void mockSingleNodeInTheGraph() {
        Mockito.when((Object)this.graph.nodes()).thenReturn(Collections.singletonList(this.nodeWithName));
        Mockito.when((Object)this.nodeWithName.getContent()).thenReturn((Object)this.namedElementContent);
        Mockito.when((Object)this.namedElementContent.getDefinition()).thenReturn((Object)this.namedElementDefinition);
        Mockito.when((Object)this.namedElementDefinition.getName()).thenReturn((Object)this.name);
        Mockito.when((Object)this.name.getValue()).thenReturn((Object)"input-data-1");
    }

    @Test
    public void testComposingUniqueNodeNameWhenItContainsNotIndexedSuffix() {
        Assertions.assertThat((String)this.dmnDeepCloneProcess.composeUniqueNodeName("input-data-A3")).isEqualTo("input-data-A3-1");
    }

    @Test
    public void testComposingUniqueNodeNameWhenNextIndexInSequenceAlreadyPresent() {
        this.mockMultipleNodesInTheGraph();
        Assertions.assertThat((String)this.dmnDeepCloneProcess.composeUniqueNodeName("input-data-1")).isEqualTo("input-data-4");
    }

    private void mockMultipleNodesInTheGraph() {
        Mockito.when((Object)this.graph.nodes()).thenReturn(Arrays.asList(this.nodeWithName, this.nodeWithText, this.nodeWithNone));
        Mockito.when((Object)this.nodeWithName.getContent()).thenReturn((Object)this.namedElementContent);
        Mockito.when((Object)this.namedElementContent.getDefinition()).thenReturn((Object)this.namedElementDefinition);
        Mockito.when((Object)this.namedElementDefinition.getName()).thenReturn((Object)this.name);
        Mockito.when((Object)this.name.getValue()).thenReturn((Object)"input-data-2");
        Mockito.when((Object)this.nodeWithText.getContent()).thenReturn((Object)this.textElementContent);
        Mockito.when((Object)this.textElementContent.getDefinition()).thenReturn((Object)this.hasTextDefinition);
        Mockito.when((Object)this.hasTextDefinition.getText()).thenReturn((Object)this.text);
        Mockito.when((Object)this.text.getValue()).thenReturn((Object)"input-data-3");
        Mockito.when((Object)this.nodeWithNone.getContent()).thenReturn((Object)this.noneContent);
        Mockito.when((Object)this.noneContent.getDefinition()).thenReturn(new Object());
    }

    @Test
    public void testComposingUniqueNodeNameWhenItIsEmpty() {
        Assertions.assertThat((String)this.dmnDeepCloneProcess.composeUniqueNodeName("")).isEqualTo(FIRST_INDEX_IN_SUFFIX);
    }

    @Test
    public void testComposingUniqueNodeNameWhenItIsNull() {
        Assertions.assertThat((String)this.dmnDeepCloneProcess.composeUniqueNodeName(null)).isEqualTo(FIRST_INDEX_IN_SUFFIX);
    }
}

