/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.context;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.ContextEntry;
import org.kie.workbench.common.dmn.client.commands.expressions.types.context.DeleteContextEntryCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class DeleteContextEntryCommandTest {
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private ExpressionEditorColumn uiModelColumn;
    @Mock
    private Command canvasOperation;
    @Mock
    private AbstractCanvasHandler handler;
    @Mock
    private GraphCommandExecutionContext gce;
    @Mock
    private RuleManager ruleManager;
    private Context context;
    private GridData uiModel;
    private DeleteContextEntryCommand command;

    @Before
    public void setup() {
        this.context = new Context();
        this.context.getContextEntry().add(new ContextEntry());
        this.uiModel = new BaseGridData(false);
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        ((AbstractCanvasHandler)Mockito.doReturn((Object)this.ruleManager).when((Object)this.handler)).getRuleManager();
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((ExpressionEditorColumn)Mockito.doReturn((Object)1).when((Object)this.uiModelColumn)).getIndex();
    }

    private void makeCommand(int deleteFromUiRowIndex) {
        this.command = (DeleteContextEntryCommand)Mockito.spy((Object)new DeleteContextEntryCommand(this.context, this.uiModel, deleteFromUiRowIndex, this.canvasOperation));
    }

    @Test
    public void testGraphCommandAllow() {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.gce));
    }

    @Test
    public void testGraphCommandExecute() {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)0L, (long)this.context.getContextEntry().size());
    }

    @Test
    public void testGraphCommandExecuteMultipleRows() {
        this.addContextEntries(3);
        ContextEntry firstEntry = (ContextEntry)this.context.getContextEntry().get(0);
        ContextEntry lastEntry = (ContextEntry)this.context.getContextEntry().get(2);
        this.makeCommand(1);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assertions.assertThat((List)this.context.getContextEntry()).containsExactly((Object[])new ContextEntry[]{firstEntry, lastEntry});
    }

    @Test
    public void testGraphCommandUndo() {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((long)1L, (long)this.context.getContextEntry().size());
    }

    @Test
    public void testGraphCommandUndoMultipleRows() {
        this.addContextEntries(3);
        ContextEntry firstEntry = (ContextEntry)this.context.getContextEntry().get(0);
        ContextEntry originalEntry = (ContextEntry)this.context.getContextEntry().get(1);
        ContextEntry lastEntry = (ContextEntry)this.context.getContextEntry().get(2);
        this.makeCommand(1);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assertions.assertThat((List)this.context.getContextEntry()).containsExactly((Object[])new ContextEntry[]{firstEntry, originalEntry, lastEntry});
    }

    @Test
    public void testCanvasCommandAllow() {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.handler));
    }

    @Test
    public void testCanvasCommandExecuteWithColumns() {
        this.makeCommand(0);
        this.uiModel.appendColumn((GridColumn)this.uiModelColumn);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)0L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiModelColumn, this.uiModel.getColumns().get(1));
        ((DeleteContextEntryCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((DeleteContextEntryCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandExecuteWithColumnsMultipleRows() {
        this.addContextEntries(3);
        GridRow firstRow = this.uiModel.getRow(0);
        GridRow lastRow = this.uiModel.getRow(2);
        this.makeCommand(1);
        this.uiModel.appendColumn((GridColumn)this.uiModelColumn);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)2L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiModelColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((Object)firstRow, (Object)this.uiModel.getRow(0));
        Assert.assertEquals((Object)lastRow, (Object)this.uiModel.getRow(1));
        ((DeleteContextEntryCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((DeleteContextEntryCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandExecuteWithNoColumns() {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)0L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((long)1L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        ((DeleteContextEntryCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((DeleteContextEntryCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandUndoWithColumns() {
        this.makeCommand(0);
        this.uiModel.appendColumn((GridColumn)this.uiModelColumn);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new Object[]{this.command, this.canvasOperation});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiModelColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
        ((DeleteContextEntryCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((DeleteContextEntryCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandUndoWithColumnsMultipleRows() {
        this.addContextEntries(3);
        GridRow firstRow = this.uiModel.getRow(0);
        GridRow originalRow = this.uiModel.getRow(1);
        GridRow lastRow = this.uiModel.getRow(2);
        this.makeCommand(1);
        this.uiModel.appendColumn((GridColumn)this.uiModelColumn);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new Object[]{this.command, this.canvasOperation});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiModelColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((long)3L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)firstRow, (Object)this.uiModel.getRow(0));
        Assert.assertEquals((Object)originalRow, (Object)this.uiModel.getRow(1));
        Assert.assertEquals((Object)lastRow, (Object)this.uiModel.getRow(2));
        ((DeleteContextEntryCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((DeleteContextEntryCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandUndoWithNoColumns() {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new Object[]{this.command, this.canvasOperation});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        Assert.assertEquals((long)1L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
        ((DeleteContextEntryCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((DeleteContextEntryCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandExecuteRowNumbering() {
        this.makeCommand(0);
        this.setupRowNumbers();
        this.command.newCanvasCommand(this.handler).execute((Object)this.handler);
        Assert.assertEquals((long)2L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertNull((Object)this.uiModel.getCell(1, 0).getValue());
    }

    @Test
    public void testCanvasCommandUndoRowNumbering() {
        this.makeCommand(0);
        this.setupRowNumbers();
        this.command.newCanvasCommand(this.handler).execute((Object)this.handler);
        this.command.newCanvasCommand(this.handler).undo((Object)this.handler);
        Assert.assertEquals((long)3L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)2, (Object)this.uiModel.getCell(1, 0).getValue().getValue());
        Assert.assertNull((Object)this.uiModel.getCell(2, 0).getValue());
    }

    private void addContextEntries(int entriesCount) {
        int i;
        int originalRowCount = this.uiModel.getRowCount();
        for (i = 0; i < originalRowCount; ++i) {
            this.uiModel.deleteRow(0);
        }
        this.context.getContextEntry().clear();
        for (i = 0; i < entriesCount; ++i) {
            this.context.getContextEntry().add(new ContextEntry());
            this.uiModel.appendRow((GridRow)new BaseGridRow());
        }
    }

    private void setupRowNumbers() {
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.setCellValue(0, 0, (GridCellValue)new BaseGridCellValue((Object)1));
        this.uiModel.setCellValue(1, 0, (GridCellValue)new BaseGridCellValue((Object)2));
        this.uiModel.setCellValue(2, 0, null);
        Assert.assertEquals((long)3L, (long)this.uiModel.getRowCount());
    }
}

