/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.dtable;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.InputClause;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.OutputClause;
import org.kie.workbench.common.dmn.api.definition.model.RuleAnnotationClause;
import org.kie.workbench.common.dmn.api.definition.model.RuleAnnotationClauseText;
import org.kie.workbench.common.dmn.api.definition.model.UnaryTests;
import org.kie.workbench.common.dmn.client.commands.expressions.types.dtable.MoveColumnsCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.InputClauseColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.OutputClauseColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.RuleAnnotationClauseColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class MoveColumnsCommandTest {
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private InputClauseColumn uiInputClauseColumnOne;
    @Mock
    private InputClauseColumn uiInputClauseColumnTwo;
    @Mock
    private InputClauseColumn uiInputClauseColumnThree;
    @Mock
    private OutputClauseColumn uiOutputClauseColumnOne;
    @Mock
    private OutputClauseColumn uiOutputClauseColumnTwo;
    @Mock
    private OutputClauseColumn uiOutputClauseColumnThree;
    @Mock
    private RuleAnnotationClauseColumn uiRuleAnnotationClauseColumnOne;
    @Mock
    private RuleAnnotationClauseColumn uiRuleAnnotationClauseColumnTwo;
    @Mock
    private RuleAnnotationClauseColumn uiRuleAnnotationClauseColumnThree;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private GraphCommandExecutionContext graphCommandExecutionContext;
    private DecisionTable dtable;
    @Mock
    private InputClause inputClauseOne;
    @Mock
    private InputClause inputClauseTwo;
    @Mock
    private InputClause inputClauseThree;
    @Mock
    private OutputClause outputClauseOne;
    @Mock
    private OutputClause outputClauseTwo;
    @Mock
    private OutputClause outputClauseThree;
    @Mock
    private RuleAnnotationClause annotationClauseOne;
    @Mock
    private RuleAnnotationClause annotationClauseTwo;
    @Mock
    private RuleAnnotationClause annotationClauseThree;
    private DMNGridData uiModel;
    private MoveColumnsCommand command;
    private org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> graphCommand;
    private org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> canvasCommand;
    @Mock
    private Command canvasOperation;

    @Before
    public void setUp() {
        this.dtable = new DecisionTable();
        this.uiModel = new DMNGridData();
        this.dtable.getInput().add(this.inputClauseOne);
        this.dtable.getInput().add(this.inputClauseTwo);
        this.dtable.getInput().add(this.inputClauseThree);
        this.dtable.getOutput().add(this.outputClauseOne);
        this.dtable.getOutput().add(this.outputClauseTwo);
        this.dtable.getOutput().add(this.outputClauseThree);
        this.dtable.getAnnotations().add(this.annotationClauseOne);
        this.dtable.getAnnotations().add(this.annotationClauseTwo);
        this.dtable.getAnnotations().add(this.annotationClauseThree);
        this.dtable.getRule().add(new DecisionRule(){
            {
                this.getInputEntry().add(new UnaryTests());
                this.getInputEntry().add(new UnaryTests());
                this.getInputEntry().add(new UnaryTests());
                this.getOutputEntry().add(new LiteralExpression());
                this.getOutputEntry().add(new LiteralExpression());
                this.getOutputEntry().add(new LiteralExpression());
                this.getAnnotationEntry().add(new RuleAnnotationClauseText());
                this.getAnnotationEntry().add(new RuleAnnotationClauseText());
                this.getAnnotationEntry().add(new RuleAnnotationClauseText());
            }
        });
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModel.appendColumn((GridColumn)this.uiInputClauseColumnOne);
        this.uiModel.appendColumn((GridColumn)this.uiInputClauseColumnTwo);
        this.uiModel.appendColumn((GridColumn)this.uiInputClauseColumnThree);
        this.uiModel.appendColumn((GridColumn)this.uiOutputClauseColumnOne);
        this.uiModel.appendColumn((GridColumn)this.uiOutputClauseColumnTwo);
        this.uiModel.appendColumn((GridColumn)this.uiOutputClauseColumnThree);
        this.uiModel.appendColumn((GridColumn)this.uiRuleAnnotationClauseColumnOne);
        this.uiModel.appendColumn((GridColumn)this.uiRuleAnnotationClauseColumnTwo);
        this.uiModel.appendColumn((GridColumn)this.uiRuleAnnotationClauseColumnThree);
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((InputClauseColumn)Mockito.doReturn((Object)1).when((Object)this.uiInputClauseColumnOne)).getIndex();
        ((InputClauseColumn)Mockito.doReturn((Object)2).when((Object)this.uiInputClauseColumnTwo)).getIndex();
        ((InputClauseColumn)Mockito.doReturn((Object)3).when((Object)this.uiInputClauseColumnThree)).getIndex();
        ((OutputClauseColumn)Mockito.doReturn((Object)4).when((Object)this.uiOutputClauseColumnOne)).getIndex();
        ((OutputClauseColumn)Mockito.doReturn((Object)5).when((Object)this.uiOutputClauseColumnTwo)).getIndex();
        ((OutputClauseColumn)Mockito.doReturn((Object)6).when((Object)this.uiOutputClauseColumnThree)).getIndex();
        ((RuleAnnotationClauseColumn)Mockito.doReturn((Object)7).when((Object)this.uiRuleAnnotationClauseColumnOne)).getIndex();
        ((RuleAnnotationClauseColumn)Mockito.doReturn((Object)8).when((Object)this.uiRuleAnnotationClauseColumnTwo)).getIndex();
        ((RuleAnnotationClauseColumn)Mockito.doReturn((Object)9).when((Object)this.uiRuleAnnotationClauseColumnThree)).getIndex();
    }

    @Test
    public void testCommandAllow() {
        this.moveColumnsToPositionCommand(Collections.singletonList(this.uiInputClauseColumnThree), 1);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.graphCommand.allow((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.canvasCommand.allow((Object)this.canvasHandler));
    }

    @Test
    public void testMoveSingleInputColumnLeft() {
        this.moveColumnsToPositionCommand(Collections.singletonList(this.uiInputClauseColumnThree), 1);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.graphCommand.execute((Object)this.graphCommandExecutionContext));
        this.assertClauses(1, 2, 0, 0, 1, 2, 0, 1, 2);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.canvasCommand.execute((Object)this.canvasHandler));
        this.assertColumns(2, 3, 1, 4, 5, 6, 7, 8, 9);
    }

    @Test
    public void testMoveMultipleInputColumnsLeft() {
        this.moveColumnsToPositionCommand(Arrays.asList(this.uiInputClauseColumnTwo, this.uiInputClauseColumnThree), 1);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.graphCommand.execute((Object)this.graphCommandExecutionContext));
        this.assertClauses(2, 0, 1, 0, 1, 2, 0, 1, 2);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.canvasCommand.execute((Object)this.canvasHandler));
        this.assertColumns(3, 1, 2, 4, 5, 6, 7, 8, 9);
    }

    @Test
    public void testMoveSingleInputColumnRight() {
        this.moveColumnsToPositionCommand(Collections.singletonList(this.uiInputClauseColumnOne), 3);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.graphCommand.execute((Object)this.graphCommandExecutionContext));
        this.assertClauses(2, 0, 1, 0, 1, 2, 0, 1, 2);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.canvasCommand.execute((Object)this.canvasHandler));
        this.assertColumns(3, 1, 2, 4, 5, 6, 7, 8, 9);
    }

    @Test
    public void testMoveMultipleInputColumnsRight() {
        this.moveColumnsToPositionCommand(Arrays.asList(this.uiInputClauseColumnOne, this.uiInputClauseColumnTwo), 3);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.graphCommand.execute((Object)this.graphCommandExecutionContext));
        this.assertClauses(1, 2, 0, 0, 1, 2, 0, 1, 2);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.canvasCommand.execute((Object)this.canvasHandler));
        this.assertColumns(2, 3, 1, 4, 5, 6, 7, 8, 9);
    }

    @Test
    public void testMoveSingleOutputColumnLeft() {
        this.moveColumnsToPositionCommand(Collections.singletonList(this.uiOutputClauseColumnThree), 4);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.graphCommand.execute((Object)this.graphCommandExecutionContext));
        this.assertClauses(0, 1, 2, 1, 2, 0, 0, 1, 2);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.canvasCommand.execute((Object)this.canvasHandler));
        this.assertColumns(1, 2, 3, 5, 6, 4, 7, 8, 9);
    }

    @Test
    public void testMoveMultipleOutputColumnsLeft() {
        this.moveColumnsToPositionCommand(Arrays.asList(this.uiOutputClauseColumnTwo, this.uiOutputClauseColumnThree), 4);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.graphCommand.execute((Object)this.graphCommandExecutionContext));
        this.assertClauses(0, 1, 2, 2, 0, 1, 0, 1, 2);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.canvasCommand.execute((Object)this.canvasHandler));
        this.assertColumns(1, 2, 3, 6, 4, 5, 7, 8, 9);
    }

    @Test
    public void testMoveSingleOutputColumnRight() {
        this.moveColumnsToPositionCommand(Collections.singletonList(this.uiOutputClauseColumnOne), 6);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.graphCommand.execute((Object)this.graphCommandExecutionContext));
        this.assertClauses(0, 1, 2, 2, 0, 1, 0, 1, 2);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.canvasCommand.execute((Object)this.canvasHandler));
        this.assertColumns(1, 2, 3, 6, 4, 5, 7, 8, 9);
    }

    @Test
    public void testMoveMultipleOutputColumnsRight() {
        this.moveColumnsToPositionCommand(Arrays.asList(this.uiOutputClauseColumnOne, this.uiOutputClauseColumnTwo), 6);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.graphCommand.execute((Object)this.graphCommandExecutionContext));
        this.assertClauses(0, 1, 2, 1, 2, 0, 0, 1, 2);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.canvasCommand.execute((Object)this.canvasHandler));
        this.assertColumns(1, 2, 3, 5, 6, 4, 7, 8, 9);
    }

    @Test
    public void testMoveSingleAnnotationColumnWithDuplicatedTitle() {
        DecisionTable decisionTable = new DecisionTable();
        DMNGridData model = new DMNGridData();
        RuleAnnotationClause clauseOne = new RuleAnnotationClause();
        RuleAnnotationClause clauseTwo = new RuleAnnotationClause();
        RuleAnnotationClause clauseThree = new RuleAnnotationClause();
        decisionTable.getAnnotations().add(clauseOne);
        decisionTable.getAnnotations().add(clauseTwo);
        decisionTable.getAnnotations().add(clauseThree);
        decisionTable.getRule().add(new DecisionRule(){
            {
                this.getAnnotationEntry().add(new RuleAnnotationClauseText());
                this.getAnnotationEntry().add(new RuleAnnotationClauseText());
                this.getAnnotationEntry().add(new RuleAnnotationClauseText());
            }
        });
        RuleAnnotationClauseColumn columnOne = (RuleAnnotationClauseColumn)Mockito.mock(RuleAnnotationClauseColumn.class);
        RuleAnnotationClauseColumn columnTwo = (RuleAnnotationClauseColumn)Mockito.mock(RuleAnnotationClauseColumn.class);
        RuleAnnotationClauseColumn columnThree = (RuleAnnotationClauseColumn)Mockito.mock(RuleAnnotationClauseColumn.class);
        model.appendColumn((GridColumn)this.uiRowNumberColumn);
        model.appendColumn((GridColumn)columnOne);
        model.appendColumn((GridColumn)columnTwo);
        model.appendColumn((GridColumn)columnThree);
        Mockito.when((Object)columnOne.getIndex()).thenReturn((Object)1);
        Mockito.when((Object)columnOne.getIndex()).thenReturn((Object)2);
        Mockito.when((Object)columnOne.getIndex()).thenReturn((Object)3);
        this.command = new MoveColumnsCommand(decisionTable, model, 2, Arrays.asList(columnOne), this.canvasOperation);
        this.graphCommand = this.command.newGraphCommand(this.canvasHandler);
        this.canvasCommand = this.command.newCanvasCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.canvasCommand.execute((Object)this.canvasHandler));
    }

    @Test
    public void testMoveSingleAnnotationColumnLeft() {
        this.moveColumnsToPositionCommand(Collections.singletonList(this.uiRuleAnnotationClauseColumnThree), 7);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.graphCommand.execute((Object)this.graphCommandExecutionContext));
        this.assertClauses(0, 1, 2, 0, 1, 2, 1, 2, 0);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.canvasCommand.execute((Object)this.canvasHandler));
        this.assertColumns(1, 2, 3, 4, 5, 6, 8, 9, 7);
    }

    @Test
    public void testMoveMultipleAnnotationColumnsLeft() {
        this.moveColumnsToPositionCommand(Arrays.asList(this.uiRuleAnnotationClauseColumnTwo, this.uiRuleAnnotationClauseColumnThree), 7);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.graphCommand.execute((Object)this.graphCommandExecutionContext));
        this.assertClauses(0, 1, 2, 0, 1, 2, 2, 0, 1);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.canvasCommand.execute((Object)this.canvasHandler));
        this.assertColumns(1, 2, 3, 4, 5, 6, 9, 7, 8);
    }

    @Test
    public void testMoveSingleAnnotationColumnRight() {
        this.moveColumnsToPositionCommand(Collections.singletonList(this.uiRuleAnnotationClauseColumnOne), 8);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.graphCommand.execute((Object)this.graphCommandExecutionContext));
        this.assertClauses(0, 1, 2, 0, 1, 2, 1, 0, 2);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.canvasCommand.execute((Object)this.canvasHandler));
        this.assertColumns(1, 2, 3, 4, 5, 6, 8, 7, 9);
    }

    @Test
    public void testMoveMultipleAnnotationColumnsRight() {
        this.moveColumnsToPositionCommand(Arrays.asList(this.uiRuleAnnotationClauseColumnOne, this.uiRuleAnnotationClauseColumnTwo), 9);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.graphCommand.execute((Object)this.graphCommandExecutionContext));
        this.assertClauses(0, 1, 2, 0, 1, 2, 1, 2, 0);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.canvasCommand.execute((Object)this.canvasHandler));
        this.assertColumns(1, 2, 3, 4, 5, 6, 8, 9, 7);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMoveSingleAnnotationToOutputs() {
        this.moveColumnsToPositionCommand(Collections.singletonList(this.uiRuleAnnotationClauseColumnOne), 4);
        this.graphCommand.execute((Object)this.graphCommandExecutionContext);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMoveSingleAnnotationToInputs() {
        this.moveColumnsToPositionCommand(Collections.singletonList(this.uiRuleAnnotationClauseColumnTwo), 1);
        this.graphCommand.execute((Object)this.graphCommandExecutionContext);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMoveSingleInputToOutputs() {
        this.moveColumnsToPositionCommand(Collections.singletonList(this.uiInputClauseColumnOne), 4);
        this.graphCommand.execute((Object)this.graphCommandExecutionContext);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMoveSingleInputToAnnotations() {
        this.moveColumnsToPositionCommand(Collections.singletonList(this.uiInputClauseColumnOne), 7);
        this.graphCommand.execute((Object)this.graphCommandExecutionContext);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMoveSingleOutputToInputs() {
        this.moveColumnsToPositionCommand(Collections.singletonList(this.uiOutputClauseColumnOne), 1);
        this.graphCommand.execute((Object)this.graphCommandExecutionContext);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMoveSingleOutputToAnnotations() {
        this.moveColumnsToPositionCommand(Collections.singletonList(this.uiOutputClauseColumnOne), 7);
        this.graphCommand.execute((Object)this.graphCommandExecutionContext);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMoveMixedToInputs() {
        this.moveColumnsToPositionCommand(Arrays.asList(this.uiInputClauseColumnOne, this.uiOutputClauseColumnOne), 3);
        this.graphCommand.execute((Object)this.graphCommandExecutionContext);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMoveMixedToOutputs() {
        this.moveColumnsToPositionCommand(Arrays.asList(this.uiOutputClauseColumnOne, this.uiInputClauseColumnOne), 6);
        this.graphCommand.execute((Object)this.graphCommandExecutionContext);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMoveMixedToAnnotations() {
        this.moveColumnsToPositionCommand(Arrays.asList(this.uiOutputClauseColumnOne, this.uiInputClauseColumnOne), 7);
        this.graphCommand.execute((Object)this.graphCommandExecutionContext);
    }

    @Test
    public void testInputClauseComponentWidths() {
        this.moveColumnsToPositionCommand(Arrays.asList(this.uiInputClauseColumnTwo, this.uiInputClauseColumnThree), 1);
        this.assertComponentWidths(1, 2, 3);
    }

    @Test
    public void testOutputClauseComponentWidths() {
        this.moveColumnsToPositionCommand(Arrays.asList(this.uiOutputClauseColumnTwo, this.uiOutputClauseColumnThree), 4);
        this.assertComponentWidths(4, 5, 6);
    }

    @Test
    public void testAnnotationClauseComponentWidths() {
        this.moveColumnsToPositionCommand(Arrays.asList(this.uiRuleAnnotationClauseColumnTwo, this.uiRuleAnnotationClauseColumnThree), 7);
        this.assertComponentWidths(7, 8, 9);
    }

    private void assertComponentWidths(int uiColumn1Index, int uiColumn2Index, int uiColumn3Index) {
        List componentWidths = this.dtable.getComponentWidths();
        componentWidths.set(uiColumn1Index, 10.0);
        componentWidths.set(uiColumn2Index, 20.0);
        componentWidths.set(uiColumn3Index, 30.0);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)this.dtable.getRequiredComponentWidthCount(), (long)this.dtable.getComponentWidths().size());
        Assert.assertEquals((double)20.0, (double)((Double)this.dtable.getComponentWidths().get(uiColumn1Index)), (double)0.0);
        Assert.assertEquals((double)30.0, (double)((Double)this.dtable.getComponentWidths().get(uiColumn2Index)), (double)0.0);
        Assert.assertEquals((double)10.0, (double)((Double)this.dtable.getComponentWidths().get(uiColumn3Index)), (double)0.0);
        this.command.newCanvasCommand(this.canvasHandler).execute((Object)this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.undo((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)this.dtable.getRequiredComponentWidthCount(), (long)this.dtable.getComponentWidths().size());
        Assert.assertEquals((double)10.0, (double)((Double)this.dtable.getComponentWidths().get(uiColumn1Index)), (double)0.0);
        Assert.assertEquals((double)20.0, (double)((Double)this.dtable.getComponentWidths().get(uiColumn2Index)), (double)0.0);
        Assert.assertEquals((double)30.0, (double)((Double)this.dtable.getComponentWidths().get(uiColumn3Index)), (double)0.0);
    }

    private void assertClauses(int ... clausesIndexes) {
        Assert.assertEquals((Object)this.inputClauseOne, this.dtable.getInput().get(clausesIndexes[0]));
        Assert.assertEquals((Object)this.inputClauseTwo, this.dtable.getInput().get(clausesIndexes[1]));
        Assert.assertEquals((Object)this.inputClauseThree, this.dtable.getInput().get(clausesIndexes[2]));
        Assert.assertEquals((Object)this.outputClauseOne, this.dtable.getOutput().get(clausesIndexes[3]));
        Assert.assertEquals((Object)this.outputClauseTwo, this.dtable.getOutput().get(clausesIndexes[4]));
        Assert.assertEquals((Object)this.outputClauseThree, this.dtable.getOutput().get(clausesIndexes[5]));
        Assert.assertEquals((Object)this.annotationClauseOne, this.dtable.getAnnotations().get(clausesIndexes[6]));
        Assert.assertEquals((Object)this.annotationClauseTwo, this.dtable.getAnnotations().get(clausesIndexes[7]));
        Assert.assertEquals((Object)this.annotationClauseThree, this.dtable.getAnnotations().get(clausesIndexes[8]));
    }

    private void assertColumns(int ... columnIndexes) {
        Assert.assertEquals((Object)this.uiInputClauseColumnOne, this.uiModel.getColumns().get(columnIndexes[0]));
        Assert.assertEquals((Object)this.uiInputClauseColumnTwo, this.uiModel.getColumns().get(columnIndexes[1]));
        Assert.assertEquals((Object)this.uiInputClauseColumnThree, this.uiModel.getColumns().get(columnIndexes[2]));
        Assert.assertEquals((Object)this.uiOutputClauseColumnOne, this.uiModel.getColumns().get(columnIndexes[3]));
        Assert.assertEquals((Object)this.uiOutputClauseColumnTwo, this.uiModel.getColumns().get(columnIndexes[4]));
        Assert.assertEquals((Object)this.uiOutputClauseColumnThree, this.uiModel.getColumns().get(columnIndexes[5]));
        Assert.assertEquals((Object)this.uiRuleAnnotationClauseColumnOne, this.uiModel.getColumns().get(columnIndexes[6]));
        Assert.assertEquals((Object)this.uiRuleAnnotationClauseColumnTwo, this.uiModel.getColumns().get(columnIndexes[7]));
        Assert.assertEquals((Object)this.uiRuleAnnotationClauseColumnThree, this.uiModel.getColumns().get(columnIndexes[8]));
    }

    private void moveColumnsToPositionCommand(List<GridColumn<?>> columns, int position) {
        this.command = new MoveColumnsCommand(this.dtable, this.uiModel, position, columns, this.canvasOperation);
        this.graphCommand = this.command.newGraphCommand(this.canvasHandler);
        this.canvasCommand = this.command.newCanvasCommand(this.canvasHandler);
    }
}

