/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.dtable;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.HitPolicy;
import org.kie.workbench.common.dmn.client.commands.expressions.types.dtable.SetHitPolicyCommand;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class SetHitPolicyCommandTest {
    private static final HitPolicy OLD_HIT_POLICY = HitPolicy.ANY;
    private static final HitPolicy NEW_HIT_POLICY = HitPolicy.UNIQUE;
    @Mock
    private Command canvasOperation;
    @Mock
    private AbstractCanvasHandler handler;
    @Mock
    private GraphCommandExecutionContext gce;
    @Mock
    private RuleManager ruleManager;
    private DecisionTable dtable;
    private SetHitPolicyCommand command;

    @Before
    public void setup() {
        ((AbstractCanvasHandler)Mockito.doReturn((Object)this.ruleManager).when((Object)this.handler)).getRuleManager();
    }

    private void makeCommand(HitPolicy hitPolicy) {
        this.dtable = new DecisionTable();
        this.dtable.setHitPolicy(hitPolicy);
        this.command = new SetHitPolicyCommand(this.dtable, NEW_HIT_POLICY, this.canvasOperation);
    }

    @Test
    public void testGraphCommandAllow() {
        this.makeCommand(OLD_HIT_POLICY);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.gce));
    }

    @Test
    public void testGraphCommandExecute() {
        this.makeCommand(OLD_HIT_POLICY);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)NEW_HIT_POLICY, (Object)this.dtable.getHitPolicy());
    }

    @Test
    public void testGraphCommandUndo() {
        this.makeCommand(OLD_HIT_POLICY);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((Object)OLD_HIT_POLICY, (Object)this.dtable.getHitPolicy());
    }

    @Test
    public void testGraphCommandUndoWhenOriginallyNull() {
        this.makeCommand(null);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((Object)HitPolicy.UNIQUE, (Object)this.dtable.getHitPolicy());
    }

    @Test
    public void testCanvasCommandAllow() {
        this.makeCommand(OLD_HIT_POLICY);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.handler));
    }

    @Test
    public void testCanvasCommandExecute() {
        this.makeCommand(OLD_HIT_POLICY);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.handler));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.handler, this.gce, this.ruleManager});
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandUndo() {
        this.makeCommand(OLD_HIT_POLICY);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.handler));
        Mockito.reset((Object[])new Command[]{this.canvasOperation});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.handler));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.handler, this.gce, this.ruleManager});
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }
}

