/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.function;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.commands.expressions.types.function.RemoveParameterCommand;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class RemoveParameterCommandTest {
    @Mock
    private Command canvasOperation;
    @Mock
    private AbstractCanvasHandler handler;
    @Mock
    private GraphCommandExecutionContext gce;
    @Mock
    private RuleManager ruleManager;
    private FunctionDefinition function;
    private InformationItem parameter;
    private RemoveParameterCommand command;

    @Before
    public void setup() {
        this.function = new FunctionDefinition();
        this.parameter = new InformationItem();
        this.function.getFormalParameter().add(this.parameter);
        this.command = new RemoveParameterCommand(this.function, this.parameter, this.canvasOperation);
        ((AbstractCanvasHandler)Mockito.doReturn((Object)this.ruleManager).when((Object)this.handler)).getRuleManager();
    }

    @Test
    public void testGraphCommandAllow() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.gce));
    }

    @Test
    public void testGraphCommandExecuteWithParameters() {
        InformationItem otherParameter = new InformationItem();
        this.function.getFormalParameter().add(otherParameter);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        this.assertFormalParameters(otherParameter);
    }

    @Test
    public void testGraphCommandExecuteWithNoParameters() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        this.assertFormalParameters(new InformationItem[0]);
    }

    @Test
    public void testGraphCommandUndoWithParameters() {
        InformationItem otherParameter = new InformationItem();
        this.function.getFormalParameter().add(otherParameter);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        this.assertFormalParameters(this.parameter, otherParameter);
    }

    @Test
    public void testRemoveFromMiddleThenUndo() {
        InformationItem firstParameter = new InformationItem();
        firstParameter.setName(new Name("first"));
        this.function.getFormalParameter().add(0, firstParameter);
        InformationItem lastParameter = new InformationItem();
        lastParameter.setName(new Name("last"));
        this.function.getFormalParameter().add(lastParameter);
        this.command = new RemoveParameterCommand(this.function, this.parameter, this.canvasOperation);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        this.assertFormalParameters(firstParameter, lastParameter);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        this.assertFormalParameters(firstParameter, this.parameter, lastParameter);
    }

    @Test
    public void testGraphCommandUndoWithNoParameters() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        this.assertFormalParameters(this.parameter);
    }

    private void assertFormalParameters(InformationItem ... parameters) {
        Assertions.assertThat((List)this.function.getFormalParameter()).containsExactly((Object[])parameters);
    }

    @Test
    public void testCanvasCommandAllow() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.handler));
    }

    @Test
    public void testCanvasCommandExecute() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.handler));
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandUndo() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.handler));
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }
}

