/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.undefined;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.undefined.SetCellValueCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.ExpressionGridCache;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=MockitoJUnitRunner.class)
public class SetCellValueCommandTest {
    private static final int ROW_INDEX = 0;
    private static final int COLUMN_INDEX = 0;
    private static final String UUID = "uuid";
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private GridWidget gridWidget;
    @Mock
    private GridData gridModel;
    @Mock
    private DMNModelInstrumentedBase hasExpressionParent;
    @Mock
    private HasExpression hasExpression;
    @Mock
    private Expression expression;
    @Mock
    private BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper> expressionEditor;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private GraphCommandExecutionContext graphCommandExecutionContext;
    @Mock
    private ExpressionGridCache expressionGridCache;
    @Mock
    private ParameterizedCommand<Optional<BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper>>> executeCanvasOperation;
    @Mock
    private Command undoCanvasOperation;
    @Mock
    private Expression oldExpression;
    @Mock
    private GridCell oldCell;
    @Mock
    private GridCellValue oldCellValue;
    @Captor
    private ArgumentCaptor<GridCellValue> gridCellValueCaptor;
    private SetCellValueCommand command;

    public void setup(Optional<String> uuid) {
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)this.gridModel);
        Mockito.when((Object)this.hasExpression.asDMNModelInstrumentedBase()).thenReturn((Object)this.hasExpressionParent);
        Mockito.when((Object)this.oldCell.getValue()).thenReturn((Object)this.oldCellValue);
        this.command = new SetCellValueCommand(new GridCellTuple(0, 0, this.gridWidget), uuid, this.hasExpression, () -> Optional.ofNullable(this.expression), this.expressionGridCache, this.executeCanvasOperation, this.undoCanvasOperation, () -> Optional.of(this.expressionEditor));
    }

    @Test
    public void checkGraphCommand() {
        this.setup(Optional.of(UUID));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.getGraphCommand(this.canvasHandler).allow((Object)this.graphCommandExecutionContext));
    }

    @Test
    public void executeGraphCommand() {
        this.setup(Optional.of(UUID));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.getGraphCommand(this.canvasHandler).execute((Object)this.graphCommandExecutionContext));
        ((HasExpression)Mockito.verify((Object)this.hasExpression)).setExpression(this.expression);
        ((Expression)Mockito.verify((Object)this.expression)).setParent(this.hasExpressionParent);
    }

    @Test
    public void undoGraphCommand() {
        this.setup(Optional.of(UUID));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.getGraphCommand(this.canvasHandler).undo((Object)this.graphCommandExecutionContext));
        ((HasExpression)Mockito.verify((Object)this.hasExpression)).setExpression(null);
    }

    @Test
    public void undoGraphCommandWithNonNullOriginalExpression() {
        Mockito.when((Object)this.hasExpression.getExpression()).thenReturn((Object)this.oldExpression);
        this.setup(Optional.of(UUID));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.getGraphCommand(this.canvasHandler).execute((Object)this.graphCommandExecutionContext));
        ((HasExpression)Mockito.verify((Object)this.hasExpression)).setExpression(this.expression);
        ((Expression)Mockito.verify((Object)this.expression)).setParent(this.hasExpressionParent);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.getGraphCommand(this.canvasHandler).undo((Object)this.graphCommandExecutionContext));
        ((HasExpression)Mockito.verify((Object)this.hasExpression)).setExpression((Expression)ArgumentMatchers.eq((Object)this.oldExpression));
    }

    @Test
    public void allowCanvasCommand() {
        this.setup(Optional.of(UUID));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).allow((Object)this.canvasHandler));
        ((GridData)Mockito.verify((Object)this.gridModel, (VerificationMode)Mockito.never())).setCellValue(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), (GridCellValue)ArgumentMatchers.any(GridCellValue.class));
    }

    @Test
    public void executeCanvasCommand() {
        this.setup(Optional.of(UUID));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).execute((Object)this.canvasHandler));
        ((ExpressionGridCache)Mockito.verify((Object)this.expressionGridCache)).putExpressionGrid((String)ArgumentMatchers.eq((Object)UUID), (Optional)ArgumentMatchers.eq(Optional.of(this.expressionEditor)));
        this.assertCanvasMutationOnExecute();
    }

    @Test
    public void executeCanvasCommandWithNestedGrid() {
        this.setup(Optional.empty());
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).execute((Object)this.canvasHandler));
        ((ExpressionGridCache)Mockito.verify((Object)this.expressionGridCache, (VerificationMode)Mockito.never())).putExpressionGrid((String)Mockito.any(), (Optional)ArgumentMatchers.any(Optional.class));
        this.assertCanvasMutationOnExecute();
    }

    @Test
    public void undoCanvasCommand() {
        this.setup(Optional.of(UUID));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).undo((Object)this.canvasHandler));
        ((ExpressionGridCache)Mockito.verify((Object)this.expressionGridCache)).removeExpressionGrid((String)ArgumentMatchers.eq((Object)UUID));
        this.assertCanvasMutationOnUndo();
    }

    @Test
    public void undoCanvasCommandWithNestedGrid() {
        this.setup(Optional.empty());
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).undo((Object)this.canvasHandler));
        ((ExpressionGridCache)Mockito.verify((Object)this.expressionGridCache, (VerificationMode)Mockito.never())).removeExpressionGrid((String)Mockito.any());
        this.assertCanvasMutationOnUndo();
    }

    @Test
    public void executeCanvasCommandThenUndoWithNonNullOriginalCell() {
        Mockito.when((Object)this.gridModel.getCell(0, 0)).thenReturn((Object)this.oldCell);
        this.setup(Optional.of(UUID));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).execute((Object)this.canvasHandler));
        this.assertCanvasMutationOnExecute();
        Mockito.reset((Object[])new GridData[]{this.gridModel});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).undo((Object)this.canvasHandler));
        this.assertCanvasMutationOnUndoWithNonNullOriginalCell();
    }

    @Test
    public void executeCanvasCommandThenUndoWithNonNullOriginalCellWithNestedGrid() {
        Mockito.when((Object)this.gridModel.getCell(0, 0)).thenReturn((Object)this.oldCell);
        this.setup(Optional.empty());
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).execute((Object)this.canvasHandler));
        this.assertCanvasMutationOnExecute();
        Mockito.reset((Object[])new GridData[]{this.gridModel});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).undo((Object)this.canvasHandler));
        this.assertCanvasMutationOnUndoWithNonNullOriginalCell();
    }

    @Test
    public void checkCommandDefinition() {
        this.setup(Optional.of(UUID));
        Assert.assertTrue((boolean)(this.command instanceof VetoExecutionCommand));
        Assert.assertTrue((boolean)(this.command instanceof VetoUndoCommand));
    }

    private void assertCanvasMutationOnExecute() {
        ((GridData)Mockito.verify((Object)this.gridModel)).setCellValue(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)0), (GridCellValue)this.gridCellValueCaptor.capture());
        GridCellValue gcv = (GridCellValue)this.gridCellValueCaptor.getValue();
        Assert.assertTrue((boolean)(gcv instanceof ExpressionCellValue));
        ExpressionCellValue ecv = (ExpressionCellValue)gcv;
        Assert.assertEquals(((Optional)ecv.getValue()).get(), this.expressionEditor);
        ((ParameterizedCommand)Mockito.verify(this.executeCanvasOperation)).execute(ArgumentMatchers.eq(Optional.of(this.expressionEditor)));
    }

    private void assertCanvasMutationOnUndo() {
        ((GridData)Mockito.verify((Object)this.gridModel)).deleteCell(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)0));
        ((Command)Mockito.verify((Object)this.undoCanvasOperation)).execute();
    }

    private void assertCanvasMutationOnUndoWithNonNullOriginalCell() {
        ((GridData)Mockito.verify((Object)this.gridModel)).setCellValue(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)0), (GridCellValue)ArgumentMatchers.eq((Object)this.oldCellValue));
        ((Command)Mockito.verify((Object)this.undoCanvasOperation)).execute();
    }
}

