/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.factory.graph;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.commands.factory.graph.DMNSetConnectionSourceNodeCommand;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNGraphsProvider;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.content.HasContentDefinitionId;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNSetConnectionSourceNodeCommandTest {
    private static final String EDGE_UUID = "edge uuid";
    private static final String NODE_DIAGRAM_UUID = "the id";
    private static final String SOURCE_NODE_UUID = "source node uuid";
    @Mock
    private Node<? extends View<?>, Edge> sourceNode;
    @Mock
    private Edge<? extends View, Node> edge;
    @Mock
    private Connection connection;
    @Mock
    private DMNGraphsProvider graphsProvider;
    @Mock
    private GraphCommandExecutionContext context;
    private DMNSetConnectionSourceNodeCommand command;

    @Before
    public void setup() {
        Node edgeSourceNode = this.createNode(NODE_DIAGRAM_UUID);
        Mockito.when((Object)this.sourceNode.getUUID()).thenReturn((Object)SOURCE_NODE_UUID);
        Mockito.when((Object)this.edge.getUUID()).thenReturn((Object)EDGE_UUID);
        Mockito.when((Object)this.edge.getSourceNode()).thenReturn((Object)edgeSourceNode);
        this.command = (DMNSetConnectionSourceNodeCommand)Mockito.spy((Object)new DMNSetConnectionSourceNodeCommand(this.sourceNode, this.edge, this.connection, this.graphsProvider));
    }

    @Test
    public void testGetSourceNodeWhenCommandBelongsToAnotherGraph() {
        Node node = (Node)Mockito.mock(Node.class);
        Graph graph = (Graph)Mockito.mock(Graph.class);
        ((DMNSetConnectionSourceNodeCommand)Mockito.doReturn((Object)true).when((Object)this.command)).commandBelongsToAnotherGraph();
        ((DMNSetConnectionSourceNodeCommand)Mockito.doReturn((Object)graph).when((Object)this.command)).getEdgesGraph();
        Mockito.when((Object)graph.getNode(SOURCE_NODE_UUID)).thenReturn((Object)node);
        Node currentSourceNode = this.command.getSourceNode(this.context);
        Assert.assertEquals((Object)node, (Object)currentSourceNode);
        ((DMNSetConnectionSourceNodeCommand)Mockito.verify((Object)this.command, (VerificationMode)Mockito.never())).superGetSourceNode(this.context);
    }

    @Test
    public void testGetSourceNodeWhenCommandBelongsToCurrentGraph() {
        Node node = (Node)Mockito.mock(Node.class);
        ((DMNSetConnectionSourceNodeCommand)Mockito.doReturn((Object)false).when((Object)this.command)).commandBelongsToAnotherGraph();
        ((DMNSetConnectionSourceNodeCommand)Mockito.doReturn((Object)node).when((Object)this.command)).superGetSourceNode(this.context);
        Node currentSourceNode = this.command.getSourceNode(this.context);
        Assert.assertEquals((Object)node, (Object)currentSourceNode);
        ((DMNSetConnectionSourceNodeCommand)Mockito.verify((Object)this.command)).superGetSourceNode(this.context);
    }

    @Test
    public void testGetNodeWhenCommandBelongsToAnotherGraph() {
        String uuid = "uuid";
        Graph graph = (Graph)Mockito.mock(Graph.class);
        Node node = (Node)Mockito.mock(Node.class);
        ((DMNSetConnectionSourceNodeCommand)Mockito.doReturn((Object)true).when((Object)this.command)).commandBelongsToAnotherGraph();
        ((DMNSetConnectionSourceNodeCommand)Mockito.doReturn((Object)graph).when((Object)this.command)).getEdgesGraph();
        Mockito.when((Object)graph.getNode("uuid")).thenReturn((Object)node);
        Node currentNode = this.command.getNode(this.context, "uuid");
        Assert.assertEquals((Object)node, (Object)currentNode);
    }

    @Test
    public void testGetNodeWhenCommandBelongsToCurrentGraph() {
        String uuid = "uuid";
        Node node = (Node)Mockito.mock(Node.class);
        ((DMNSetConnectionSourceNodeCommand)Mockito.doReturn((Object)false).when((Object)this.command)).commandBelongsToAnotherGraph();
        ((DMNSetConnectionSourceNodeCommand)Mockito.doReturn((Object)node).when((Object)this.command)).superGetNode(this.context, "uuid");
        Node currentNode = this.command.getNode(this.context, "uuid");
        Assert.assertEquals((Object)node, (Object)currentNode);
    }

    @Test
    public void testCommandBelongsToAnotherGraphWhenItIsNot() {
        String diagramId = "diagramId";
        Optional<String> commandDiagramId = Optional.of("diagramId");
        Mockito.when((Object)this.graphsProvider.getCurrentDiagramId()).thenReturn((Object)"diagramId");
        ((DMNSetConnectionSourceNodeCommand)Mockito.doReturn(commandDiagramId).when((Object)this.command)).getDiagramId();
        Assert.assertFalse((boolean)this.command.commandBelongsToAnotherGraph());
    }

    @Test
    public void testCommandBelongsToAnotherGraph() {
        String diagramId = "diagramId";
        String anotherDiagramId = "another diagram id";
        Optional<String> commandDiagramId = Optional.of("diagramId");
        Mockito.when((Object)this.graphsProvider.getCurrentDiagramId()).thenReturn((Object)"another diagram id");
        ((DMNSetConnectionSourceNodeCommand)Mockito.doReturn(commandDiagramId).when((Object)this.command)).getDiagramId();
        Assert.assertTrue((boolean)this.command.commandBelongsToAnotherGraph());
    }

    @Test
    public void testCommandBelongsToAnotherGraphWhenDiagramIdIsNotPresent() {
        String anotherDiagramId = "another diagram id";
        Mockito.when((Object)this.graphsProvider.getCurrentDiagramId()).thenReturn((Object)"another diagram id");
        ((DMNSetConnectionSourceNodeCommand)Mockito.doReturn(Optional.empty()).when((Object)this.command)).getDiagramId();
        Assert.assertFalse((boolean)this.command.commandBelongsToAnotherGraph());
    }

    @Test
    public void testGetEdgesGraph() {
        String diagramId = "diagram id";
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        Graph graph = (Graph)Mockito.mock(Graph.class);
        ((DMNSetConnectionSourceNodeCommand)Mockito.doReturn(Optional.of("diagram id")).when((Object)this.command)).getDiagramId();
        Mockito.when((Object)diagram.getGraph()).thenReturn((Object)graph);
        Mockito.when((Object)this.graphsProvider.getDiagram("diagram id")).thenReturn((Object)diagram);
        Graph actualGraph = this.command.getEdgesGraph();
        Assert.assertEquals((Object)graph, (Object)actualGraph);
    }

    @Test(expected=IllegalStateException.class)
    public void testGetEdgesGraphWhenDiagramIdIsNotSet() {
        ((DMNSetConnectionSourceNodeCommand)Mockito.doReturn(Optional.empty()).when((Object)this.command)).getDiagramId();
        this.command.getEdgesGraph();
    }

    private Node createNode(String diagramId) {
        Node node = (Node)Mockito.mock(Node.class);
        Definition definition = (Definition)Mockito.mock(Definition.class);
        HasContentDefinitionId hasContentDefinitionId = (HasContentDefinitionId)Mockito.mock(HasContentDefinitionId.class);
        Mockito.when((Object)node.getContent()).thenReturn((Object)definition);
        Mockito.when((Object)hasContentDefinitionId.getDiagramId()).thenReturn((Object)diagramId);
        Mockito.when((Object)definition.getDefinition()).thenReturn((Object)hasContentDefinitionId);
        return node;
    }
}

