/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.included.components;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.definition.model.ImportDMN;
import org.kie.workbench.common.dmn.api.definition.model.ImportPMML;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.LocationURI;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.api.included.legacy.DMNIncludeModelsClient;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponent;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponentFilter;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponents;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponentsItem;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionComponentsTest {
    @Mock
    private DecisionComponents.View view;
    @Mock
    private DMNIncludeModelsClient client;
    @Mock
    private ManagedInstance<DecisionComponentsItem> itemManagedInstance;
    @Mock
    private DecisionComponentFilter filter;
    @Mock
    private DMNDiagramsSession dmnDiagramsSession;
    @Mock
    private DMNGraphUtils dmnGraphUtils;
    @Mock
    private DecisionComponentsItem.View decisionComponentsItemView;
    @Captor
    private ArgumentCaptor<DecisionComponent> decisionComponentArgumentCaptor;
    private DecisionComponents decisionComponents;

    @Before
    public void setup() {
        this.decisionComponents = (DecisionComponents)Mockito.spy((Object)new DecisionComponents(this.view, this.client, this.itemManagedInstance, this.filter, this.dmnDiagramsSession, this.dmnGraphUtils));
    }

    @Test
    public void testInit() {
        this.decisionComponents.init();
        ((DecisionComponents.View)Mockito.verify((Object)this.view)).init((Object)this.decisionComponents);
    }

    @Test
    public void testGetView() {
        Assert.assertEquals((Object)this.view, (Object)this.decisionComponents.getView());
    }

    @Test
    public void testRefreshWhenIncludedNodeListsIsUpdated() {
        ArrayList<DMNIncludedModel> dmnModelIncludedModels = new ArrayList<DMNIncludedModel>();
        ArrayList<DMNIncludedModel> latestIncludedModelsLoaded = new ArrayList<DMNIncludedModel>();
        Mockito.when((Object)this.dmnDiagramsSession.isSessionStatePresent()).thenReturn((Object)true);
        ((DecisionComponents)Mockito.doReturn(dmnModelIncludedModels).when((Object)this.decisionComponents)).getDMNIncludedModels();
        ((DecisionComponents)Mockito.doReturn(latestIncludedModelsLoaded).when((Object)this.decisionComponents)).getLatestIncludedModelsLoaded();
        ((DecisionComponents)Mockito.doNothing().when((Object)this.decisionComponents)).refreshIncludedNodesList();
        ((DecisionComponents)Mockito.doNothing().when((Object)this.decisionComponents)).loadModelComponents();
        dmnModelIncludedModels.add(this.makeDMNIncludedModel("://namespace1"));
        dmnModelIncludedModels.add(this.makeDMNIncludedModel("://namespace2"));
        latestIncludedModelsLoaded.add(this.makeDMNIncludedModel("://namespace1"));
        latestIncludedModelsLoaded.add(this.makeDMNIncludedModel("://namespace2"));
        this.decisionComponents.refresh();
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents, (VerificationMode)Mockito.never())).refreshIncludedNodesList();
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents)).loadModelComponents();
    }

    @Test
    public void testRefreshWhenIncludedNodeListsIsNotUpdated() {
        ArrayList<DMNIncludedModel> dmnModelIncludedModels = new ArrayList<DMNIncludedModel>();
        ArrayList<DMNIncludedModel> latestIncludedModelsLoaded = new ArrayList<DMNIncludedModel>();
        Mockito.when((Object)this.dmnDiagramsSession.isSessionStatePresent()).thenReturn((Object)true);
        ((DecisionComponents)Mockito.doReturn(dmnModelIncludedModels).when((Object)this.decisionComponents)).getDMNIncludedModels();
        ((DecisionComponents)Mockito.doReturn(latestIncludedModelsLoaded).when((Object)this.decisionComponents)).getLatestIncludedModelsLoaded();
        ((DecisionComponents)Mockito.doNothing().when((Object)this.decisionComponents)).refreshIncludedNodesList();
        ((DecisionComponents)Mockito.doNothing().when((Object)this.decisionComponents)).loadModelComponents();
        dmnModelIncludedModels.add(this.makeDMNIncludedModel("://namespace1"));
        dmnModelIncludedModels.add(this.makeDMNIncludedModel("://namespace2"));
        dmnModelIncludedModels.add(this.makeDMNIncludedModel("://namespaceNEW"));
        latestIncludedModelsLoaded.add(this.makeDMNIncludedModel("://namespace1"));
        latestIncludedModelsLoaded.add(this.makeDMNIncludedModel("://namespace2"));
        this.decisionComponents.refresh();
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents)).refreshIncludedNodesList();
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents)).loadModelComponents();
    }

    @Test
    public void testRefreshWhenSessionStateIsNotPresent() {
        Mockito.when((Object)this.dmnDiagramsSession.isSessionStatePresent()).thenReturn((Object)false);
        this.decisionComponents.refresh();
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents, (VerificationMode)Mockito.never())).refreshIncludedNodesList();
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents, (VerificationMode)Mockito.never())).loadModelComponents();
    }

    @Test
    public void testRefresh() {
        Consumer<List> listConsumer = list -> {};
        ArrayList<DMNIncludedModel> includedModels = new ArrayList<DMNIncludedModel>();
        includedModels.add(this.makeDMNIncludedModel("://namespace1"));
        includedModels.add(this.makeDMNIncludedModel("://namespace2"));
        ((DecisionComponents)Mockito.doReturn(includedModels).when((Object)this.decisionComponents)).getDMNIncludedModels();
        ((DecisionComponents)Mockito.doReturn(listConsumer).when((Object)this.decisionComponents)).getNodesConsumer();
        this.decisionComponents.refreshIncludedNodesList();
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents)).startLoading();
        ((DMNIncludeModelsClient)Mockito.verify((Object)this.client)).loadNodesFromImports(includedModels, listConsumer);
        Assert.assertEquals(includedModels, (Object)this.decisionComponents.getLatestIncludedModelsLoaded());
    }

    @Test
    public void testLoadModelComponents() {
        String dmnModelName = "ModelName";
        DRGElement drgElement1 = (DRGElement)Mockito.mock(DRGElement.class);
        DRGElement drgElement2 = (DRGElement)Mockito.mock(DRGElement.class);
        DecisionComponent decisionComponent1 = (DecisionComponent)Mockito.mock(DecisionComponent.class);
        DecisionComponent decisionComponent2 = (DecisionComponent)Mockito.mock(DecisionComponent.class);
        ArrayList decisionComponentsList = new ArrayList();
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        Mockito.when((Object)definitions.getName()).thenReturn((Object)new Name("ModelName"));
        Mockito.when((Object)this.dmnGraphUtils.getModelDefinitions()).thenReturn((Object)definitions);
        Mockito.when((Object)this.dmnDiagramsSession.getModelDRGElements()).thenReturn(Arrays.asList(drgElement1, drgElement2));
        Mockito.when((Object)drgElement1.getName()).thenReturn((Object)new Name("Decision-1"));
        Mockito.when((Object)drgElement2.getName()).thenReturn((Object)new Name("Decision-2"));
        Mockito.when((Object)decisionComponent1.getName()).thenReturn((Object)"Decision-1");
        Mockito.when((Object)decisionComponent2.getName()).thenReturn((Object)"Decision-2");
        ((DecisionComponents)Mockito.doReturn((Object)decisionComponent1).when((Object)this.decisionComponents)).makeDecisionComponent("ModelName", drgElement1);
        ((DecisionComponents)Mockito.doReturn((Object)decisionComponent2).when((Object)this.decisionComponents)).makeDecisionComponent("ModelName", drgElement2);
        ((DecisionComponents)Mockito.doReturn(decisionComponentsList).when((Object)this.decisionComponents)).getModelDRGElements();
        ((DecisionComponents)Mockito.doNothing().when((Object)this.decisionComponents)).refreshView();
        this.decisionComponents.loadModelComponents();
        Assert.assertTrue((boolean)decisionComponentsList.contains(decisionComponent1));
        Assert.assertTrue((boolean)decisionComponentsList.contains(decisionComponent2));
        Assert.assertEquals((long)2L, (long)decisionComponentsList.size());
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents)).refreshView();
    }

    @Test
    public void testRefreshViewWhenDecisionComponentsListIsNotEmpty() {
        ArrayList<DecisionComponent> modelDRGElements = new ArrayList<DecisionComponent>();
        ArrayList<DecisionComponent> includedDRGElements = new ArrayList<DecisionComponent>();
        List decisionComponentsItems = (List)Mockito.spy(new ArrayList());
        ((DecisionComponents)Mockito.doReturn(modelDRGElements).when((Object)this.decisionComponents)).getModelDRGElements();
        ((DecisionComponents)Mockito.doReturn(includedDRGElements).when((Object)this.decisionComponents)).getIncludedDRGElements();
        ((DecisionComponents)Mockito.doReturn((Object)decisionComponentsItems).when((Object)this.decisionComponents)).getDecisionComponentsItems();
        ((List)Mockito.doReturn((Object)5).when((Object)decisionComponentsItems)).size();
        ((List)Mockito.doReturn((Object)false).when((Object)decisionComponentsItems)).isEmpty();
        ((DecisionComponents)Mockito.doNothing().when((Object)this.decisionComponents)).createDecisionComponentItem((DecisionComponent)ArgumentMatchers.any());
        modelDRGElements.add(this.makeDecisionComponent("Decision-1", "ModeName", false));
        modelDRGElements.add(this.makeDecisionComponent("Decision-1", "ModeName", false));
        modelDRGElements.add(this.makeDecisionComponent("Decision-3", "ModeName", false));
        includedDRGElements.add(this.makeDecisionComponent("included.Decision-1", "includedModel.dmn", true));
        includedDRGElements.add(this.makeDecisionComponent("included.Decision-2", "includedModel.dmn", true));
        this.decisionComponents.refreshView();
        ((List)Mockito.verify((Object)decisionComponentsItems)).clear();
        ((DecisionComponents.View)Mockito.verify((Object)this.view)).clear();
        ((DecisionComponents.View)Mockito.verify((Object)this.view)).setComponentsCounter(Integer.valueOf(5));
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents, (VerificationMode)Mockito.times((int)5))).createDecisionComponentItem((DecisionComponent)ArgumentMatchers.any(DecisionComponent.class));
        ((DecisionComponents.View)Mockito.verify((Object)this.view)).enableFilterInputs();
        ((DecisionComponents.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).disableFilterInputs();
        ((DecisionComponents.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showEmptyState();
    }

    @Test
    public void testRefreshViewWhenDecisionComponentsListIsEmpty() {
        ArrayList modelDRGElements = new ArrayList();
        ArrayList includedDRGElements = new ArrayList();
        List decisionComponentsItems = (List)Mockito.spy(new ArrayList());
        ((DecisionComponents)Mockito.doReturn(modelDRGElements).when((Object)this.decisionComponents)).getModelDRGElements();
        ((DecisionComponents)Mockito.doReturn(includedDRGElements).when((Object)this.decisionComponents)).getIncludedDRGElements();
        ((DecisionComponents)Mockito.doReturn((Object)decisionComponentsItems).when((Object)this.decisionComponents)).getDecisionComponentsItems();
        ((DecisionComponents)Mockito.doNothing().when((Object)this.decisionComponents)).createDecisionComponentItem((DecisionComponent)ArgumentMatchers.any());
        this.decisionComponents.refreshView();
        ((List)Mockito.verify((Object)decisionComponentsItems)).clear();
        ((DecisionComponents.View)Mockito.verify((Object)this.view)).clear();
        ((DecisionComponents.View)Mockito.verify((Object)this.view)).setComponentsCounter(Integer.valueOf(0));
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents, (VerificationMode)Mockito.never())).createDecisionComponentItem((DecisionComponent)ArgumentMatchers.any(DecisionComponent.class));
        ((DecisionComponents.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).enableFilterInputs();
        ((DecisionComponents.View)Mockito.verify((Object)this.view)).disableFilterInputs();
        ((DecisionComponents.View)Mockito.verify((Object)this.view)).showEmptyState();
    }

    @Test
    public void testGetDMNIncludedModelsOnlyIncludesDMN() {
        ImportDMN dmnImport = new ImportDMN();
        ImportPMML pmmlImport = new ImportPMML();
        dmnImport.getName().setValue("dmn");
        dmnImport.setImportType(DMNImportTypes.DMN.getDefaultNamespace());
        pmmlImport.setImportType(DMNImportTypes.PMML.getDefaultNamespace());
        Mockito.when((Object)this.dmnDiagramsSession.getModelImports()).thenReturn(Arrays.asList(dmnImport, pmmlImport));
        List includedModels = this.decisionComponents.getDMNIncludedModels();
        Assertions.assertThat((List)includedModels).hasSize(1);
        Assertions.assertThat((String)((DMNIncludedModel)includedModels.get(0)).getModelName()).isEqualTo("dmn");
        Assertions.assertThat((String)((DMNIncludedModel)includedModels.get(0)).getImportType()).isEqualTo(DMNImportTypes.DMN.getDefaultNamespace());
    }

    @Test
    public void testApplyTermFilter() {
        String value = "value";
        ((DecisionComponents)Mockito.doNothing().when((Object)this.decisionComponents)).applyFilter();
        this.decisionComponents.applyTermFilter("value");
        ((DecisionComponentFilter)Mockito.verify((Object)this.filter)).setTerm("value");
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents)).applyFilter();
    }

    @Test
    public void testApplyDrgElementFilterFilter() {
        String value = "value";
        ((DecisionComponents)Mockito.doNothing().when((Object)this.decisionComponents)).applyFilter();
        this.decisionComponents.applyDrgElementFilterFilter("value");
        ((DecisionComponentFilter)Mockito.verify((Object)this.filter)).setDrgElement("value");
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents)).applyFilter();
    }

    @Test
    public void testApplyFilter() {
        DecisionComponentsItem item1 = (DecisionComponentsItem)Mockito.mock(DecisionComponentsItem.class);
        DecisionComponentsItem item2 = (DecisionComponentsItem)Mockito.mock(DecisionComponentsItem.class);
        DecisionComponentsItem item3 = (DecisionComponentsItem)Mockito.mock(DecisionComponentsItem.class);
        DecisionComponent component1 = (DecisionComponent)Mockito.mock(DecisionComponent.class);
        DecisionComponent component2 = (DecisionComponent)Mockito.mock(DecisionComponent.class);
        DecisionComponent component3 = (DecisionComponent)Mockito.mock(DecisionComponent.class);
        List<DecisionComponentsItem> decisionComponentsItems = Arrays.asList(item1, item2, item3);
        ((DecisionComponents)Mockito.doReturn((Object)new DecisionComponentFilter()).when((Object)this.decisionComponents)).getFilter();
        ((DecisionComponents)Mockito.doReturn(decisionComponentsItems).when((Object)this.decisionComponents)).getDecisionComponentsItems();
        Mockito.when((Object)item1.getDecisionComponent()).thenReturn((Object)component1);
        Mockito.when((Object)item2.getDecisionComponent()).thenReturn((Object)component2);
        Mockito.when((Object)item3.getDecisionComponent()).thenReturn((Object)component3);
        Mockito.when((Object)component1.getName()).thenReturn((Object)"name3");
        Mockito.when((Object)component2.getName()).thenReturn((Object)"nome!!!");
        Mockito.when((Object)component3.getName()).thenReturn((Object)"name1");
        this.decisionComponents.getFilter().setTerm("name");
        this.decisionComponents.applyFilter();
        ((DecisionComponentsItem)Mockito.verify((Object)item1)).hide();
        ((DecisionComponentsItem)Mockito.verify((Object)item2)).hide();
        ((DecisionComponentsItem)Mockito.verify((Object)item3)).hide();
        ((DecisionComponentsItem)Mockito.verify((Object)item3)).show();
        ((DecisionComponentsItem)Mockito.verify((Object)item1)).show();
    }

    @Test
    public void testRemoveAllItems() {
        this.decisionComponents.removeAllItems();
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents)).clearDecisionComponents();
    }

    @Test
    public void testGetNodesConsumerWhenNodeListIsEmpty() {
        List list = Collections.emptyList();
        List includedDRGElements = (List)Mockito.spy(new ArrayList());
        ((DecisionComponents)Mockito.doReturn((Object)includedDRGElements).when((Object)this.decisionComponents)).getIncludedDRGElements();
        this.decisionComponents.getNodesConsumer().accept(list);
        ((DecisionComponents.View)Mockito.verify((Object)this.view)).hideLoading();
        ((List)Mockito.verify((Object)includedDRGElements)).clear();
        ((List)Mockito.verify((Object)includedDRGElements, (VerificationMode)Mockito.never())).add(ArgumentMatchers.any());
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents)).refreshView();
    }

    @Test
    public void testGetNodesConsumerWhenNodeListIsNotEmpty() {
        DMNIncludedNode dmnIncludedNode1 = (DMNIncludedNode)Mockito.mock(DMNIncludedNode.class);
        DMNIncludedNode dmnIncludedNode2 = (DMNIncludedNode)Mockito.mock(DMNIncludedNode.class);
        DecisionComponent drgDecisionComponent1 = (DecisionComponent)Mockito.mock(DecisionComponent.class);
        DecisionComponent drgDecisionComponent2 = (DecisionComponent)Mockito.mock(DecisionComponent.class);
        List<DMNIncludedNode> includedNodes = Arrays.asList(dmnIncludedNode1, dmnIncludedNode2);
        List includedDRGElements = (List)Mockito.spy(new ArrayList());
        ((DecisionComponents)Mockito.doReturn((Object)includedDRGElements).when((Object)this.decisionComponents)).getIncludedDRGElements();
        ((DecisionComponents)Mockito.doReturn((Object)drgDecisionComponent1).when((Object)this.decisionComponents)).makeDecisionComponent(dmnIncludedNode1);
        ((DecisionComponents)Mockito.doReturn((Object)drgDecisionComponent2).when((Object)this.decisionComponents)).makeDecisionComponent(dmnIncludedNode2);
        ((DecisionComponents)Mockito.doNothing().when((Object)this.decisionComponents)).refreshView();
        this.decisionComponents.getNodesConsumer().accept(includedNodes);
        ((DecisionComponents.View)Mockito.verify((Object)this.view)).hideLoading();
        ((List)Mockito.verify((Object)includedDRGElements)).clear();
        ((List)Mockito.verify((Object)includedDRGElements)).add(drgDecisionComponent1);
        ((List)Mockito.verify((Object)includedDRGElements)).add(drgDecisionComponent2);
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents)).refreshView();
    }

    @Test
    public void testGetNodesConsumerWhenNodesAreNull() {
        List includedDRGElements = (List)Mockito.spy(new ArrayList());
        ((DecisionComponents)Mockito.doReturn((Object)includedDRGElements).when((Object)this.decisionComponents)).getIncludedDRGElements();
        this.decisionComponents.getNodesConsumer().accept(null);
        ((DecisionComponents.View)Mockito.verify((Object)this.view)).hideLoading();
        ((List)Mockito.verify((Object)includedDRGElements, (VerificationMode)Mockito.never())).clear();
        ((List)Mockito.verify((Object)includedDRGElements, (VerificationMode)Mockito.never())).add(ArgumentMatchers.any());
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents, (VerificationMode)Mockito.never())).refreshView();
    }

    @Test
    public void testAsDMNIncludedModel() {
        String modelName = "Model Name";
        String namespace = "The Namespace";
        String type = "The type";
        String file = "my file.dmn";
        String filePath = "//users//some//my file.dmn";
        Import anImport = new Import();
        anImport.setName(new Name("Model Name"));
        anImport.setNamespace("The Namespace");
        anImport.setImportType("The type");
        anImport.setLocationURI(new LocationURI("//users//some//my file.dmn"));
        DMNIncludedModel includedModel = this.decisionComponents.asDMNIncludedModel(anImport);
        Assert.assertEquals((Object)"Model Name", (Object)includedModel.getModelName());
        Assert.assertEquals((Object)"The Namespace", (Object)includedModel.getNamespace());
        Assert.assertEquals((Object)"The type", (Object)includedModel.getImportType());
        Assert.assertEquals((Object)"my file.dmn", (Object)includedModel.getPath());
    }

    @Test
    public void testCreateDecisionComponentItem() {
        DecisionComponentsItem item = (DecisionComponentsItem)Mockito.mock(DecisionComponentsItem.class);
        List decisionComponentsItems = (List)Mockito.spy(new ArrayList());
        DecisionComponentsItem.View decisionComponentsView = (DecisionComponentsItem.View)Mockito.mock(DecisionComponentsItem.View.class);
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        DecisionComponent component = (DecisionComponent)Mockito.mock(DecisionComponent.class);
        Mockito.when((Object)decisionComponentsView.getElement()).thenReturn((Object)htmlElement);
        Mockito.when((Object)this.itemManagedInstance.get()).thenReturn((Object)item);
        Mockito.when((Object)item.getView()).thenReturn((Object)decisionComponentsView);
        ((DecisionComponents)Mockito.doReturn((Object)decisionComponentsItems).when((Object)this.decisionComponents)).getDecisionComponentsItems();
        this.decisionComponents.createDecisionComponentItem(component);
        ((DecisionComponentsItem)Mockito.verify((Object)item)).setDecisionComponent((DecisionComponent)ArgumentMatchers.any(DecisionComponent.class));
        ((List)Mockito.verify((Object)decisionComponentsItems)).add(item);
        ((DecisionComponents.View)Mockito.verify((Object)this.view)).addListItem(htmlElement);
    }

    @Test
    public void testCreateDecisionComponentItems() {
        ArrayList<DecisionComponent> decisionComponentsItems = new ArrayList<DecisionComponent>();
        decisionComponentsItems.add(this.makeDecisionComponent("Decision-1", "uuid1", "ModelName", false));
        decisionComponentsItems.add(this.makeDecisionComponent("Decision-1", "uuid1", "ModelName", false));
        decisionComponentsItems.add(this.makeDecisionComponent("Decision-1", "uuid2", "ModelName", false));
        decisionComponentsItems.add(this.makeDecisionComponent("included.Decision-2", "uuidA", "included.dmn", true));
        decisionComponentsItems.add(this.makeDecisionComponent("included.Decision-2", "uuidA", "included.dmn", true));
        decisionComponentsItems.add(this.makeDecisionComponent("included.Decision-2", "uuidB", "included.dmn", true));
        Mockito.when((Object)this.itemManagedInstance.get()).then(e -> new DecisionComponentsItem(this.decisionComponentsItemView));
        this.decisionComponents.createDecisionComponentItems(decisionComponentsItems);
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents, (VerificationMode)Mockito.times((int)4))).createDecisionComponentItem((DecisionComponent)this.decisionComponentArgumentCaptor.capture());
        List createdDecisionComponents = this.decisionComponentArgumentCaptor.getAllValues();
        Assert.assertEquals((Object)"uuid1", (Object)((DecisionComponent)createdDecisionComponents.get(0)).getDrgElement().getId().getValue());
        Assert.assertEquals((Object)"uuid2", (Object)((DecisionComponent)createdDecisionComponents.get(1)).getDrgElement().getId().getValue());
        Assert.assertEquals((Object)"uuidA", (Object)((DecisionComponent)createdDecisionComponents.get(2)).getDrgElement().getId().getValue());
        Assert.assertEquals((Object)"uuidB", (Object)((DecisionComponent)createdDecisionComponents.get(3)).getDrgElement().getId().getValue());
    }

    private DMNIncludedModel makeDMNIncludedModel(String namespace) {
        return new DMNIncludedModel("", "", "", namespace, "", Integer.valueOf(0), Integer.valueOf(0));
    }

    private DecisionComponent makeDecisionComponent(String name, String drgElementId, String fileName, boolean imported) {
        Decision decision = new Decision();
        decision.setName(new Name(name));
        decision.setId(new Id(drgElementId));
        return new DecisionComponent(fileName, (DRGElement)decision, imported);
    }

    private DecisionComponent makeDecisionComponent(String name, String fileName, boolean imported) {
        String drgElementId = new Id().getValue();
        return this.makeDecisionComponent(name, drgElementId, fileName, imported);
    }
}

