/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.tree;

import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.HTMLUListElement;
import elemental2.dom.Node;
import elemental2.dom.Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.assertj.core.api.Assertions;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItemBuilder;
import org.kie.workbench.common.dmn.client.docks.navigator.tree.DecisionNavigatorTreeView;
import org.kie.workbench.common.stunner.core.client.ReadOnlyProvider;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.LockRequiredEvent;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionNavigatorTreeViewTest {
    @Mock
    private HTMLDivElement view;
    @Mock
    private HTMLDivElement items;
    @Mock
    private ManagedInstance<DecisionNavigatorTreeView.TreeItem> managedInstance;
    @Mock
    private Elemental2DomUtil util;
    @Mock
    private elemental2.dom.HTMLElement icon;
    @Mock
    private elemental2.dom.HTMLElement textContent;
    @Mock
    private HTMLInputElement inputText;
    @Mock
    private elemental2.dom.HTMLElement save;
    @Mock
    private elemental2.dom.HTMLElement edit;
    @Mock
    private elemental2.dom.HTMLElement remove;
    @Mock
    private HTMLUListElement subItems;
    @Mock
    private ReadOnlyProvider readOnlyProvider;
    @Mock
    private EventSourceMock<LockRequiredEvent> locker;
    private DecisionNavigatorTreeView treeView;
    private DecisionNavigatorTreeView.TreeItem treeItem;

    @Before
    public void setup() {
        this.treeView = (DecisionNavigatorTreeView)Mockito.spy((Object)new DecisionNavigatorTreeView(this.view, this.items, this.managedInstance, this.util));
        this.treeItem = (DecisionNavigatorTreeView.TreeItem)Mockito.spy((Object)new DecisionNavigatorTreeView.TreeItem(this.textContent, this.inputText, this.icon, this.subItems, this.save, this.edit, this.remove, this.locker, this.readOnlyProvider));
    }

    @Test
    public void testClean() {
        Element element = (Element)Mockito.mock(Element.class);
        this.items.firstChild = element;
        Mockito.when((Object)this.items.removeChild((Node)element)).then(a -> {
            this.items.firstChild = null;
            return element;
        });
        this.treeView.clean();
        ((HTMLDivElement)Mockito.verify((Object)this.items)).removeChild((Node)element);
    }

    @Test
    public void testSetup() {
        ArrayList items = new ArrayList();
        Element element = (Element)Mockito.mock(Element.class);
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)element).when((Object)this.treeView)).makeTree(items);
        this.treeView.setup(items);
        ((HTMLDivElement)Mockito.verify((Object)this.items)).appendChild((Node)element);
    }

    @Test
    public void testMakeTree() {
        DecisionNavigatorItem item = this.makeItem("uuid");
        List<DecisionNavigatorItem> items = Collections.singletonList(item);
        Element expectedTreeElement = (Element)Mockito.mock(Element.class);
        Element treeItemElement = (Element)Mockito.mock(Element.class);
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)expectedTreeElement).when((Object)this.treeView)).createElement("ul");
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)treeItemElement).when((Object)this.treeView)).makeTreeItemElement(item);
        Element actualTreeElement = this.treeView.makeTree(items);
        ((Element)Mockito.verify((Object)expectedTreeElement)).appendChild((Node)treeItemElement);
        Assert.assertEquals((Object)expectedTreeElement, (Object)actualTreeElement);
    }

    @Test
    public void testFindTreeItemTextElement() {
        this.treeView.findTreeItemTextElement("123");
        ((DecisionNavigatorTreeView)Mockito.verify((Object)this.treeView)).itemsQuerySelector("[data-uuid=\"123\"] div");
    }

    @Test
    public void testItemsQuerySelector() {
        String selector = "selector";
        this.treeView.itemsQuerySelector("selector");
        ((HTMLDivElement)Mockito.verify((Object)this.items)).querySelector("selector");
    }

    @Test
    public void testMakeTreeItemElement() {
        DecisionNavigatorItem item = this.makeItem("uuid");
        DecisionNavigatorTreeView.TreeItem newTreeItem = (DecisionNavigatorTreeView.TreeItem)Mockito.mock(DecisionNavigatorTreeView.TreeItem.class);
        DecisionNavigatorTreeView.TreeItem treeItem = (DecisionNavigatorTreeView.TreeItem)Mockito.mock(DecisionNavigatorTreeView.TreeItem.class);
        Element childrenTree = (Element)Mockito.mock(Element.class);
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        elemental2.dom.HTMLElement expectedHtmlElement = (elemental2.dom.HTMLElement)Mockito.mock(elemental2.dom.HTMLElement.class);
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)childrenTree).when((Object)this.treeView)).makeTree((Collection)item.getChildren());
        Mockito.when((Object)this.managedInstance.get()).thenReturn((Object)newTreeItem);
        Mockito.when((Object)newTreeItem.setup(item, childrenTree)).thenReturn((Object)treeItem);
        Mockito.when((Object)treeItem.getElement()).thenReturn((Object)htmlElement);
        Mockito.when((Object)this.util.asHTMLElement(htmlElement)).thenReturn((Object)expectedHtmlElement);
        Element actualHtmlElement = this.treeView.makeTreeItemElement(item);
        Assert.assertEquals((Object)expectedHtmlElement, (Object)actualHtmlElement);
    }

    @Test
    public void testSelect() {
        String uuid = "uuid";
        Element newElement = (Element)Mockito.mock(Element.class);
        Element oldElement = (Element)Mockito.mock(Element.class);
        DOMTokenList newDomTokenList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        DOMTokenList oldDomTokenList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        newElement.classList = newDomTokenList;
        oldElement.classList = oldDomTokenList;
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)newElement).when((Object)this.treeView)).findTreeItemTextElement("uuid");
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)oldElement).when((Object)this.treeView)).getSelectedElement();
        this.treeView.select("uuid");
        ((DOMTokenList)Mockito.verify((Object)oldDomTokenList)).remove(new String[]{"selected"});
        ((DOMTokenList)Mockito.verify((Object)newDomTokenList)).add(new String[]{"selected"});
        ((DecisionNavigatorTreeView)Mockito.verify((Object)this.treeView)).deselect(oldElement);
        ((DecisionNavigatorTreeView)Mockito.verify((Object)this.treeView)).select(newElement);
        ((DecisionNavigatorTreeView)Mockito.verify((Object)this.treeView)).setSelectedElement(newElement);
    }

    @Test
    public void testDeselect() {
        DOMTokenList domTokenList;
        Element element = (Element)Mockito.mock(Element.class);
        element.classList = domTokenList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DecisionNavigatorTreeView)Mockito.doReturn((Object)element).when((Object)this.treeView)).getSelectedElement();
        this.treeView.deselect();
        ((DOMTokenList)Mockito.verify((Object)domTokenList)).remove(new String[]{"selected"});
        ((DecisionNavigatorTreeView)Mockito.verify((Object)this.treeView)).deselect(element);
    }

    @Test
    public void testTreeItemOnIconClick() {
        ClickEvent event = (ClickEvent)Mockito.mock(ClickEvent.class);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doNothing().when((Object)this.treeItem)).toggle();
        this.treeItem.onIconClick(event);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.verify((Object)this.treeItem)).toggle();
        ((ClickEvent)Mockito.verify((Object)event)).stopPropagation();
    }

    @Test
    public void testTreeItemOnTextContentClick() {
        ClickEvent event = (ClickEvent)Mockito.mock(ClickEvent.class);
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)item).when((Object)this.treeItem)).getItem();
        this.treeItem.onTextContentClick(event);
        ((DecisionNavigatorItem)Mockito.verify((Object)item)).onClick();
    }

    @Test
    public void testTreeItemOnInputTextKeyPressWhenKeyIsEnter() {
        KeyDownEvent event = (KeyDownEvent)Mockito.mock(KeyDownEvent.class);
        NativeEvent nativeEvent = (NativeEvent)Mockito.mock(NativeEvent.class);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doNothing().when((Object)this.treeItem)).save();
        Mockito.when((Object)event.getNativeEvent()).thenReturn((Object)nativeEvent);
        Mockito.when((Object)nativeEvent.getKeyCode()).thenReturn((Object)13);
        this.treeItem.onInputTextKeyPress(event);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.verify((Object)this.treeItem)).save();
    }

    @Test
    public void testTreeItemOnInputTextKeyPressWhenKeyIsNotEnter() {
        KeyDownEvent event = (KeyDownEvent)Mockito.mock(KeyDownEvent.class);
        NativeEvent nativeEvent = (NativeEvent)Mockito.mock(NativeEvent.class);
        Mockito.when((Object)event.getNativeEvent()).thenReturn((Object)nativeEvent);
        Mockito.when((Object)nativeEvent.getKeyCode()).thenReturn((Object)99);
        this.treeItem.onInputTextKeyPress(event);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.verify((Object)this.treeItem, (VerificationMode)Mockito.never())).save();
    }

    @Test
    public void testOnInputTextBlur() {
        BlurEvent event = (BlurEvent)Mockito.mock(BlurEvent.class);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doNothing().when((Object)this.treeItem)).save();
        this.treeItem.onInputTextBlur(event);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.verify((Object)this.treeItem)).save();
    }

    @Test
    public void testOnSaveClick() {
        ClickEvent event = (ClickEvent)Mockito.mock(ClickEvent.class);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doNothing().when((Object)this.treeItem)).save();
        this.treeItem.onSaveClick(event);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.verify((Object)this.treeItem)).save();
    }

    @Test
    public void testOnEditClick() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        ClickEvent event = (ClickEvent)Mockito.mock(ClickEvent.class);
        org.jboss.errai.common.client.dom.DOMTokenList tokenList = (org.jboss.errai.common.client.dom.DOMTokenList)Mockito.mock(org.jboss.errai.common.client.dom.DOMTokenList.class);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)element).when((Object)this.treeItem)).getElement();
        Mockito.when((Object)element.getClassList()).thenReturn((Object)tokenList);
        this.treeItem.onEditClick(event);
        ((org.jboss.errai.common.client.dom.DOMTokenList)Mockito.verify((Object)tokenList)).add("editing");
    }

    @Test
    public void testOnRemoveClick() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        ClickEvent event = (ClickEvent)Mockito.mock(ClickEvent.class);
        org.jboss.errai.common.client.dom.DOMTokenList tokenList = (org.jboss.errai.common.client.dom.DOMTokenList)Mockito.mock(org.jboss.errai.common.client.dom.DOMTokenList.class);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)element).when((Object)this.treeItem)).getElement();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)item).when((Object)this.treeItem)).getItem();
        Mockito.when((Object)element.getClassList()).thenReturn((Object)tokenList);
        this.treeItem.onRemoveClick(event);
        ((DecisionNavigatorItem)Mockito.verify((Object)item)).onRemove();
        ((EventSourceMock)Mockito.verify(this.locker)).fire(ArgumentMatchers.any());
    }

    @Test
    public void testSave() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        org.jboss.errai.common.client.dom.DOMTokenList tokenList = (org.jboss.errai.common.client.dom.DOMTokenList)Mockito.mock(org.jboss.errai.common.client.dom.DOMTokenList.class);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doNothing().when((Object)this.treeItem)).updateLabel();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)element).when((Object)this.treeItem)).getElement();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)item).when((Object)this.treeItem)).getItem();
        Mockito.when((Object)element.getClassList()).thenReturn((Object)tokenList);
        this.treeItem.save();
        ((DecisionNavigatorItem)Mockito.verify((Object)item)).setLabel(this.inputText.value);
        ((org.jboss.errai.common.client.dom.DOMTokenList)Mockito.verify((Object)tokenList)).remove("editing");
        ((DecisionNavigatorTreeView.TreeItem)Mockito.verify((Object)this.treeItem)).updateLabel();
        ((DecisionNavigatorItem)Mockito.verify((Object)item)).onUpdate();
        ((EventSourceMock)Mockito.verify(this.locker)).fire(ArgumentMatchers.any());
    }

    @Test
    public void testTreeItemSetup() {
        DecisionNavigatorItem expectedItem = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        Element children = (Element)Mockito.mock(Element.class);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doNothing().when((Object)this.treeItem)).updateDataUUID();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doNothing().when((Object)this.treeItem)).updateTitle();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doNothing().when((Object)this.treeItem)).updateCSSClass();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doNothing().when((Object)this.treeItem)).updateLabel();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doNothing().when((Object)this.treeItem)).updateSubItems(children);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doNothing().when((Object)this.treeItem)).initOuiaComponentAttributes();
        DecisionNavigatorTreeView.TreeItem actualTreeItem = this.treeItem.setup(expectedItem, children);
        DecisionNavigatorItem actualItem = this.treeItem.getItem();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.verify((Object)this.treeItem)).updateDataUUID();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.verify((Object)this.treeItem)).updateTitle();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.verify((Object)this.treeItem)).updateCSSClass();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.verify((Object)this.treeItem)).updateLabel();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.verify((Object)this.treeItem)).updateSubItems(children);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.verify((Object)this.treeItem)).initOuiaComponentAttributes();
        Assert.assertEquals((Object)this.treeItem, (Object)actualTreeItem);
        Assert.assertEquals((Object)expectedItem, (Object)actualItem);
    }

    @Test
    public void testTreeItemUpdateDataUUID() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        String uuid = "uuid";
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)item).when((Object)this.treeItem)).getItem();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)element).when((Object)this.treeItem)).getElement();
        Mockito.when((Object)item.getUUID()).thenReturn((Object)"uuid");
        this.treeItem.updateDataUUID();
        ((HTMLElement)Mockito.verify((Object)element)).setAttribute("data-uuid", "uuid");
    }

    @Test
    public void testTreeItemUpdateTitle() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        String label = "label";
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)item).when((Object)this.treeItem)).getItem();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)element).when((Object)this.treeItem)).getElement();
        Mockito.when((Object)item.getLabel()).thenReturn((Object)"label");
        this.treeItem.updateTitle();
        ((HTMLElement)Mockito.verify((Object)element)).setAttribute("title", "label");
    }

    @Test
    public void testTreeItemUpdateCSSClassWhenItemHasChildren() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        final DecisionNavigatorItem child = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        TreeSet<DecisionNavigatorItem> children = new TreeSet<DecisionNavigatorItem>(){
            {
                this.add(child);
            }
        };
        org.jboss.errai.common.client.dom.DOMTokenList classList = (org.jboss.errai.common.client.dom.DOMTokenList)Mockito.mock(org.jboss.errai.common.client.dom.DOMTokenList.class);
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        String cssClass = "css-class";
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)item).when((Object)this.treeItem)).getItem();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)element).when((Object)this.treeItem)).getElement();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)"css-class").when((Object)this.treeItem)).getCSSClass(item);
        Mockito.when((Object)element.getClassList()).thenReturn((Object)classList);
        Mockito.when((Object)item.getChildren()).thenReturn((Object)children);
        Mockito.when((Object)item.isEditable()).thenReturn((Object)true);
        this.treeItem.updateCSSClass();
        ((org.jboss.errai.common.client.dom.DOMTokenList)Mockito.verify((Object)classList)).add("css-class");
        ((org.jboss.errai.common.client.dom.DOMTokenList)Mockito.verify((Object)classList)).add("parent-node");
        ((org.jboss.errai.common.client.dom.DOMTokenList)Mockito.verify((Object)classList)).add("editable");
    }

    @Test
    public void testTreeItemUpdateCSSClassWhenItemDoesNotHaveChildren() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        org.jboss.errai.common.client.dom.DOMTokenList classList = (org.jboss.errai.common.client.dom.DOMTokenList)Mockito.mock(org.jboss.errai.common.client.dom.DOMTokenList.class);
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        String cssClass = "css-class";
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)item).when((Object)this.treeItem)).getItem();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)element).when((Object)this.treeItem)).getElement();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)"css-class").when((Object)this.treeItem)).getCSSClass(item);
        Mockito.when((Object)element.getClassList()).thenReturn((Object)classList);
        Mockito.when((Object)item.isEditable()).thenReturn((Object)false);
        this.treeItem.updateCSSClass();
        ((org.jboss.errai.common.client.dom.DOMTokenList)Mockito.verify((Object)classList)).add("css-class");
        ((org.jboss.errai.common.client.dom.DOMTokenList)Mockito.verify((Object)classList, (VerificationMode)Mockito.never())).add("parent-node");
        ((org.jboss.errai.common.client.dom.DOMTokenList)Mockito.verify((Object)classList, (VerificationMode)Mockito.never())).add("editable");
    }

    @Test
    public void testTreeItemUpdateCSSClassWhenItemHasChildrenAndIsReadOnly() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        final DecisionNavigatorItem child = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        TreeSet<DecisionNavigatorItem> children = new TreeSet<DecisionNavigatorItem>(){
            {
                this.add(child);
            }
        };
        org.jboss.errai.common.client.dom.DOMTokenList classList = (org.jboss.errai.common.client.dom.DOMTokenList)Mockito.mock(org.jboss.errai.common.client.dom.DOMTokenList.class);
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        String cssClass = "css-class";
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)item).when((Object)this.treeItem)).getItem();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)element).when((Object)this.treeItem)).getElement();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)"css-class").when((Object)this.treeItem)).getCSSClass(item);
        Mockito.when((Object)element.getClassList()).thenReturn((Object)classList);
        Mockito.when((Object)item.getChildren()).thenReturn((Object)children);
        Mockito.when((Object)item.isEditable()).thenReturn((Object)true);
        Mockito.when((Object)this.readOnlyProvider.isReadOnlyDiagram()).thenReturn((Object)true);
        this.treeItem.updateCSSClass();
        ((org.jboss.errai.common.client.dom.DOMTokenList)Mockito.verify((Object)classList)).add("css-class");
        ((org.jboss.errai.common.client.dom.DOMTokenList)Mockito.verify((Object)classList)).add("parent-node");
        ((org.jboss.errai.common.client.dom.DOMTokenList)Mockito.verify((Object)classList, (VerificationMode)Mockito.never())).add("editable");
    }

    @Test
    public void testTreeItemUpdateCSSClassWhenItemDoesNotHaveChildrenAndIsReadOnly() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        org.jboss.errai.common.client.dom.DOMTokenList classList = (org.jboss.errai.common.client.dom.DOMTokenList)Mockito.mock(org.jboss.errai.common.client.dom.DOMTokenList.class);
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        String cssClass = "css-class";
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)item).when((Object)this.treeItem)).getItem();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)element).when((Object)this.treeItem)).getElement();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)"css-class").when((Object)this.treeItem)).getCSSClass(item);
        Mockito.when((Object)element.getClassList()).thenReturn((Object)classList);
        Mockito.when((Object)item.isEditable()).thenReturn((Object)false);
        Mockito.when((Object)this.readOnlyProvider.isReadOnlyDiagram()).thenReturn((Object)true);
        this.treeItem.updateCSSClass();
        ((org.jboss.errai.common.client.dom.DOMTokenList)Mockito.verify((Object)classList)).add("css-class");
        ((org.jboss.errai.common.client.dom.DOMTokenList)Mockito.verify((Object)classList, (VerificationMode)Mockito.never())).add("parent-node");
        ((org.jboss.errai.common.client.dom.DOMTokenList)Mockito.verify((Object)classList, (VerificationMode)Mockito.never())).add("editable");
    }

    @Test
    public void testTreeItemUpdateLabel() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        Text textNode = (Text)Mockito.mock(Text.class);
        String label = "label";
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)item).when((Object)this.treeItem)).getItem();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)textNode).when((Object)this.treeItem)).getTextNode("label");
        Mockito.when((Object)item.getLabel()).thenReturn((Object)"label");
        this.treeItem.updateLabel();
        Assert.assertEquals((Object)"label", (Object)this.inputText.value);
        ((elemental2.dom.HTMLElement)Mockito.verify((Object)this.textContent)).appendChild((Node)textNode);
    }

    @Test
    public void testTreeItemUpdateSubItems() {
        Node parentNode;
        Element children = (Element)Mockito.mock(Element.class);
        this.subItems.parentNode = parentNode = (Node)Mockito.mock(Node.class);
        this.treeItem.updateSubItems(children);
        ((Node)Mockito.verify((Object)parentNode)).replaceChild((Node)children, (Node)this.subItems);
    }

    @Test
    public void testTreeItemInitOuiaAttributes() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        Text textNode = (Text)Mockito.mock(Text.class);
        String label = "label";
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)element).when((Object)this.treeItem)).getElement();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)item).when((Object)this.treeItem)).getItem();
        ((DecisionNavigatorItem)Mockito.doReturn((Object)DecisionNavigatorItem.Type.DECISION).when((Object)item)).getType();
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)textNode).when((Object)this.treeItem)).getTextNode("label");
        Mockito.when((Object)item.getLabel()).thenReturn((Object)"label");
        this.treeItem.initOuiaComponentAttributes();
        ((HTMLElement)Mockito.verify((Object)element)).setAttribute("data-ouia-component-type", "dmn-graph-navigator-decision");
        ((HTMLElement)Mockito.verify((Object)element)).setAttribute("data-ouia-component-id", "dmn-graph-navigator-decision-label");
    }

    @Test
    public void testTreeItemInitOuiaAttributesIllegalState() {
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn(null).when((Object)this.treeItem)).getItem();
        Assertions.assertThatThrownBy(() -> this.treeItem.initOuiaComponentAttributes()).hasMessage("Decision Navigator item can not be null");
    }

    @Test
    public void testTreeItemToggle() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        org.jboss.errai.common.client.dom.DOMTokenList classList = (org.jboss.errai.common.client.dom.DOMTokenList)Mockito.mock(org.jboss.errai.common.client.dom.DOMTokenList.class);
        ((DecisionNavigatorTreeView.TreeItem)Mockito.doReturn((Object)element).when((Object)this.treeItem)).getElement();
        ((HTMLElement)Mockito.doReturn((Object)classList).when((Object)element)).getClassList();
        this.treeItem.toggle();
        ((org.jboss.errai.common.client.dom.DOMTokenList)Mockito.verify((Object)classList)).toggle("closed");
    }

    @Test
    public void testTreeItemGetCSSClass() {
        String uuid = "uuid";
        String label = "label";
        DecisionNavigatorItem.Type subItem = DecisionNavigatorItem.Type.CONTEXT;
        Command onClick = () -> {};
        String expectedCSSClass = "kie-context";
        DecisionNavigatorItem item = new DecisionNavigatorItemBuilder().withUUID("uuid").withLabel("label").withType(subItem).withOnClick(onClick).build();
        String actualCSSClass = this.treeItem.getCSSClass(item);
        Assert.assertEquals((Object)"kie-context", (Object)actualCSSClass);
    }

    private DecisionNavigatorItem makeItem(String uuid) {
        return this.makeItem(uuid, null);
    }

    private DecisionNavigatorItem makeItem(String uuid, String parentUUID) {
        return new DecisionNavigatorItemBuilder().withUUID(uuid).withParentUUID(parentUUID).build();
    }
}

