/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.common.persistence;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.common.persistence.ActiveRecord;
import org.kie.workbench.common.dmn.client.editors.common.persistence.RecordEngine;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class ActiveRecordTest {
    @Test
    public void testGetRecordEngineWhenRecordEngineIsNull() {
        ActiveRecord<Data> activeRecord = new ActiveRecord<Data>(null){

            protected Data getRecord() {
                return null;
            }
        };
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((ActiveRecord)activeRecord).getRecordEngine()).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("'ActiveRecord' operations are not supported. Please provide a record engine.");
    }

    @Test
    public void testGetRecordEngineWhenRecordEngineIsNotNull() {
        RecordEngine<Data> expectedRecordEngine = this.makeRecordEngine();
        ActiveRecord<Data> activeRecord = new ActiveRecord<Data>(expectedRecordEngine){

            protected Data getRecord() {
                return null;
            }
        };
        RecordEngine actualRecordEngine = activeRecord.getRecordEngine();
        Assert.assertEquals(expectedRecordEngine, (Object)actualRecordEngine);
    }

    @Test
    public void testUpdate() {
        RecordEngine<Data> engine = this.makeRecordEngine();
        ActiveRecord<Data> activeRecord = this.activeRecord(engine);
        activeRecord.update();
        ((RecordEngine)Mockito.verify(engine)).update(activeRecord.getRecord());
    }

    @Test
    public void testDestroy() {
        RecordEngine<Data> engine = this.makeRecordEngine();
        ActiveRecord<Data> activeRecord = this.activeRecord(engine);
        activeRecord.destroy();
        ((RecordEngine)Mockito.verify(engine)).destroy(activeRecord.getRecord());
    }

    @Test
    public void testCreate() {
        RecordEngine<Data> engine = this.makeRecordEngine();
        ActiveRecord<Data> activeRecord = this.activeRecord(engine);
        activeRecord.create();
        ((RecordEngine)Mockito.verify(engine)).create(activeRecord.getRecord());
    }

    @Test
    public void testIsValidWhenItIsTrue() {
        RecordEngine<Data> engine = this.makeRecordEngine();
        ActiveRecord<Data> activeRecord = this.activeRecord(engine);
        ((RecordEngine)Mockito.doReturn((Object)true).when(engine)).isValid(ArgumentMatchers.any());
        Assert.assertTrue((boolean)activeRecord.isValid());
    }

    @Test
    public void testIsValidWhenItIsFalse() {
        RecordEngine<Data> engine = this.makeRecordEngine();
        ActiveRecord<Data> activeRecord = this.activeRecord(engine);
        ((RecordEngine)Mockito.doReturn((Object)false).when(engine)).isValid(ArgumentMatchers.any());
        Assert.assertFalse((boolean)activeRecord.isValid());
    }

    @Test
    public void testIsRecordEnginePresentWhenRecordEngineIsPresent() {
        ActiveRecord<Data> record = this.activeRecord(null);
        Assert.assertFalse((boolean)record.isRecordEnginePresent());
    }

    @Test
    public void testIsRecordEnginePresentWhenRecordEngineIsNotPresent() {
        ActiveRecord<Data> record = this.activeRecord(this.makeRecordEngine());
        Assert.assertTrue((boolean)record.isRecordEnginePresent());
    }

    private ActiveRecord<Data> activeRecord(RecordEngine<Data> engine) {
        final Data record = new Data();
        return (ActiveRecord)Mockito.spy((Object)new ActiveRecord<Data>(engine){

            protected Data getRecord() {
                return record;
            }
        });
    }

    private RecordEngine<Data> makeRecordEngine() {
        return (RecordEngine)Mockito.spy((Object)new RecordEngine<Data>(){

            public List<Data> update(Data record) {
                return null;
            }

            public List<Data> destroy(Data record) {
                return null;
            }

            public List<Data> create(Data record) {
                return null;
            }

            public boolean isValid(Data record) {
                return true;
            }
        });
    }

    private class Data {
        private Data() {
        }
    }
}

