/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.contextmenu;

import elemental2.core.JsArray;
import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.EventTarget;
import elemental2.dom.HTMLDocument;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.client.editors.contextmenu.ContextMenu;
import org.kie.workbench.common.dmn.client.editors.contextmenu.ContextMenuView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelector;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.uberfire.mvp.Command;

public class ContextMenuViewTest {
    private ContextMenuView contextMenuView;
    private ContextMenu presenter;
    private ListSelector listSelector;

    @Before
    public void setUp() throws NoSuchFieldException, IllegalAccessException {
        this.presenter = (ContextMenu)Mockito.mock(ContextMenu.class);
        this.listSelector = (ListSelector)Mockito.mock(ListSelector.class);
        Field field = DomGlobal.class.getDeclaredField("document");
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(DomGlobal.class, Mockito.mock(HTMLDocument.class));
        this.contextMenuView = new ContextMenuView(this.listSelector);
        this.contextMenuView.init(this.presenter);
    }

    @Test
    public void testWhenShowingContextMenuViewThenAlsoListSelectorIsShown() {
        this.contextMenuView.show();
        ((ListSelector)Mockito.verify((Object)this.listSelector)).bind((HasListSelectorControl)ArgumentMatchers.any(), Mockito.anyInt(), Mockito.anyInt());
        ((ListSelector)Mockito.verify((Object)this.listSelector)).show();
    }

    @Test
    public void testWhenHidingContextMenuViewThenAlsoListSelectorIsHidden() {
        this.contextMenuView.hide();
        ((ListSelector)Mockito.verify((Object)this.listSelector)).hide();
    }

    @Test
    public void testWhenGettingItemsThenTheyAreReturned() {
        String textTitle = "TEXT";
        Command doNothing = () -> {};
        Mockito.when((Object)this.presenter.getItems()).thenReturn(Collections.singletonList(HasListSelectorControl.ListSelectorTextItem.build((String)"TEXT", (boolean)true, (Command)doNothing)));
        List items = this.contextMenuView.getItems(0, 0);
        HasListSelectorControl.ListSelectorTextItem textItem = (HasListSelectorControl.ListSelectorTextItem)items.get(0);
        Assertions.assertThat((List)items).isNotNull();
        Assertions.assertThat((List)items).isNotEmpty();
        Assertions.assertThat((int)items.size()).isEqualTo(1);
        Assertions.assertThat((Object)textItem).extracting(HasListSelectorControl.ListSelectorTextItem::getText).isEqualTo((Object)"TEXT");
        Assertions.assertThat((Object)textItem).extracting(HasListSelectorControl.ListSelectorTextItem::isEnabled).isEqualTo((Object)true);
        Assertions.assertThat((Object)textItem).extracting(HasListSelectorControl.ListSelectorTextItem::getCommand).isEqualTo((Object)doNothing);
    }

    @Test
    public void testWhenSelectingAnItemThenAssociatedCommandIsExecutedAndContextMenuGetsHidden() {
        HasListSelectorControl.ListSelectorTextItem textItem = (HasListSelectorControl.ListSelectorTextItem)Mockito.mock(HasListSelectorControl.ListSelectorTextItem.class);
        Command command = (Command)Mockito.mock(Command.class);
        Mockito.when((Object)this.presenter.getItems()).thenReturn(Collections.singletonList(textItem));
        Mockito.when((Object)textItem.getCommand()).thenReturn((Object)command);
        this.contextMenuView.onItemSelected((HasListSelectorControl.ListSelectorItem)textItem);
        ((Command)Mockito.verify((Object)command)).execute();
        ((ListSelector)Mockito.verify((Object)this.listSelector)).hide();
    }

    @Test
    public void testWhenGettingEventPath() {
        Event event = (Event)Mockito.mock(Event.class);
        Element element = (Element)Mockito.mock(Element.class);
        ArrayList<Element> pathArray = new ArrayList<Element>();
        String value = "test-val";
        event.path = (JsArray)Mockito.spy((Object)new JsArray((Object[])new Element[0]));
        pathArray.add(element);
        ((JsArray)Mockito.doReturn(pathArray).when((Object)event.path)).asList();
        Mockito.when((Object)element.getAttribute((String)Mockito.any())).thenReturn((Object)"test-val");
        List eventPath = this.contextMenuView.getEventPath(event);
        Assertions.assertThat((List)eventPath).isNotNull();
        Assertions.assertThat((List)eventPath).isNotEmpty();
        Assertions.assertThat((int)eventPath.size()).isEqualTo(1);
        Assertions.assertThat(eventPath.get(0)).extracting(elem -> elem.getAttribute("test-attr")).isEqualTo((Object)"test-val");
    }

    @Test
    public void testWhenGettingEventPathAndPathIsNull() {
        Event event = (Event)Mockito.mock(Event.class);
        Element element = (Element)Mockito.mock(Element.class);
        JsArray composedPath = (JsArray)Mockito.spy((Object)new JsArray((Object[])new EventTarget[0]));
        ArrayList<Element> composedPathAsList = new ArrayList<Element>();
        String value = "test-val";
        event.path = null;
        composedPathAsList.add(element);
        ((JsArray)Mockito.doReturn(composedPathAsList).when((Object)composedPath)).asList();
        Mockito.when((Object)event.composedPath()).thenReturn((Object)composedPath);
        Mockito.when((Object)element.getAttribute((String)Mockito.any())).thenReturn((Object)"test-val");
        List eventPath = this.contextMenuView.getEventPath(event);
        Assertions.assertThat((List)eventPath).isNotNull();
        Assertions.assertThat((List)eventPath).isNotEmpty();
        Assertions.assertThat((int)eventPath.size()).isEqualTo(1);
        Assertions.assertThat(eventPath.get(0)).extracting(elem -> elem.getAttribute("test-attr")).isEqualTo((Object)"test-val");
    }
}

