/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.documentation.links;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import java.util.Optional;
import java.util.function.Consumer;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.property.dmn.DMNExternalLink;
import org.kie.workbench.common.dmn.client.editors.documentation.links.NameAndUrlPopoverViewImpl;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.views.pfly.widgets.JQueryProducer;
import org.uberfire.client.views.pfly.widgets.Popover;

@RunWith(value=GwtMockitoTestRunner.class)
public class NameAndUrlPopoverViewImplTest {
    @Mock
    private Div popoverElement;
    @Mock
    private Div popoverContentElement;
    @Mock
    private JQueryProducer.JQuery<Popover> jQueryPopover;
    @Mock
    private TranslationService translationService;
    @Mock
    private HTMLButtonElement cancelButton;
    @Mock
    private HTMLButtonElement okButton;
    @Mock
    private HTMLInputElement urlInput;
    @Mock
    private HTMLInputElement attachmentNameInput;
    @Mock
    private HTMLElement urlLabel;
    @Mock
    private HTMLElement attachmentName;
    @Mock
    private HTMLElement attachmentTip;
    private NameAndUrlPopoverViewImpl popover;

    @Before
    public void setup() {
        this.popover = (NameAndUrlPopoverViewImpl)Mockito.spy((Object)new NameAndUrlPopoverViewImpl(this.popoverElement, this.popoverContentElement, this.jQueryPopover, this.translationService, this.cancelButton, this.okButton, this.urlInput, this.attachmentNameInput, this.urlLabel, this.attachmentName, this.attachmentTip));
    }

    @Test
    public void testInit() {
        String url = "url";
        String name = "name";
        String urlPlaceholder = "urlPlaceholder";
        String namePlaceholder = "namePlaceholder";
        Mockito.when((Object)this.translationService.getTranslation("DMNDocumentationI18n.URL")).thenReturn((Object)"url");
        Mockito.when((Object)this.translationService.getTranslation("DMNDocumentationI18n.Name")).thenReturn((Object)"name");
        Mockito.when((Object)this.translationService.getTranslation("DMNDocumentationI18n.URLPlaceholder")).thenReturn((Object)"urlPlaceholder");
        Mockito.when((Object)this.translationService.getTranslation("DMNDocumentationI18n.NamePlaceholder")).thenReturn((Object)"namePlaceholder");
        this.popover.init();
        Assert.assertEquals((Object)"url", (Object)this.urlLabel.textContent);
        Assert.assertEquals((Object)"name", (Object)this.attachmentName.textContent);
        Assert.assertEquals((Object)"urlPlaceholder", (Object)this.urlInput.placeholder);
        Assert.assertEquals((Object)"namePlaceholder", (Object)this.attachmentNameInput.placeholder);
    }

    @Test
    public void testOnClickOkButton() {
        String description = "description";
        String url = "url";
        ArgumentCaptor captor = ArgumentCaptor.forClass(DMNExternalLink.class);
        Consumer onExternalLinkCreated = (Consumer)Mockito.mock(Consumer.class);
        this.attachmentNameInput.value = "description";
        this.urlInput.value = "url";
        this.popover.setOnExternalLinkCreated(onExternalLinkCreated);
        this.popover.onClickOkButton(null);
        ((Consumer)Mockito.verify((Object)onExternalLinkCreated)).accept(captor.capture());
        DMNExternalLink externalLink = (DMNExternalLink)captor.getValue();
        Assert.assertEquals((Object)"description", (Object)externalLink.getDescription());
        Assert.assertEquals((Object)"url", (Object)externalLink.getUrl());
        ((NameAndUrlPopoverViewImpl)Mockito.verify((Object)this.popover)).hide();
    }

    @Test
    public void testOnClickCancelButton() {
        this.popover.onClickCancelButton(null);
        ((NameAndUrlPopoverViewImpl)Mockito.verify((Object)this.popover)).hide();
    }

    @Test
    public void testShow() {
        ((NameAndUrlPopoverViewImpl)Mockito.doNothing().when((Object)this.popover)).superShow((Optional)ArgumentMatchers.any());
        this.popover.show(Optional.of(""));
        ((NameAndUrlPopoverViewImpl)Mockito.verify((Object)this.popover)).clear();
    }

    @Test
    public void testClear() {
        this.attachmentNameInput.value = "old";
        this.urlInput.value = "old value";
        this.popover.clear();
        Assert.assertEquals((Object)"", (Object)this.attachmentNameInput.value);
        Assert.assertEquals((Object)"", (Object)this.urlInput.value);
    }
}

