/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.drd;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.CSSStyleDeclaration;
import elemental2.dom.DomGlobal;
import elemental2.dom.HTMLBodyElement;
import elemental2.dom.HTMLDocument;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagramElement;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramTuple;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.editors.contextmenu.ContextMenu;
import org.kie.workbench.common.dmn.client.editors.drd.DRDContextMenu;
import org.kie.workbench.common.dmn.client.editors.drd.DRDContextMenuService;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class DRDContextMenuTest {
    private DRDContextMenu drdContextMenu;
    @Mock
    private ContextMenu contextMenu;
    @Mock
    private ClientTranslationService translationService;
    @Mock
    private DRDContextMenuService drdContextMenuService;
    @Mock
    private org.kie.workbench.common.stunner.core.graph.Node<? extends Definition<?>, Edge> node;
    @Mock
    private HTMLElement element;
    @Mock
    private CSSStyleDeclaration styleDeclaration;
    @Mock
    private HTMLDocument htmlDocument;
    @Mock
    private HTMLBodyElement body;
    @Mock
    private DMNDiagramsSession dmnDiagramsSession;

    @Before
    public void setUp() {
        this.drdContextMenu = new DRDContextMenu(this.contextMenu, this.translationService, this.drdContextMenuService, this.dmnDiagramsSession);
    }

    @Test
    public void testGetTitle() {
        this.drdContextMenu.getTitle();
        ((ClientTranslationService)Mockito.verify((Object)this.translationService)).getValue((String)Mockito.eq((Object)"DRDActions.ContextMenu.Title"));
    }

    @Test
    public void testGetElement() {
        this.drdContextMenu.getElement();
        ((ContextMenu)Mockito.verify((Object)this.contextMenu)).getElement();
    }

    @Test
    public void testShow() {
        this.drdContextMenu.show(new ArrayList());
        ((ContextMenu)Mockito.verify((Object)this.contextMenu)).show((Consumer)Mockito.any());
    }

    @Test
    public void testContextMenuHandler() {
        DMNDiagramTuple diagramTuple1 = new DMNDiagramTuple((Diagram)Mockito.mock(Diagram.class), new DMNDiagramElement());
        DMNDiagramTuple diagramTuple2 = new DMNDiagramTuple((Diagram)Mockito.mock(Diagram.class), new DMNDiagramElement());
        List<DMNDiagramTuple> diagrams = Arrays.asList(diagramTuple1, diagramTuple2);
        DMNDiagramElement diagramElement = (DMNDiagramElement)Mockito.mock(DMNDiagramElement.class);
        PowerMockito.when((Object)this.translationService.getValue((String)Mockito.any())).thenReturn((Object)"");
        PowerMockito.when((Object)this.drdContextMenuService.getDiagrams()).thenReturn(diagrams);
        PowerMockito.when((Object)this.dmnDiagramsSession.getDRGDiagramElement()).thenReturn((Object)diagramElement);
        PowerMockito.when((Object)this.dmnDiagramsSession.getCurrentDMNDiagramElement()).thenReturn(Optional.of(diagramElement));
        this.drdContextMenu.setDRDContextMenuHandler(this.contextMenu, Collections.singletonList(this.node));
        ((ContextMenu)Mockito.verify((Object)this.contextMenu)).setHeaderMenu((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((ContextMenu)Mockito.verify((Object)this.contextMenu, (VerificationMode)Mockito.times((int)4))).addTextMenuItem((String)ArgumentMatchers.any(), Mockito.anyBoolean(), (Command)ArgumentMatchers.any());
    }

    @Test
    public void testAppendContextMenuToTheDOM() throws NoSuchFieldException, IllegalAccessException {
        PowerMockito.when((Object)this.contextMenu.getElement()).thenReturn((Object)this.element);
        Field field = HTMLElement.class.getDeclaredField("style");
        field.setAccessible(true);
        field.set(this.element, this.styleDeclaration);
        Field field2 = DomGlobal.class.getDeclaredField("document");
        field2.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field2, field2.getModifiers() & 0xFFFFFFEF);
        field2.set(DomGlobal.class, this.htmlDocument);
        Field field3 = HTMLDocument.class.getDeclaredField("body");
        field3.setAccessible(true);
        field3.set(this.htmlDocument, this.body);
        this.drdContextMenu.appendContextMenuToTheDOM(10.0, 10.0);
        ((HTMLBodyElement)Mockito.verify((Object)this.body)).appendChild((Node)Mockito.any());
    }
}

