/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions;

import com.ait.lienzo.client.core.mediator.IMediator;
import com.ait.lienzo.client.core.mediator.Mediators;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionContainerGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorViewImpl;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.session.DMNEditorSession;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.ExpressionGridCache;
import org.kie.workbench.common.dmn.client.widgets.grid.ExpressionGridCacheImpl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.keyboard.KeyboardOperationEscapeGridCell;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanelContainer;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidgetKeyboardHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperation;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationEditCell;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationInvokeContextMenuForSelectedCell;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveDown;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveLeft;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveRight;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveUp;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.RestrictedMousePanMediator;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ExpressionEditorViewImplTest {
    private static final String NODE_UUID = "uuid";
    private static final String UNDEFINED_EXPRESSION_DEFINITION_NAME = "Undefined";
    private static final String LITERAL_EXPRESSION_DEFINITION_NAME = "Literal Expression";
    @Mock
    private Anchor returnToLink;
    @Mock
    private Span expressionName;
    @Mock
    private Span expressionType;
    @Mock
    private DMNGridPanel gridPanel;
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private RestrictedMousePanMediator mousePanMediator;
    @Mock
    private CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    private ExpressionEditorView.Presenter presenter;
    @Mock
    private TranslationService translationService;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private DMNEditorSession session;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private DefaultCanvasCommandFactory canvasCommandFactory;
    @Mock
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    private EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    @Mock
    private EventSourceMock<DomainObjectSelectionEvent> domainObjectSelectionEvent;
    @Mock
    private ExpressionEditorDefinition undefinedExpressionEditorDefinition;
    @Mock
    private BaseExpressionGrid undefinedExpressionEditor;
    @Mock
    private ExpressionEditorDefinition literalExpressionEditorDefinition;
    @Mock
    private BaseExpressionGrid literalExpressionEditor;
    @Mock
    private Viewport viewport;
    @Mock
    private Element gridPanelElement;
    @Mock
    private Mediators viewportMediators;
    @Mock
    private ExpressionEditorDefinition<Expression> editorDefinition;
    @Mock
    private BaseExpressionGrid editor;
    @Mock
    private HasExpression hasExpression;
    @Captor
    private ArgumentCaptor<Transform> transformArgumentCaptor;
    @Captor
    private ArgumentCaptor<GridWidget> expressionContainerArgumentCaptor;
    @Captor
    private ArgumentCaptor<TransformMediator> transformMediatorArgumentCaptor;
    @Captor
    private ArgumentCaptor<KeyboardOperation> keyboardOperationArgumentCaptor;
    private ExpressionGridCache expressionGridCache;
    private DMNGridPanelContainer gridPanelContainer;
    private ExpressionEditorViewImpl view;

    @Before
    public void setup() {
        this.expressionGridCache = new ExpressionGridCacheImpl();
        this.gridPanelContainer = (DMNGridPanelContainer)Mockito.spy((Object)new DMNGridPanelContainer());
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getExpressionGridCache()).thenReturn((Object)this.expressionGridCache);
        Mockito.when((Object)this.session.getGridPanel()).thenReturn((Object)this.gridPanel);
        Mockito.when((Object)this.session.getGridLayer()).thenReturn((Object)this.gridLayer);
        Mockito.when((Object)this.session.getCellEditorControls()).thenReturn((Object)this.cellEditorControls);
        Mockito.when((Object)this.session.getMousePanMediator()).thenReturn((Object)this.mousePanMediator);
        ((DMNGridPanel)Mockito.doReturn((Object)this.viewport).when((Object)this.gridPanel)).getViewport();
        ((Viewport)Mockito.doReturn((Object)this.viewportMediators).when((Object)this.viewport)).getMediators();
        ((DMNGridPanel)Mockito.doReturn((Object)this.gridPanelElement).when((Object)this.gridPanel)).getElement();
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.editor)).when(this.editorDefinition)).getEditor((GridCellTuple)ArgumentMatchers.any(GridCellTuple.class), (Optional)ArgumentMatchers.any(Optional.class), (HasExpression)ArgumentMatchers.any(HasExpression.class), (Optional)ArgumentMatchers.any(Optional.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt());
        ((BaseExpressionGrid)Mockito.doReturn((Object)new BaseGridData()).when((Object)this.editor)).getModel();
        this.view = (ExpressionEditorViewImpl)Mockito.spy((Object)new ExpressionEditorViewImpl(this.returnToLink, this.expressionName, this.expressionType, this.gridPanelContainer, this.translationService, this.listSelector, this.sessionManager, this.sessionCommandManager, this.canvasCommandFactory, this.expressionEditorDefinitionsSupplier, this.refreshFormPropertiesEvent, this.domainObjectSelectionEvent));
        this.view.init(this.presenter);
        this.view.bind((DMNSession)this.session);
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)this.undefinedExpressionEditorDefinition);
        expressionEditorDefinitions.add((Object)this.literalExpressionEditorDefinition);
        Mockito.when((Object)this.expressionEditorDefinitionsSupplier.get()).thenReturn((Object)expressionEditorDefinitions);
        Mockito.when((Object)this.undefinedExpressionEditorDefinition.getModelClass()).thenReturn(Optional.empty());
        Mockito.when((Object)this.undefinedExpressionEditorDefinition.getName()).thenReturn((Object)UNDEFINED_EXPRESSION_DEFINITION_NAME);
        Mockito.when((Object)this.undefinedExpressionEditor.getModel()).thenReturn((Object)new BaseGridData());
        Mockito.when((Object)this.undefinedExpressionEditorDefinition.getEditor((GridCellTuple)ArgumentMatchers.any(GridCellTuple.class), (Optional)ArgumentMatchers.any(Optional.class), (HasExpression)ArgumentMatchers.any(HasExpression.class), (Optional)ArgumentMatchers.any(Optional.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt())).thenReturn(Optional.of(this.undefinedExpressionEditor));
        Mockito.when((Object)this.literalExpressionEditorDefinition.getModelClass()).thenReturn(Optional.of(new LiteralExpression()));
        Mockito.when((Object)this.literalExpressionEditorDefinition.getName()).thenReturn((Object)LITERAL_EXPRESSION_DEFINITION_NAME);
        Mockito.when((Object)this.literalExpressionEditor.getModel()).thenReturn((Object)new BaseGridData());
        Mockito.when((Object)this.literalExpressionEditorDefinition.getEditor((GridCellTuple)ArgumentMatchers.any(GridCellTuple.class), (Optional)ArgumentMatchers.any(Optional.class), (HasExpression)ArgumentMatchers.any(HasExpression.class), (Optional)ArgumentMatchers.any(Optional.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt())).thenReturn(Optional.of(this.literalExpressionEditor));
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[1]).when((Object)this.translationService)).format((String)Mockito.any(), (Object[])ArgumentMatchers.anyObject());
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0]).when((Object)this.translationService)).getTranslation((String)Mockito.any());
    }

    @Test
    public void testBind() {
        ((ExpressionEditorViewImpl)Mockito.verify((Object)this.view)).setupGridPanel();
        ((ExpressionEditorViewImpl)Mockito.verify((Object)this.view)).setupGridWidget();
        ((ExpressionEditorViewImpl)Mockito.verify((Object)this.view)).setupGridWidgetPanControl();
    }

    @Test
    public void testSetupGridPanel() {
        ((Viewport)Mockito.verify((Object)this.viewport)).setTransform((Transform)this.transformArgumentCaptor.capture());
        Transform transform = (Transform)this.transformArgumentCaptor.getValue();
        Assert.assertEquals((double)1.0, (double)transform.getScaleX(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)transform.getScaleY(), (double)0.0);
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).addKeyDownHandler((KeyDownHandler)ArgumentMatchers.any(BaseGridWidgetKeyboardHandler.class));
        ((DMNGridPanelContainer)Mockito.verify((Object)this.gridPanelContainer)).clear();
        ((DMNGridPanelContainer)Mockito.verify((Object)this.gridPanelContainer)).setWidget((Widget)this.gridPanel);
        ((ExpressionEditorViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)7))).addKeyboardOperation((BaseGridWidgetKeyboardHandler)ArgumentMatchers.any(BaseGridWidgetKeyboardHandler.class), (KeyboardOperation)this.keyboardOperationArgumentCaptor.capture());
        List operations = this.keyboardOperationArgumentCaptor.getAllValues();
        Assertions.assertThat(operations.get(0)).isInstanceOf(KeyboardOperationEditCell.class);
        Assertions.assertThat(operations.get(1)).isInstanceOf(KeyboardOperationEscapeGridCell.class);
        Assertions.assertThat(operations.get(2)).isInstanceOf(KeyboardOperationMoveLeft.class);
        Assertions.assertThat(operations.get(3)).isInstanceOf(KeyboardOperationMoveRight.class);
        Assertions.assertThat(operations.get(4)).isInstanceOf(KeyboardOperationMoveUp.class);
        Assertions.assertThat(operations.get(5)).isInstanceOf(KeyboardOperationMoveDown.class);
        Assertions.assertThat(operations.get(6)).isInstanceOf(KeyboardOperationInvokeContextMenuForSelectedCell.class);
    }

    @Test
    public void testSetupGridWidget() {
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).removeAll();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).add((IPrimitive)this.expressionContainerArgumentCaptor.capture());
        GridWidget expressionContainer = (GridWidget)this.expressionContainerArgumentCaptor.getValue();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)ArgumentMatchers.eq((Object)expressionContainer));
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).enterPinnedMode((GridWidget)ArgumentMatchers.eq((Object)expressionContainer), (Command)ArgumentMatchers.any(Command.class));
    }

    @Test
    public void testSetupGridWidgetPanControl() {
        ((RestrictedMousePanMediator)Mockito.verify((Object)this.mousePanMediator)).setTransformMediator((TransformMediator)this.transformMediatorArgumentCaptor.capture());
        TransformMediator transformMediator = (TransformMediator)this.transformMediatorArgumentCaptor.getValue();
        ((RestrictedMousePanMediator)Mockito.verify((Object)this.mousePanMediator)).setBatchDraw(true);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).setDefaultTransformMediator((TransformMediator)ArgumentMatchers.eq((Object)transformMediator));
        ((Mediators)Mockito.verify((Object)this.viewportMediators)).push((IMediator)ArgumentMatchers.eq((Object)this.mousePanMediator));
    }

    @Test
    public void testOnResize() {
        this.view.onResize();
        ((DMNGridPanelContainer)Mockito.verify((Object)this.gridPanelContainer)).onResize();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).onResize();
    }

    @Test
    public void testSetReturnToLinkText() {
        String RETURN_LINK = "return-link";
        this.view.setReturnToLinkText("return-link");
        ((Anchor)Mockito.verify((Object)this.returnToLink)).setTextContent((String)ArgumentMatchers.eq((Object)"return-link"));
    }

    @Test
    public void testSetExpression() {
        Optional hasName = Optional.empty();
        this.view.setExpression(NODE_UUID, this.hasExpression, hasName, false);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).add((IPrimitive)this.expressionContainerArgumentCaptor.capture());
        ExpressionContainerGrid expressionContainer = (ExpressionContainerGrid)this.expressionContainerArgumentCaptor.getValue();
        Assert.assertFalse((boolean)expressionContainer.isOnlyVisualChangeAllowed());
    }

    @Test
    public void testSetExpressionWhenOnlyVisualChangeAllowed() {
        Optional hasName = Optional.empty();
        this.view.setExpression(NODE_UUID, this.hasExpression, hasName, true);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).add((IPrimitive)this.expressionContainerArgumentCaptor.capture());
        ExpressionContainerGrid expressionContainer = (ExpressionContainerGrid)this.expressionContainerArgumentCaptor.getValue();
        Assert.assertTrue((boolean)expressionContainer.isOnlyVisualChangeAllowed());
    }

    @Test
    public void testSetExpressionDoesUpdateExpressionNameTextWhenHasNameIsNotEmpty() {
        String NAME = "NAME";
        Name name = new Name("NAME");
        HasName hasNameMock = (HasName)Mockito.mock(HasName.class);
        ((HasName)Mockito.doReturn((Object)name).when((Object)hasNameMock)).getName();
        Optional<HasName> hasName = Optional.of(hasNameMock);
        this.view.setExpression(NODE_UUID, this.hasExpression, hasName, false);
        ((Span)Mockito.verify((Object)this.expressionName)).setTextContent((String)ArgumentMatchers.eq((Object)"NAME"));
    }

    @Test
    public void testSetExpressionDoesNotUpdateExpressionNameTextWhenHasNameIsEmpty() {
        Optional hasName = Optional.empty();
        this.view.setExpression(NODE_UUID, this.hasExpression, hasName, false);
        ((Span)Mockito.verify((Object)this.expressionName, (VerificationMode)Mockito.never())).setTextContent((String)ArgumentMatchers.any(String.class));
    }

    @Test
    public void testSetExpressionDoesUpdateExpressionTypeTextWhenHasExpressionIsNotEmpty() {
        LiteralExpression expression = new LiteralExpression();
        Optional hasName = Optional.empty();
        Mockito.when((Object)this.hasExpression.getExpression()).thenReturn((Object)expression);
        this.view.setExpression(NODE_UUID, this.hasExpression, hasName, false);
        ((Span)Mockito.verify((Object)this.expressionType)).setTextContent((String)ArgumentMatchers.eq((Object)LITERAL_EXPRESSION_DEFINITION_NAME));
    }

    @Test
    public void testSetExpressionDoesNotUpdateExpressionTypeTextWhenHasExpressionTextWhenHasExpressionIsEmpty() {
        Optional hasName = Optional.empty();
        this.view.setExpression(NODE_UUID, this.hasExpression, hasName, false);
        ((Span)Mockito.verify((Object)this.expressionType)).setTextContent((String)ArgumentMatchers.eq((Object)"<Undefined>"));
    }

    @Test
    public void testOnClickReturnToLink() {
        this.view.onClickReturnToLink((ClickEvent)Mockito.mock(ClickEvent.class));
        ((ExpressionEditorView.Presenter)Mockito.verify((Object)this.presenter)).exit();
    }

    @Test
    public void testRefresh() {
        this.view.refresh();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }

    @Test
    public void testSetFocus() {
        this.view.setFocus();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).setFocus(true);
    }
}

