/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionType;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class ExpressionEditorDefinitionsTest {
    @Mock
    private ExpressionEditorDefinition<Expression> definition1;
    @Mock
    private ExpressionEditorDefinition<Expression> definition2;
    @Mock
    private ExpressionEditorDefinition<Expression> definition3;
    private ExpressionEditorDefinitions definitions;

    @Before
    public void setup() {
        this.definitions = new ExpressionEditorDefinitions();
        this.definitions.add(this.definition1);
        this.definitions.add(this.definition2);
        this.definitions.add(this.definition3);
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(new LiteralExpression())).when(this.definition1)).getModelClass();
        ((ExpressionEditorDefinition)Mockito.doReturn((Object)ExpressionType.LITERAL_EXPRESSION).when(this.definition1)).getType();
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(new Context())).when(this.definition2)).getModelClass();
        ((ExpressionEditorDefinition)Mockito.doReturn((Object)ExpressionType.CONTEXT).when(this.definition2)).getType();
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.empty()).when(this.definition3)).getModelClass();
        ((ExpressionEditorDefinition)Mockito.doReturn((Object)ExpressionType.UNDEFINED).when(this.definition3)).getType();
    }

    @Test
    public void textLookupForUndefinedExpression() {
        Assert.assertEquals(this.definition3, this.definitions.getExpressionEditorDefinition(Optional.empty()).get());
    }

    @Test
    public void textLookupByExpressionClass() {
        Assert.assertEquals(this.definition1, this.definitions.getExpressionEditorDefinition(Optional.of(new LiteralExpression())).get());
        Assert.assertEquals(this.definition2, this.definitions.getExpressionEditorDefinition(Optional.of(new Context())).get());
    }

    @Test
    public void textLookupByExpressionType() {
        Assert.assertEquals(this.definition1, this.definitions.getExpressionEditorDefinition(ExpressionType.LITERAL_EXPRESSION).get());
        Assert.assertEquals(this.definition2, this.definitions.getExpressionEditorDefinition(ExpressionType.CONTEXT).get());
    }
}

