/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.context;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridData;

@RunWith(value=MockitoJUnitRunner.class)
public class ExpressionCellValueTest {
    @Mock
    private BaseExpressionGrid editor;
    private ExpressionCellValue ecv;

    private void setup(Optional<BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper>> editor) {
        this.ecv = new ExpressionCellValue(editor);
    }

    @Test
    public void testMinimumWidthWhenNoEditorSet() {
        this.setup(Optional.empty());
        Assert.assertFalse((boolean)this.ecv.getMinimumWidth().isPresent());
    }

    @Test
    public void testMinimumWidthWhenEditorSet() {
        ((BaseExpressionGrid)Mockito.doReturn((Object)100.0).when((Object)this.editor)).getMinimumWidth();
        this.setup(Optional.of(this.editor));
        Optional oMinimumWidth = this.ecv.getMinimumWidth();
        Assert.assertTrue((boolean)oMinimumWidth.isPresent());
        Assert.assertEquals((double)100.0, (double)((Double)oMinimumWidth.get()), (double)0.0);
    }
}

