/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.BuiltinAggregator;
import org.kie.workbench.common.dmn.api.definition.model.HitPolicy;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy.BuiltinAggregatorUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy.HasHitPolicyControl;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy.HitPolicyPopoverImpl;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy.HitPolicyPopoverView;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=LienzoMockitoTestRunner.class)
public class HitPolicyPopoverImplTest {
    private static final int UI_ROW_INDEX = 0;
    private static final int UI_COLUMN_INDEX = 1;
    @Mock
    private HitPolicyPopoverView view;
    @Mock
    private HasHitPolicyControl control;
    @Mock
    private TranslationService translationService;
    @Captor
    private ArgumentCaptor<List<HitPolicy>> hitPoliciesCaptor;
    @Captor
    private ArgumentCaptor<List<BuiltinAggregator>> builtInAggregatorsCaptor;
    @Captor
    private ArgumentCaptor<Command> commandCaptor;
    private HitPolicyPopoverView.Presenter editor;
    private BuiltinAggregatorUtils builtinAggregatorUtils;

    @Before
    public void setup() {
        this.builtinAggregatorUtils = new BuiltinAggregatorUtils(this.translationService);
        this.editor = new HitPolicyPopoverImpl(this.view, this.translationService, this.builtinAggregatorUtils);
        Mockito.when((Object)this.control.getHitPolicy()).thenReturn(null);
        Mockito.when((Object)this.control.getBuiltinAggregator()).thenReturn(null);
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0].toString()).when((Object)this.translationService)).format((String)Mockito.any(), new Object[0]);
    }

    @Test
    public void testConstruction() {
        ((HitPolicyPopoverView)Mockito.verify((Object)this.view)).init(ArgumentMatchers.eq((Object)this.editor));
        ((HitPolicyPopoverView)Mockito.verify((Object)this.view)).initHitPolicies((List)this.hitPoliciesCaptor.capture());
        ((HitPolicyPopoverView)Mockito.verify((Object)this.view)).initBuiltinAggregators((List)this.builtInAggregatorsCaptor.capture());
        Assertions.assertThat((List)((List)this.hitPoliciesCaptor.getValue())).containsOnly((Object[])HitPolicy.values());
        Assertions.assertThat((List)((List)this.builtInAggregatorsCaptor.getValue())).containsOnlyElementsOf((Iterable)this.builtinAggregatorUtils.getAllValues());
    }

    @Test
    public void testGetElement() {
        this.editor.getElement();
        ((HitPolicyPopoverView)Mockito.verify((Object)this.view)).getElement();
    }

    @Test
    public void testBindNullControl() {
        Mockito.reset((Object[])new HitPolicyPopoverView[]{this.view});
        this.editor.bind(null, 0, 1);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.view});
    }

    @Test
    public void testBindNonNullControl() {
        Mockito.reset((Object[])new HitPolicyPopoverView[]{this.view});
        this.editor.bind((Object)this.control, 0, 1);
        ((HitPolicyPopoverView)Mockito.verify((Object)this.view)).enableHitPolicies(ArgumentMatchers.eq((boolean)false));
        ((HitPolicyPopoverView)Mockito.verify((Object)this.view)).enableBuiltinAggregators(ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testBindNonNullControlHitPolicy() {
        HitPolicy hitPolicy = HitPolicy.ANY;
        Mockito.reset((Object[])new HitPolicyPopoverView[]{this.view});
        Mockito.when((Object)this.control.getHitPolicy()).thenReturn((Object)hitPolicy);
        this.editor.bind((Object)this.control, 0, 1);
        ((HitPolicyPopoverView)Mockito.verify((Object)this.view)).enableHitPolicies(ArgumentMatchers.eq((boolean)true));
        ((HitPolicyPopoverView)Mockito.verify((Object)this.view)).initSelectedHitPolicy((HitPolicy)ArgumentMatchers.eq((Object)hitPolicy));
        ((HitPolicyPopoverView)Mockito.verify((Object)this.view)).enableBuiltinAggregators(ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testBindNonNullControlHitPolicyWithAggregation() {
        this.assertHitPolicyAggregationConfiguration(HitPolicy.COLLECT, BuiltinAggregator.COUNT);
    }

    @Test
    public void testBindNonNullControlHitPolicyWithoutAggregation() {
        this.assertHitPolicyAggregationConfiguration(HitPolicy.COLLECT, null);
    }

    @Test
    public void testBindNonNullControlHitPolicyNotRequiringAggregation() {
        this.assertHitPolicyAggregationConfiguration(HitPolicy.ANY, null);
    }

    private void assertHitPolicyAggregationConfiguration(HitPolicy hitPolicy, BuiltinAggregator builtinAggregator) {
        Mockito.reset((Object[])new HitPolicyPopoverView[]{this.view});
        Mockito.when((Object)this.control.getHitPolicy()).thenReturn((Object)hitPolicy);
        Mockito.when((Object)this.control.getBuiltinAggregator()).thenReturn((Object)builtinAggregator);
        this.editor.bind((Object)this.control, 0, 1);
        ((HitPolicyPopoverView)Mockito.verify((Object)this.view)).enableHitPolicies(ArgumentMatchers.eq((boolean)true));
        ((HitPolicyPopoverView)Mockito.verify((Object)this.view)).initSelectedHitPolicy((HitPolicy)ArgumentMatchers.eq((Object)hitPolicy));
        ((HitPolicyPopoverView)Mockito.verify((Object)this.view)).enableBuiltinAggregators(ArgumentMatchers.eq((boolean)HitPolicy.COLLECT.equals((Object)hitPolicy)));
        ((HitPolicyPopoverView)Mockito.verify((Object)this.view)).initSelectedBuiltinAggregator((BuiltinAggregator)ArgumentMatchers.eq((Object)builtinAggregator));
    }

    @Test
    public void testSetHitPolicyNullControl() {
        this.editor.setHitPolicy(HitPolicy.ANY);
        ((HasHitPolicyControl)Mockito.verify((Object)this.control, (VerificationMode)Mockito.never())).setHitPolicy((HitPolicy)ArgumentMatchers.any(HitPolicy.class), (Command)ArgumentMatchers.any(Command.class));
    }

    @Test
    public void testSetHitPolicyNonNullControl() {
        HitPolicy hitPolicy = HitPolicy.ANY;
        Mockito.when((Object)this.control.getHitPolicy()).thenReturn((Object)hitPolicy);
        this.editor.bind((Object)this.control, 0, 1);
        Mockito.reset((Object[])new HitPolicyPopoverView[]{this.view});
        this.editor.setHitPolicy(hitPolicy);
        ((HasHitPolicyControl)Mockito.verify((Object)this.control)).setHitPolicy((HitPolicy)ArgumentMatchers.eq((Object)hitPolicy), (Command)this.commandCaptor.capture());
        ((Command)this.commandCaptor.getValue()).execute();
        ((HitPolicyPopoverView)Mockito.verify((Object)this.view)).enableHitPolicies(ArgumentMatchers.eq((boolean)true));
    }

    @Test
    public void testSetBuiltInAggregatorNullControl() {
        this.editor.setBuiltinAggregator(BuiltinAggregator.COUNT);
        ((HasHitPolicyControl)Mockito.verify((Object)this.control, (VerificationMode)Mockito.never())).setBuiltinAggregator((BuiltinAggregator)ArgumentMatchers.any(BuiltinAggregator.class));
    }

    @Test
    public void testSetBuiltInAggregatorNonNullControl() {
        BuiltinAggregator aggregator = BuiltinAggregator.COUNT;
        Mockito.when((Object)this.control.getBuiltinAggregator()).thenReturn((Object)aggregator);
        this.editor.bind((Object)this.control, 0, 1);
        Mockito.reset((Object[])new HitPolicyPopoverView[]{this.view});
        this.editor.setBuiltinAggregator(aggregator);
        ((HasHitPolicyControl)Mockito.verify((Object)this.control)).setBuiltinAggregator((BuiltinAggregator)ArgumentMatchers.eq((Object)aggregator));
    }

    @Test
    public void testShowNullControl() {
        this.editor.show();
        ((HitPolicyPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).show((Optional)ArgumentMatchers.any(Optional.class));
    }

    @Test
    public void testShowNonNullControl() {
        this.editor.bind((Object)this.control, 0, 1);
        Mockito.reset((Object[])new HitPolicyPopoverView[]{this.view});
        this.editor.show();
        ((HitPolicyPopoverView)Mockito.verify((Object)this.view)).show((Optional)ArgumentMatchers.eq(Optional.empty()));
    }

    @Test
    public void testHideNullControl() {
        this.editor.hide();
        ((HitPolicyPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide();
    }

    @Test
    public void testHideNonNullControl() {
        this.editor.bind((Object)this.control, 0, 1);
        Mockito.reset((Object[])new HitPolicyPopoverView[]{this.view});
        this.editor.hide();
        ((HitPolicyPopoverView)Mockito.verify((Object)this.view)).hide();
    }
}

