/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Element;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.HitPolicy;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy.BuiltinAggregatorUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy.HitPolicyPopoverViewImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.JQueryProducer;
import org.uberfire.client.views.pfly.widgets.Popover;
import org.uberfire.client.views.pfly.widgets.Select;

@RunWith(value=GwtMockitoTestRunner.class)
public class HitPolicyPopoverViewImplTest {
    @Mock
    private Select lstHitPolicies;
    @Mock
    private HTMLElement lstHitPoliciesElement;
    @Mock
    private Select lstBuiltinAggregator;
    @Mock
    private HTMLElement lstBuiltinAggregatorElement;
    @Mock
    private HTMLElement element;
    @Mock
    private Div popoverElement;
    @Mock
    private Div popoverContentElement;
    @Mock
    private Span hitPolicyLabel;
    @Mock
    private Span builtinAggregatorLabel;
    @Mock
    private JQueryProducer.JQuery<Popover> jQueryProducer;
    @Mock
    private Popover popover;
    @Mock
    private TranslationService translationService;
    private HitPolicyPopoverViewImpl view;
    private BuiltinAggregatorUtils builtinAggregatorUtils;

    @Before
    public void setUp() throws Exception {
        ((Select)Mockito.doReturn((Object)this.lstHitPoliciesElement).when((Object)this.lstHitPolicies)).getElement();
        ((Select)Mockito.doReturn((Object)this.lstBuiltinAggregatorElement).when((Object)this.lstBuiltinAggregator)).getElement();
        this.builtinAggregatorUtils = new BuiltinAggregatorUtils(this.translationService);
        this.view = (HitPolicyPopoverViewImpl)Mockito.spy((Object)new HitPolicyPopoverViewImpl(this.lstHitPolicies, this.lstBuiltinAggregator, this.builtinAggregatorUtils, this.popoverElement, this.popoverContentElement, this.hitPolicyLabel, this.builtinAggregatorLabel, this.jQueryProducer, this.translationService));
        ((HitPolicyPopoverViewImpl)Mockito.doReturn((Object)this.element).when((Object)this.view)).getElement();
        Mockito.when((Object)this.jQueryProducer.wrap((Element)this.element)).thenReturn((Object)this.popover);
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0].toString()).when((Object)this.translationService)).getTranslation((String)Mockito.any());
    }

    @Test
    public void testInitHitPolicies() throws Exception {
        this.view.initHitPolicies(Arrays.asList(HitPolicy.values()));
        Stream.of(HitPolicy.values()).forEach(policy -> ((Select)Mockito.verify((Object)this.lstHitPolicies)).addOption(policy.value()));
    }

    @Test
    public void testInitAggregator() throws Exception {
        List aggregators = this.builtinAggregatorUtils.getAllValues();
        this.view.initBuiltinAggregators(aggregators);
        aggregators.stream().forEach(agg -> ((Select)Mockito.verify((Object)this.lstBuiltinAggregator)).addOption(this.builtinAggregatorUtils.toString(agg)));
    }

    @Test
    public void testEnableHitPolicies() throws Exception {
        this.view.enableHitPolicies(true);
        ((Select)Mockito.verify((Object)this.lstHitPolicies)).enable();
    }

    @Test
    public void testDisableHitPolicies() throws Exception {
        this.view.enableHitPolicies(false);
        ((Select)Mockito.verify((Object)this.lstHitPolicies)).disable();
    }

    @Test
    public void testEnableAggregator() throws Exception {
        this.view.enableBuiltinAggregators(true);
        ((Select)Mockito.verify((Object)this.lstBuiltinAggregator)).enable();
    }

    @Test
    public void testDisableAggregator() throws Exception {
        this.view.enableBuiltinAggregators(false);
        ((Select)Mockito.verify((Object)this.lstBuiltinAggregator)).disable();
    }

    @Test
    public void testShow() {
        this.view.show(Optional.empty());
        ((Popover)Mockito.verify((Object)this.popover)).show();
    }

    @Test
    public void testHideBeforeShown() {
        this.view.hide();
        ((Popover)Mockito.verify((Object)this.popover, (VerificationMode)Mockito.never())).hide();
        ((Popover)Mockito.verify((Object)this.popover, (VerificationMode)Mockito.never())).destroy();
    }

    @Test
    public void testHideAfterShown() {
        this.view.show(Optional.empty());
        this.view.hide();
        ((Popover)Mockito.verify((Object)this.popover)).hide();
        ((Popover)Mockito.verify((Object)this.popover)).destroy();
    }
}

