/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.HasParametersControl;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.ParametersPopoverImpl;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.ParametersPopoverView;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class ParametersPopoverImplTest {
    private static final int ROW_INDEX = 0;
    private static final int COLUMN_INDEX = 1;
    private static final String PARAMETER_NAME = "name";
    private static final String PARAMETER_NAME_NEW = "new-name";
    private static final QName PARAMETER_TYPE_REF = new QName("", BuiltInType.DATE.getName());
    @Mock
    private ParametersPopoverView view;
    @Mock
    private TranslationService translationService;
    @Mock
    private InformationItem parameter;
    @Captor
    private ArgumentCaptor<Command> commandCaptor;
    @Captor
    private ArgumentCaptor<String> parameterNameCaptor;
    @Captor
    private ArgumentCaptor<QName> parameterTYpeRefCaptor;
    private ParametersPopoverView.Presenter presenter;
    private final List<InformationItem> parameters = new ArrayList<InformationItem>();
    private HasParametersControl control = (HasParametersControl)Mockito.spy((Object)new MockHasParametersControl());

    @Before
    public void setup() {
        this.presenter = new ParametersPopoverImpl(this.view, this.translationService);
        Mockito.when((Object)this.translationService.getTranslation((String)Mockito.any())).thenAnswer(i -> i.getArguments()[0]);
    }

    @Test
    public void testGetElement() {
        this.presenter.getElement();
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).getElement();
    }

    @Test
    public void testBindNullControl() {
        this.presenter.bind(null, 0, 1);
        ((ParametersPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setParameters((List)Mockito.any());
    }

    @Test
    public void testBindNonNullControl() {
        this.presenter.bind((Object)this.control, 0, 1);
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).setParameters((List)ArgumentMatchers.eq(this.parameters));
    }

    @Test
    public void testShowNullControl() {
        this.presenter.show();
        ((ParametersPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).show((Optional)Mockito.any());
        ((ParametersPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).focusParameter(Mockito.anyInt());
    }

    @Test
    public void testShowNonNullControl() {
        this.presenter.bind((Object)this.control, 0, 1);
        this.presenter.show();
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).show((Optional)ArgumentMatchers.eq(Optional.ofNullable(this.presenter.getPopoverTitle())));
        ((ParametersPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).focusParameter(Mockito.anyInt());
    }

    @Test
    public void testShowNonNullControlWithParameters() {
        this.parameters.add(new InformationItem());
        this.presenter.bind((Object)this.control, 0, 1);
        this.presenter.show();
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).show((Optional)ArgumentMatchers.eq(Optional.ofNullable(this.presenter.getPopoverTitle())));
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).focusParameter(0);
    }

    @Test
    public void testHideNullControl() {
        this.presenter.hide();
        ((ParametersPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide();
    }

    @Test
    public void testHideNonNullControl() {
        this.presenter.bind((Object)this.control, 0, 1);
        this.presenter.hide();
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testAddParameterNullControl() {
        this.presenter.addParameter();
        ((HasParametersControl)Mockito.verify((Object)this.control, (VerificationMode)Mockito.never())).addParameter((Command)Mockito.any());
        ((ParametersPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).focusParameter(Mockito.anyInt());
    }

    @Test
    public void testAddParameterNonNullControl() {
        this.presenter.bind((Object)this.control, 0, 1);
        Mockito.reset((Object[])new ParametersPopoverView[]{this.view});
        this.presenter.addParameter();
        ((HasParametersControl)Mockito.verify((Object)this.control)).addParameter((Command)this.commandCaptor.capture());
        ((Command)this.commandCaptor.getValue()).execute();
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).setParameters((List)ArgumentMatchers.eq(this.parameters));
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).focusParameter(0);
    }

    @Test
    public void testRemoveParameterNullControl() {
        this.presenter.removeParameter(this.parameter);
        ((HasParametersControl)Mockito.verify((Object)this.control, (VerificationMode)Mockito.never())).removeParameter((InformationItem)Mockito.any(), (Command)Mockito.any());
        ((ParametersPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).focusParameter(Mockito.anyInt());
    }

    @Test
    public void testRemoveLastParameterNonNullControl() {
        this.parameters.add(this.parameter);
        this.presenter.bind((Object)this.control, 0, 1);
        Mockito.reset((Object[])new ParametersPopoverView[]{this.view});
        this.presenter.removeParameter(this.parameter);
        ((HasParametersControl)Mockito.verify((Object)this.control)).removeParameter((InformationItem)ArgumentMatchers.eq((Object)this.parameter), (Command)this.commandCaptor.capture());
        ((Command)this.commandCaptor.getValue()).execute();
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).setParameters((List)ArgumentMatchers.eq(this.parameters));
        ((ParametersPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).focusParameter(Mockito.anyInt());
    }

    @Test
    public void testRemoveParameterNonNullControl() {
        this.parameters.add(new InformationItem());
        this.parameters.add(this.parameter);
        this.presenter.bind((Object)this.control, 0, 1);
        Mockito.reset((Object[])new ParametersPopoverView[]{this.view});
        this.presenter.removeParameter(this.parameter);
        ((HasParametersControl)Mockito.verify((Object)this.control)).removeParameter((InformationItem)ArgumentMatchers.eq((Object)this.parameter), (Command)this.commandCaptor.capture());
        ((Command)this.commandCaptor.getValue()).execute();
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).setParameters((List)ArgumentMatchers.eq(this.parameters));
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).focusParameter(0);
    }

    @Test
    public void testUpdateParameterNameNullControl() {
        this.presenter.updateParameterName(this.parameter, PARAMETER_NAME);
        ((HasParametersControl)Mockito.verify((Object)this.control, (VerificationMode)Mockito.never())).updateParameterName((InformationItem)Mockito.any(), (String)Mockito.any(), (Command)Mockito.any());
    }

    @Test
    public void testUpdateParameterNameNonNullControlWithChange() {
        Name name = new Name(PARAMETER_NAME);
        Mockito.when((Object)this.parameter.getName()).thenReturn((Object)name);
        this.parameters.add(this.parameter);
        this.assertUpdateParameterName(PARAMETER_NAME_NEW);
    }

    @Test
    public void testUpdateParameterNameNonNullControlWithChangeWithWhiteSpace() {
        Name name = new Name(PARAMETER_NAME);
        Mockito.when((Object)this.parameter.getName()).thenReturn((Object)name);
        this.parameters.add(this.parameter);
        this.assertUpdateParameterName("   new-name  ");
    }

    private void assertUpdateParameterName(String newName) {
        this.presenter.bind((Object)this.control, 0, 1);
        this.presenter.updateParameterName(this.parameter, newName);
        ((HasParametersControl)Mockito.verify((Object)this.control)).updateParameterName((InformationItem)ArgumentMatchers.eq((Object)this.parameter), (String)this.parameterNameCaptor.capture(), (Command)this.commandCaptor.capture());
        Assertions.assertThat((String)((String)this.parameterNameCaptor.getValue())).isEqualTo(PARAMETER_NAME_NEW);
        ((Command)this.commandCaptor.getValue()).execute();
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).updateParameterName(ArgumentMatchers.eq((int)0), (String)ArgumentMatchers.eq((Object)PARAMETER_NAME_NEW));
    }

    @Test
    public void testUpdateParameterNameNonNullControlWithNoChange() {
        Name name = new Name(PARAMETER_NAME);
        Mockito.when((Object)this.parameter.getName()).thenReturn((Object)name);
        this.presenter.bind((Object)this.control, 0, 1);
        this.presenter.updateParameterName(this.parameter, PARAMETER_NAME);
        ((HasParametersControl)Mockito.verify((Object)this.control, (VerificationMode)Mockito.never())).updateParameterName((InformationItem)Mockito.any(), (String)Mockito.any(), (Command)Mockito.any());
    }

    @Test
    public void testUpdateParameterNameNonNullControlWithNoChangeWithWhiteSpace() {
        Name name = new Name(PARAMETER_NAME);
        Mockito.when((Object)this.parameter.getName()).thenReturn((Object)name);
        this.parameters.add(this.parameter);
        this.presenter.bind((Object)this.control, 0, 1);
        this.presenter.updateParameterName(this.parameter, "   name   ");
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).updateParameterName(ArgumentMatchers.eq((int)0), (String)ArgumentMatchers.eq((Object)PARAMETER_NAME));
    }

    @Test
    public void testUpdateParameterTypeRefNullControl() {
        this.presenter.updateParameterTypeRef(this.parameter, PARAMETER_TYPE_REF);
        ((HasParametersControl)Mockito.verify((Object)this.control, (VerificationMode)Mockito.never())).updateParameterTypeRef((InformationItem)Mockito.any(), (QName)Mockito.any());
    }

    @Test
    public void testUpdateParameterTypeRefNonNullControl() {
        this.presenter.bind((Object)this.control, 0, 1);
        this.presenter.updateParameterTypeRef(this.parameter, PARAMETER_TYPE_REF);
        ((HasParametersControl)Mockito.verify((Object)this.control)).updateParameterTypeRef((InformationItem)ArgumentMatchers.eq((Object)this.parameter), (QName)this.parameterTYpeRefCaptor.capture());
        Assertions.assertThat((Object)this.parameterTYpeRefCaptor.getValue()).isEqualTo((Object)PARAMETER_TYPE_REF);
    }

    protected class MockHasParametersControl
    implements HasParametersControl {
        protected MockHasParametersControl() {
        }

        public List<InformationItem> getParameters() {
            return ParametersPopoverImplTest.this.parameters;
        }

        public void addParameter(Command onSuccess) {
            ParametersPopoverImplTest.this.parameters.add(new InformationItem());
        }

        public void removeParameter(InformationItem parameter, Command onSuccess) {
            ParametersPopoverImplTest.this.parameters.remove(parameter);
        }

        public void updateParameterName(InformationItem parameter, String name, Command onSuccess) {
        }

        public void updateParameterTypeRef(InformationItem parameter, QName typeRef) {
        }
    }
}

