/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.pmml;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocumentModel;
import org.kie.workbench.common.dmn.client.commands.expressions.types.function.SetParametersCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetCellValueCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.BaseEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.GridFactoryCommandUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.pmml.BaseLiteralExpressionPMMLGridTest;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.pmml.LiteralExpressionPMMLGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.pmml.PMMLDocumentMetadataProvider;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.pmml.model.LiteralExpressionPMMLDocumentModelEditorDefinition;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.stunner.core.client.ReadOnlyProvider;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

@RunWith(value=LienzoMockitoTestRunner.class)
public class LiteralExpressionPMMLDocumentModelGridTest
extends BaseLiteralExpressionPMMLGridTest {
    private static final String DOCUMENT_NAME = "document";
    @Mock
    private FunctionGrid grandParentFunctionGridWidget;
    @Mock
    private FunctionDefinition grandParentExpression;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private GraphCommandExecutionContext graphCommandExecutionContext;
    @Mock
    private ReadOnlyProvider readOnlyProvider;

    @Override
    @Before
    public void setup() {
        GridCellTuple grandParentInformation = new GridCellTuple(0, 0, (GridWidget)this.grandParentFunctionGridWidget);
        Mockito.when((Object)this.parentGridWidget.getExpressionValueEditor(DOCUMENT_NAME)).thenReturn(Optional.of(this.pmmlValueEditor));
        Mockito.when((Object)this.parentGridWidget.getExpressionValue(DOCUMENT_NAME)).thenReturn((Object)DOCUMENT_NAME);
        Mockito.when((Object)this.parentGridWidget.getParentInformation()).thenReturn((Object)grandParentInformation);
        Mockito.when((Object)this.grandParentFunctionGridWidget.getExpression()).thenReturn(() -> Optional.of(this.grandParentExpression));
        Mockito.when((Object)this.grandParentExpression.getFormalParameter()).thenCallRealMethod();
        Mockito.when((Object)this.canvasHandler.getGraphExecutionContext()).thenReturn((Object)this.graphCommandExecutionContext);
        super.setup();
    }

    @Override
    protected BaseEditorDefinition<LiteralExpressionPMMLDocumentModel, DMNGridData> getDefinition() {
        return new LiteralExpressionPMMLDocumentModelEditorDefinition(this.definitionUtils, this.sessionManager, this.sessionCommandManager, this.canvasCommandFactory, (Event)this.editorSelectedEvent, (Event)this.refreshFormPropertiesEvent, (Event)this.domainObjectSelectionEvent, this.listSelector, this.translationService, this.headerEditor, this.pmmlDocumentMetadataProvider, this.readOnlyProvider);
    }

    @Override
    protected GridWidget getParentGridWidget() {
        return this.parentGridWidget;
    }

    @Test
    public void testGetPlaceHolder() {
        this.setupGrid(0);
        Assertions.assertThat((String)((LiteralExpressionPMMLGrid)this.grid).getPlaceHolder()).isEqualTo("LiteralExpressionPMMLDocumentModelEditorDefinition.Placeholder");
    }

    @Test
    public void testLoadValues() {
        this.setupGrid(0);
        List modelNames = (List)Mockito.mock(List.class);
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)this.pmmlDocumentMetadataProvider.getPMMLDocumentModels(DOCUMENT_NAME)).thenReturn((Object)modelNames);
        ((LiteralExpressionPMMLGrid)this.grid).loadValues(consumer);
        ((PMMLDocumentMetadataProvider)Mockito.verify((Object)this.pmmlDocumentMetadataProvider)).getPMMLDocumentModels((String)ArgumentMatchers.eq((Object)DOCUMENT_NAME));
        ((Consumer)Mockito.verify((Object)consumer)).accept(modelNames);
    }

    @Test
    public void testNewCellHasValueCommand() {
        this.setupGrid(0);
        List<String> parameterNames = Arrays.asList("param1", "param2");
        String modelName = (String)this.tupleWithValue.getValue().getValue();
        Mockito.when((Object)this.pmmlDocumentMetadataProvider.getPMMLDocumentModelParameterNames((String)ArgumentMatchers.eq((Object)DOCUMENT_NAME), (String)ArgumentMatchers.eq((Object)modelName))).thenReturn(parameterNames);
        Command command = (Command)((LiteralExpressionPMMLGrid)this.grid).newCellHasValueCommand().apply(this.tupleWithValue);
        ((PMMLDocumentMetadataProvider)Mockito.verify((Object)this.pmmlDocumentMetadataProvider)).getPMMLDocumentModelParameterNames((String)ArgumentMatchers.eq((Object)DOCUMENT_NAME), (String)ArgumentMatchers.eq((Object)modelName));
        GridFactoryCommandUtils.assertCommands(command, SetCellValueCommand.class, SetParametersCommand.class);
        SetParametersCommand setParametersCommand = (SetParametersCommand)((CompositeCommand)command).getCommands().get(1);
        setParametersCommand.execute(this.canvasHandler);
        Assertions.assertThat(this.grandParentExpression.getFormalParameter().stream().map(ii -> ii.getName().getValue()).collect(Collectors.toList())).containsExactly((Object[])new String[]{"param1", "param2"});
    }
}

