/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.list;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Optional;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.model.List;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.list.ListEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.list.ListGrid;
import org.kie.workbench.common.dmn.client.editors.types.ValueAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.ReadOnlyProvider;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ListEditorDefinitionTest {
    @Mock
    private DMNGridPanel gridPanel;
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private DMNSession session;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private DefaultCanvasCommandFactory canvasCommandFactory;
    @Mock
    private CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private TranslationService translationService;
    @Mock
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    private ValueAndDataTypePopoverView.Presenter headerEditor;
    @Mock
    private GridCellTuple parent;
    @Mock
    private HasExpression hasExpression;
    @Mock
    private EventSourceMock<ExpressionEditorChanged> editorSelectedEvent;
    @Mock
    private EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    @Mock
    private EventSourceMock<DomainObjectSelectionEvent> domainObjectSelectionEvent;
    @Mock
    private ReadOnlyProvider readOnlyProvider;
    private Optional<HasName> hasName = Optional.empty();
    private ListEditorDefinition definition;

    @Before
    public void setup() {
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getGridPanel()).thenReturn((Object)this.gridPanel);
        Mockito.when((Object)this.session.getGridLayer()).thenReturn((Object)this.gridLayer);
        Mockito.when((Object)this.session.getCellEditorControls()).thenReturn((Object)this.cellEditorControls);
        this.definition = new ListEditorDefinition(this.definitionUtils, this.sessionManager, this.sessionCommandManager, this.canvasCommandFactory, this.editorSelectedEvent, this.refreshFormPropertiesEvent, this.domainObjectSelectionEvent, this.listSelector, this.translationService, this.expressionEditorDefinitionsSupplier, this.headerEditor, this.readOnlyProvider);
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)this.definition);
        Mockito.when((Object)this.expressionEditorDefinitionsSupplier.get()).thenReturn((Object)expressionEditorDefinitions);
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0].toString()).when((Object)this.translationService)).format((String)Mockito.any(), new Object[0]);
    }

    @Test
    public void testType() {
        Assertions.assertThat((Comparable)this.definition.getType()).isEqualTo((Object)ExpressionType.LIST);
    }

    @Test
    public void testName() {
        Assertions.assertThat((String)this.definition.getName()).isEqualTo("ExpressionEditor.ListType");
    }

    @Test
    public void testModelDefinition() {
        Optional oModel = this.definition.getModelClass();
        Assertions.assertThat((Optional)oModel).isPresent();
    }

    @Test
    public void testModelEnrichment() {
        Optional oModel = this.definition.getModelClass();
        this.definition.enrich(Optional.empty(), this.hasExpression, oModel);
        List model = (List)oModel.get();
        Assert.assertNotNull((Object)model.getExpression());
        Assert.assertNotNull((Object)((HasExpression)model.getExpression().get(0)).getExpression());
        Assert.assertTrue((boolean)(((HasExpression)model.getExpression().get(0)).getExpression() instanceof LiteralExpression));
        Assert.assertEquals((Object)model, (Object)((HasExpression)model.getExpression().get(0)).getExpression().getParent());
    }

    @Test
    public void testEditor() {
        Mockito.when((Object)this.hasExpression.getExpression()).thenReturn(this.definition.getModelClass().get());
        Optional oEditor = this.definition.getEditor(this.parent, Optional.empty(), this.hasExpression, this.hasName, false, 0);
        Assertions.assertThat((Optional)oEditor).isPresent();
        GridWidget editor = (GridWidget)oEditor.get();
        Assertions.assertThat((Object)editor).isInstanceOf(ListGrid.class);
    }

    @Test
    public void testIsUserSelectable() {
        Assertions.assertThat((boolean)this.definition.isUserSelectable()).isTrue();
    }
}

