/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.relation;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Optional;
import org.gwtbootstrap3.client.ui.TextArea;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.client.editors.expressions.mocks.MockHasDOMElementResourcesHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.BaseDOMElementSingletonColumnTest;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.TextAreaSingletonDOMElementFactory;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.dom.TextAreaDOMElement;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

@RunWith(value=LienzoMockitoTestRunner.class)
public class RelationColumnTest
extends BaseDOMElementSingletonColumnTest<TextAreaSingletonDOMElementFactory, TextAreaDOMElement, TextArea, RelationColumn, RelationGrid> {
    @Mock
    private TextAreaSingletonDOMElementFactory factory;
    @Mock
    private TextAreaDOMElement domElement;
    @Mock
    private TextArea widget;
    @Mock
    private GridWidget parentGridWidget;
    @Mock
    private BaseExpressionGrid peerExpressionEditor;
    private GridData parentUiModel;

    @Override
    protected TextAreaSingletonDOMElementFactory getFactory() {
        return this.factory;
    }

    @Override
    protected TextAreaDOMElement getDomElement() {
        return this.domElement;
    }

    @Override
    protected TextArea getWidget() {
        return this.widget;
    }

    @Override
    protected RelationGrid getGridWidget() {
        return (RelationGrid)Mockito.mock(RelationGrid.class);
    }

    @Override
    protected RelationColumn getColumn() {
        return new RelationColumn(this.headerMetaData, this.factory, 100.0, (RelationGrid)this.gridWidget);
    }

    @Before
    public void setUp() throws Exception {
        this.parentUiModel = new BaseGridData();
        this.parentUiModel.appendRow((GridRow)new BaseGridRow());
        this.parentUiModel.appendRow((GridRow)new BaseGridRow());
        this.parentUiModel.appendRow((GridRow)new BaseGridRow());
        this.parentUiModel.appendColumn((GridColumn)Mockito.mock(ExpressionEditorColumn.class));
        GridCellTuple parent = new GridCellTuple(0, 0, this.parentGridWidget);
        ((GridWidget)Mockito.doReturn((Object)this.parentUiModel).when((Object)this.parentGridWidget)).getModel();
        ((TextAreaDOMElement)Mockito.doReturn((Object)this.widget).when((Object)this.domElement)).getWidget();
        ((RelationGrid)Mockito.doReturn((Object)parent).when((Object)this.gridWidget)).getParentInformation();
        ((RelationGrid)Mockito.doReturn((Object)100.0).when((Object)this.gridWidget)).getWidth();
    }

    @Test
    public void testGetMinimumWidthWithNoPeers() {
        Assert.assertEquals((double)100.0, (double)((RelationColumn)this.column).getMinimumWidth(), (double)0.0);
    }

    @Test
    public void testGetMinimumWidthWithPeerNarrowerThanThisGrid() {
        double PEER_WIDTH = 50.0;
        double RELATION_GRID_WIDTH = 100.0;
        this.assertMinimumWidth(50.0, 100.0, 100.0, Optional.of(this.peerExpressionEditor));
    }

    @Test
    public void testGetMinimumWidthWithMultiplePeersNarrowerThanThisGrid() {
        double PEER_WIDTH = 50.0;
        double RELATION_GRID_WIDTH = 100.0;
        RelationColumn peerRelationColumn = this.getColumn();
        RelationGrid peerRelationEditor = (RelationGrid)Mockito.mock(RelationGrid.class);
        Mockito.when((Object)peerRelationEditor.getMinimumWidth()).thenAnswer(i -> peerRelationColumn.getMinimumWidth());
        this.assertMinimumWidth(50.0, 100.0, 100.0, Optional.of(this.peerExpressionEditor), Optional.of(peerRelationEditor));
    }

    @Test
    public void testHeaderDOMElementsAreDestroyed() {
        MockHasDOMElementResourcesHeaderMetaData mockHeaderMetaData = (MockHasDOMElementResourcesHeaderMetaData)Mockito.mock(MockHasDOMElementResourcesHeaderMetaData.class);
        ((RelationColumn)this.column).getHeaderMetaData().add(mockHeaderMetaData);
        ((RelationColumn)this.column).destroyResources();
        ((MockHasDOMElementResourcesHeaderMetaData)Mockito.verify((Object)mockHeaderMetaData)).destroyResources();
    }

    @SafeVarargs
    private final void assertMinimumWidth(double peerWidth, double relationGridWidth, double expectedMinimumWidth, Optional<BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper>> ... peers) {
        ((BaseExpressionGrid)Mockito.doReturn((Object)peerWidth).when((Object)this.peerExpressionEditor)).getMinimumWidth();
        ((RelationGrid)Mockito.doReturn((Object)relationGridWidth).when((Object)this.gridWidget)).getWidth();
        for (int i = 0; i < peers.length; ++i) {
            this.parentUiModel.setCellValue(i + 1, 0, (GridCellValue)new ExpressionCellValue(peers[i]));
        }
        Assert.assertEquals((double)expectedMinimumWidth, (double)((RelationColumn)this.column).getMinimumWidth(), (double)0.0);
    }
}

