/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.definition.model.ImportDMN;
import org.kie.workbench.common.dmn.api.definition.model.ImportPMML;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.property.dmn.LocationURI;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.editors.included.BaseIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.DMNIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.PMMLIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsFactory;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsIndex;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.ImportRecordEngine;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;

@RunWith(value=MockitoJUnitRunner.class)
public class IncludedModelsFactoryTest {
    @Mock
    private ImportRecordEngine recordEngine;
    @Mock
    private IncludedModelsIndex includedModelsIndex;
    private IncludedModelsFactory factory;

    @Before
    public void setup() {
        this.factory = (IncludedModelsFactory)Mockito.spy((Object)new IncludedModelsFactory(this.recordEngine, this.includedModelsIndex));
    }

    @Test
    public void testMakeIncludedDMNModels() {
        ImportDMN import1 = (ImportDMN)Mockito.mock(ImportDMN.class);
        ImportDMN import2 = (ImportDMN)Mockito.mock(ImportDMN.class);
        Name nameMock1 = (Name)Mockito.mock(Name.class);
        Name nameMock2 = (Name)Mockito.mock(Name.class);
        List<Import> imports = Arrays.asList(import1, import2);
        String name1 = "name1";
        String name2 = "name2";
        String path1 = "path1";
        String path2 = "path2";
        String uuid1 = "123";
        String uuid2 = "456";
        final String[] uuids = new String[]{"123", "456"};
        String uri1 = "/src/main/kie/dmn/1";
        String uri2 = "/src/main/kie/dmn/2";
        Integer drgElementsCount1 = 2;
        Integer drgElementsCount2 = 8;
        Integer itemDefinitionsCount1 = 4;
        Integer itemDefinitionsCount2 = 16;
        Mockito.when((Object)nameMock1.getValue()).thenReturn((Object)"name1");
        Mockito.when((Object)nameMock2.getValue()).thenReturn((Object)"name2");
        Mockito.when((Object)import1.getName()).thenReturn((Object)nameMock1);
        Mockito.when((Object)import2.getName()).thenReturn((Object)nameMock2);
        Mockito.when((Object)import1.getNamespace()).thenReturn((Object)"path1");
        Mockito.when((Object)import2.getNamespace()).thenReturn((Object)"path2");
        Mockito.when((Object)import1.getImportType()).thenReturn((Object)DMNImportTypes.DMN.getDefaultNamespace());
        Mockito.when((Object)import2.getImportType()).thenReturn((Object)DMNImportTypes.DMN.getDefaultNamespace());
        Mockito.when((Object)import1.getLocationURI()).thenReturn((Object)new LocationURI("/src/main/kie/dmn/1"));
        Mockito.when((Object)import2.getLocationURI()).thenReturn((Object)new LocationURI("/src/main/kie/dmn/2"));
        Mockito.when((Object)import1.getDrgElementsCount()).thenReturn((Object)drgElementsCount1);
        Mockito.when((Object)import2.getDrgElementsCount()).thenReturn((Object)drgElementsCount2);
        Mockito.when((Object)import1.getItemDefinitionsCount()).thenReturn((Object)itemDefinitionsCount1);
        Mockito.when((Object)import2.getItemDefinitionsCount()).thenReturn((Object)itemDefinitionsCount2);
        ((IncludedModelsFactory)Mockito.doAnswer((Answer)new Answer(){
            private int count = 0;

            public Object answer(InvocationOnMock invocation) {
                return uuids[this.count++];
            }
        }).when((Object)this.factory)).uuidWrapper();
        List includedModels = this.factory.makeIncludedModels(imports);
        BaseIncludedModelActiveRecord includedModel1 = (BaseIncludedModelActiveRecord)includedModels.get(0);
        BaseIncludedModelActiveRecord includedModel2 = (BaseIncludedModelActiveRecord)includedModels.get(1);
        ((IncludedModelsIndex)Mockito.verify((Object)this.includedModelsIndex)).clear();
        ((IncludedModelsIndex)Mockito.verify((Object)this.includedModelsIndex)).index(includedModel1, (Import)import1);
        ((IncludedModelsIndex)Mockito.verify((Object)this.includedModelsIndex)).index(includedModel2, (Import)import2);
        Assert.assertEquals((long)2L, (long)includedModels.size());
        Assert.assertEquals((Object)"123", (Object)includedModel1.getUUID());
        Assert.assertEquals((Object)"456", (Object)includedModel2.getUUID());
        Assert.assertEquals((Object)"name1", (Object)includedModel1.getName());
        Assert.assertEquals((Object)"name2", (Object)includedModel2.getName());
        Assert.assertEquals((Object)"path1", (Object)includedModel1.getNamespace());
        Assert.assertEquals((Object)"path2", (Object)includedModel2.getNamespace());
        Assert.assertEquals((Object)"/src/main/kie/dmn/1", (Object)includedModel1.getPath());
        Assert.assertEquals((Object)"/src/main/kie/dmn/2", (Object)includedModel2.getPath());
        Assert.assertTrue((boolean)(includedModel1 instanceof DMNIncludedModelActiveRecord));
        Assert.assertTrue((boolean)(includedModel2 instanceof DMNIncludedModelActiveRecord));
        Assert.assertEquals((Object)itemDefinitionsCount1, (Object)((DMNIncludedModelActiveRecord)includedModel1).getDataTypesCount());
        Assert.assertEquals((Object)itemDefinitionsCount2, (Object)((DMNIncludedModelActiveRecord)includedModel2).getDataTypesCount());
        Assert.assertEquals((Object)drgElementsCount1, (Object)((DMNIncludedModelActiveRecord)includedModel1).getDrgElementsCount());
        Assert.assertEquals((Object)drgElementsCount2, (Object)((DMNIncludedModelActiveRecord)includedModel2).getDrgElementsCount());
        Assert.assertEquals((Object)this.recordEngine, (Object)includedModel1.getRecordEngine());
        Assert.assertEquals((Object)this.recordEngine, (Object)includedModel2.getRecordEngine());
    }

    @Test
    public void testMakeIncludedPMMLModels() {
        ImportPMML import1 = (ImportPMML)Mockito.mock(ImportPMML.class);
        ImportPMML import2 = (ImportPMML)Mockito.mock(ImportPMML.class);
        Name nameMock1 = (Name)Mockito.mock(Name.class);
        Name nameMock2 = (Name)Mockito.mock(Name.class);
        List<Import> imports = Arrays.asList(import1, import2);
        String name1 = "name1";
        String name2 = "name2";
        String path1 = "path1";
        String path2 = "path2";
        String uuid1 = "123";
        String uuid2 = "456";
        final String[] uuids = new String[]{"123", "456"};
        String uri1 = "/src/main/kie/dmn/1";
        String uri2 = "/src/main/kie/dmn/2";
        Integer modelCount1 = 2;
        Integer modelCount2 = 8;
        Mockito.when((Object)nameMock1.getValue()).thenReturn((Object)"name1");
        Mockito.when((Object)nameMock2.getValue()).thenReturn((Object)"name2");
        Mockito.when((Object)import1.getName()).thenReturn((Object)nameMock1);
        Mockito.when((Object)import2.getName()).thenReturn((Object)nameMock2);
        Mockito.when((Object)import1.getNamespace()).thenReturn((Object)"path1");
        Mockito.when((Object)import2.getNamespace()).thenReturn((Object)"path2");
        Mockito.when((Object)import1.getImportType()).thenReturn((Object)DMNImportTypes.PMML.getDefaultNamespace());
        Mockito.when((Object)import2.getImportType()).thenReturn((Object)DMNImportTypes.PMML.getDefaultNamespace());
        Mockito.when((Object)import1.getLocationURI()).thenReturn((Object)new LocationURI("/src/main/kie/dmn/1"));
        Mockito.when((Object)import2.getLocationURI()).thenReturn((Object)new LocationURI("/src/main/kie/dmn/2"));
        Mockito.when((Object)import1.getModelCount()).thenReturn((Object)modelCount1);
        Mockito.when((Object)import2.getModelCount()).thenReturn((Object)modelCount2);
        ((IncludedModelsFactory)Mockito.doAnswer((Answer)new Answer(){
            private int count = 0;

            public Object answer(InvocationOnMock invocation) {
                return uuids[this.count++];
            }
        }).when((Object)this.factory)).uuidWrapper();
        List includedModels = this.factory.makeIncludedModels(imports);
        BaseIncludedModelActiveRecord includedModel1 = (BaseIncludedModelActiveRecord)includedModels.get(0);
        BaseIncludedModelActiveRecord includedModel2 = (BaseIncludedModelActiveRecord)includedModels.get(1);
        ((IncludedModelsIndex)Mockito.verify((Object)this.includedModelsIndex)).clear();
        ((IncludedModelsIndex)Mockito.verify((Object)this.includedModelsIndex)).index(includedModel1, (Import)import1);
        ((IncludedModelsIndex)Mockito.verify((Object)this.includedModelsIndex)).index(includedModel2, (Import)import2);
        Assert.assertEquals((long)2L, (long)includedModels.size());
        Assert.assertEquals((Object)"123", (Object)includedModel1.getUUID());
        Assert.assertEquals((Object)"456", (Object)includedModel2.getUUID());
        Assert.assertEquals((Object)"name1", (Object)includedModel1.getName());
        Assert.assertEquals((Object)"name2", (Object)includedModel2.getName());
        Assert.assertEquals((Object)"path1", (Object)includedModel1.getNamespace());
        Assert.assertEquals((Object)"path2", (Object)includedModel2.getNamespace());
        Assert.assertEquals((Object)"/src/main/kie/dmn/1", (Object)includedModel1.getPath());
        Assert.assertEquals((Object)"/src/main/kie/dmn/2", (Object)includedModel2.getPath());
        Assert.assertTrue((boolean)(includedModel1 instanceof PMMLIncludedModelActiveRecord));
        Assert.assertTrue((boolean)(includedModel2 instanceof PMMLIncludedModelActiveRecord));
        Assert.assertEquals((Object)modelCount1, (Object)((PMMLIncludedModelActiveRecord)includedModel1).getModelCount());
        Assert.assertEquals((Object)modelCount2, (Object)((PMMLIncludedModelActiveRecord)includedModel2).getModelCount());
        Assert.assertEquals((Object)this.recordEngine, (Object)includedModel1.getRecordEngine());
        Assert.assertEquals((Object)this.recordEngine, (Object)includedModel2.getRecordEngine());
    }
}

