/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.modal;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLElement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.enterprise.event.Event;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.commons.util.Maps;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.client.api.included.legacy.DMNIncludeModelsClient;
import org.kie.workbench.common.dmn.client.docks.navigator.events.RefreshDecisionComponents;
import org.kie.workbench.common.dmn.client.editors.included.BaseIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.DMNIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPagePresenter;
import org.kie.workbench.common.dmn.client.editors.included.PMMLIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.ImportRecordEngine;
import org.kie.workbench.common.dmn.client.editors.included.modal.IncludedModelModal;
import org.kie.workbench.common.dmn.client.editors.included.modal.dropdown.DMNAssetsDropdown;
import org.kie.workbench.common.dmn.client.editors.types.common.events.RefreshDataTypesListEvent;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItem;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class IncludedModelModalTest {
    @Mock
    private IncludedModelModal.View view;
    @Mock
    private DMNAssetsDropdown dropdown;
    @Mock
    private ImportRecordEngine recordEngine;
    @Mock
    private IncludedModelsPagePresenter grid;
    @Mock
    private DMNIncludeModelsClient client;
    @Mock
    private EventSourceMock<RefreshDecisionComponents> refreshDecisionComponentsEvent;
    @Mock
    private EventSourceMock<RefreshDataTypesListEvent> refreshDataTypesListEvent;
    @Captor
    private ArgumentCaptor<RefreshDataTypesListEvent> refreshDataTypesListArgumentCaptor;
    @Captor
    private ArgumentCaptor<BaseIncludedModelActiveRecord> includedModelActiveRecordArgumentCaptor;
    private IncludedModelModalFake modal;

    @Before
    public void setup() {
        this.modal = (IncludedModelModalFake)((Object)Mockito.spy((Object)((Object)new IncludedModelModalFake(this.view, this.dropdown, this.recordEngine))));
        this.modal.init(this.grid);
    }

    @Test
    public void testSetup() {
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        ((IncludedModelModalFake)((Object)Mockito.doReturn((Object)htmlElement).when((Object)this.modal))).getInitializedDropdownElement();
        ((IncludedModelModalFake)((Object)Mockito.doNothing().when((Object)this.modal))).superSetup();
        ((IncludedModelModalFake)((Object)Mockito.doNothing().when((Object)this.modal))).setWidth("600px");
        this.modal.setup();
        ((IncludedModelModalFake)((Object)Mockito.verify((Object)((Object)this.modal)))).superSetup();
        ((IncludedModelModalFake)((Object)Mockito.verify((Object)((Object)this.modal)))).setWidth("600px");
        ((IncludedModelModal.View)Mockito.verify((Object)this.view)).init((Object)this.modal);
        ((IncludedModelModal.View)Mockito.verify((Object)this.view)).setupAssetsDropdown(htmlElement);
    }

    @Test
    public void testShow() {
        ((IncludedModelModalFake)((Object)Mockito.doNothing().when((Object)this.modal))).superShow();
        this.modal.show();
        ((DMNAssetsDropdown)Mockito.verify((Object)this.dropdown)).loadAssets();
        ((IncludedModelModal.View)Mockito.verify((Object)this.view)).initialize();
        ((IncludedModelModal.View)Mockito.verify((Object)this.view)).disableIncludeButton();
        ((IncludedModelModalFake)((Object)Mockito.verify((Object)((Object)this.modal)))).superShow();
    }

    @Test
    public void testGetInitializedDropdownElement() {
        Command onValueChanged = (Command)Mockito.mock(Command.class);
        HTMLElement expectedElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        ((IncludedModelModalFake)((Object)Mockito.doReturn((Object)onValueChanged).when((Object)this.modal))).getOnValueChanged();
        Mockito.when((Object)this.dropdown.getElement()).thenReturn((Object)expectedElement);
        HTMLElement actualElement = this.modal.getInitializedDropdownElement();
        ((DMNAssetsDropdown)Mockito.verify((Object)this.dropdown)).initialize();
        ((DMNAssetsDropdown)Mockito.verify((Object)this.dropdown)).registerOnChangeHandler(onValueChanged);
        Assert.assertEquals((Object)expectedElement, (Object)actualElement);
    }

    @Test
    public void testIncludeDMN() {
        String path = "path";
        String name = "name";
        String namespace = "namespace";
        int drgElementCount = 2;
        int itemDefinitionCount = 3;
        KieAssetsDropdownItem dropdownItem = (KieAssetsDropdownItem)Mockito.mock(KieAssetsDropdownItem.class);
        Mockito.when((Object)this.view.getModelNameInput()).thenReturn((Object)"name");
        Mockito.when((Object)this.dropdown.getValue()).thenReturn(Optional.of(dropdownItem));
        Mockito.when((Object)dropdownItem.getValue()).thenReturn((Object)"namespace");
        Mockito.when((Object)dropdownItem.getMetaData()).thenReturn((Object)new Maps.Builder().put((Object)"path", (Object)"path").put((Object)"import_type", (Object)DMNImportTypes.DMN.getDefaultNamespace()).put((Object)"drg_element_count", (Object)Integer.toString(2)).put((Object)"item_definition_count", (Object)Integer.toString(3)).build());
        ((IncludedModelModalFake)((Object)Mockito.doNothing().when((Object)this.modal))).hide();
        this.modal.include();
        ((IncludedModelModalFake)((Object)Mockito.verify((Object)((Object)this.modal)))).createIncludedModel(dropdownItem);
        ((IncludedModelsPagePresenter)Mockito.verify((Object)this.grid)).refresh();
        ((IncludedModelModalFake)((Object)Mockito.verify((Object)((Object)this.modal)))).hide();
        ((EventSourceMock)Mockito.verify(this.refreshDecisionComponentsEvent)).fire(ArgumentMatchers.any(RefreshDecisionComponents.class));
        ((IncludedModelModalFake)((Object)Mockito.verify((Object)((Object)this.modal)))).refreshDataTypesList((BaseIncludedModelActiveRecord)this.includedModelActiveRecordArgumentCaptor.capture());
        BaseIncludedModelActiveRecord baseActiveRecord = (BaseIncludedModelActiveRecord)this.includedModelActiveRecordArgumentCaptor.getValue();
        Assert.assertTrue((boolean)(baseActiveRecord instanceof DMNIncludedModelActiveRecord));
        DMNIncludedModelActiveRecord dmnActiveRecord = (DMNIncludedModelActiveRecord)baseActiveRecord;
        Assert.assertEquals((Object)"path", (Object)dmnActiveRecord.getPath());
        Assert.assertEquals((Object)"name", (Object)dmnActiveRecord.getName());
        Assert.assertEquals((Object)"namespace", (Object)dmnActiveRecord.getNamespace());
        Assert.assertEquals((long)2L, (long)dmnActiveRecord.getDrgElementsCount().intValue());
        Assert.assertEquals((long)3L, (long)dmnActiveRecord.getDataTypesCount().intValue());
    }

    @Test
    public void testIncludePMML() {
        String path = "path";
        String name = "name";
        String namespace = "namespace";
        int modelCount = 2;
        KieAssetsDropdownItem dropdownItem = (KieAssetsDropdownItem)Mockito.mock(KieAssetsDropdownItem.class);
        Mockito.when((Object)this.view.getModelNameInput()).thenReturn((Object)"name");
        Mockito.when((Object)this.dropdown.getValue()).thenReturn(Optional.of(dropdownItem));
        Mockito.when((Object)dropdownItem.getValue()).thenReturn((Object)"namespace");
        Mockito.when((Object)dropdownItem.getMetaData()).thenReturn((Object)new Maps.Builder().put((Object)"path", (Object)"path").put((Object)"import_type", (Object)DMNImportTypes.PMML.getDefaultNamespace()).put((Object)"pmml_model_count", (Object)Integer.toString(2)).build());
        ((IncludedModelModalFake)((Object)Mockito.doNothing().when((Object)this.modal))).hide();
        this.modal.include();
        ((IncludedModelModalFake)((Object)Mockito.verify((Object)((Object)this.modal)))).createIncludedModel(dropdownItem);
        ((IncludedModelsPagePresenter)Mockito.verify((Object)this.grid)).refresh();
        ((IncludedModelModalFake)((Object)Mockito.verify((Object)((Object)this.modal)))).hide();
        ((EventSourceMock)Mockito.verify(this.refreshDecisionComponentsEvent)).fire(ArgumentMatchers.any(RefreshDecisionComponents.class));
        ((IncludedModelModalFake)((Object)Mockito.verify((Object)((Object)this.modal)))).refreshDataTypesList((BaseIncludedModelActiveRecord)this.includedModelActiveRecordArgumentCaptor.capture());
        BaseIncludedModelActiveRecord baseActiveRecord = (BaseIncludedModelActiveRecord)this.includedModelActiveRecordArgumentCaptor.getValue();
        Assert.assertTrue((boolean)(baseActiveRecord instanceof PMMLIncludedModelActiveRecord));
        PMMLIncludedModelActiveRecord pmmlActiveRecord = (PMMLIncludedModelActiveRecord)baseActiveRecord;
        Assert.assertEquals((Object)"path", (Object)pmmlActiveRecord.getPath());
        Assert.assertEquals((Object)"name", (Object)pmmlActiveRecord.getName());
        Assert.assertEquals((Object)"namespace", (Object)pmmlActiveRecord.getNamespace());
        Assert.assertEquals((long)2L, (long)pmmlActiveRecord.getModelCount().intValue());
    }

    @Test
    public void testRefreshDataTypesList() {
        BaseIncludedModelActiveRecord includedModel = (BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class);
        Consumer<List> listConsumer = list -> {};
        String modelName = "model1";
        String namespace = "://namespace1";
        Mockito.when((Object)includedModel.getName()).thenReturn((Object)"model1");
        Mockito.when((Object)includedModel.getNamespace()).thenReturn((Object)"://namespace1");
        ((IncludedModelModalFake)((Object)Mockito.doReturn(listConsumer).when((Object)this.modal))).getItemDefinitionConsumer();
        this.modal.refreshDataTypesList(includedModel);
        ((DMNIncludeModelsClient)Mockito.verify((Object)this.client)).loadItemDefinitionsByNamespace("model1", "://namespace1", listConsumer);
    }

    @Test
    public void testGetItemDefinitionConsumer() {
        ItemDefinition itemDefinition1 = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ItemDefinition itemDefinition2 = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        List<ItemDefinition> expectedNewItemDefinitions = Arrays.asList(itemDefinition1, itemDefinition2);
        this.modal.getItemDefinitionConsumer().accept(expectedNewItemDefinitions);
        ((EventSourceMock)Mockito.verify(this.refreshDataTypesListEvent)).fire(this.refreshDataTypesListArgumentCaptor.capture());
        List actualNewItemDefinitions = ((RefreshDataTypesListEvent)this.refreshDataTypesListArgumentCaptor.getValue()).getNewItemDefinitions();
        Assert.assertEquals(expectedNewItemDefinitions, (Object)actualNewItemDefinitions);
    }

    @Test
    public void testHide() {
        ((IncludedModelModalFake)((Object)Mockito.doNothing().when((Object)this.modal))).superHide();
        this.modal.hide();
        ((IncludedModelModalFake)((Object)Mockito.verify((Object)((Object)this.modal)))).superHide();
        ((DMNAssetsDropdown)Mockito.verify((Object)this.dropdown)).clear();
    }

    @Test
    public void testOnValueChangedWhenValuesAreValid() {
        ((IncludedModelModalFake)((Object)Mockito.doReturn((Object)true).when((Object)this.modal))).isValidValues();
        this.modal.getOnValueChanged().execute();
        ((IncludedModelModal.View)Mockito.verify((Object)this.view)).enableIncludeButton();
    }

    @Test
    public void testOnValueChangedWhenValuesAreNotValid() {
        ((IncludedModelModalFake)((Object)Mockito.doReturn((Object)false).when((Object)this.modal))).isValidValues();
        this.modal.getOnValueChanged().execute();
        ((IncludedModelModal.View)Mockito.verify((Object)this.view)).disableIncludeButton();
    }

    @Test
    public void testIsValidValuesWhenModelNameIsBlank() {
        Mockito.when((Object)this.view.getModelNameInput()).thenReturn((Object)"");
        Assert.assertFalse((boolean)this.modal.isValidValues());
    }

    @Test
    public void testIsValidValuesWhenDropDownIsNotPresent() {
        Mockito.when((Object)this.view.getModelNameInput()).thenReturn((Object)"name");
        Mockito.when((Object)this.dropdown.getValue()).thenReturn(Optional.empty());
        Assert.assertFalse((boolean)this.modal.isValidValues());
    }

    @Test
    public void testIsValidValuesWhenItReturnsTrue() {
        Mockito.when((Object)this.view.getModelNameInput()).thenReturn((Object)"name");
        Mockito.when((Object)this.dropdown.getValue()).thenReturn(Optional.of(Mockito.mock(KieAssetsDropdownItem.class)));
        Assert.assertTrue((boolean)this.modal.isValidValues());
    }

    @Test
    public void testCreateIncludedModel() {
        this.doTestCreateIncludedModel("file", "file");
    }

    @Test
    public void testCreateIncludedModelWithWhitespace() {
        this.doTestCreateIncludedModel("   file   ", "file");
    }

    private void doTestCreateIncludedModel(String name, String expectedName) {
        String value = "://namespace";
        String path = "/src/path/file";
        String anPackage = "path.file.com";
        Integer expectedDrgElementsCount = 2;
        Integer expectedDataTypesCount = 3;
        Map metaData = new Maps.Builder().put((Object)"path", (Object)"/src/path/file").put((Object)"import_type", (Object)DMNImportTypes.DMN.getDefaultNamespace()).put((Object)"drg_element_count", (Object)expectedDrgElementsCount.toString()).put((Object)"item_definition_count", (Object)expectedDataTypesCount.toString()).build();
        Mockito.when((Object)this.view.getModelNameInput()).thenReturn((Object)name);
        BaseIncludedModelActiveRecord includedModel = this.modal.createIncludedModel(new KieAssetsDropdownItem(name, "path.file.com", "://namespace", metaData));
        Assert.assertTrue((boolean)(includedModel instanceof DMNIncludedModelActiveRecord));
        DMNIncludedModelActiveRecord dmnIncludedModel = (DMNIncludedModelActiveRecord)includedModel;
        Assert.assertEquals((Object)expectedName, (Object)dmnIncludedModel.getName());
        Assert.assertEquals((Object)"://namespace", (Object)dmnIncludedModel.getNamespace());
        Assert.assertEquals((Object)"/src/path/file", (Object)dmnIncludedModel.getPath());
        Assert.assertEquals((Object)expectedDrgElementsCount, (Object)dmnIncludedModel.getDrgElementsCount());
        Assert.assertEquals((Object)expectedDataTypesCount, (Object)dmnIncludedModel.getDataTypesCount());
    }

    class IncludedModelModalFake
    extends IncludedModelModal {
        IncludedModelModalFake(IncludedModelModal.View view, DMNAssetsDropdown dropdown, ImportRecordEngine recordEngine) {
            super(view, dropdown, recordEngine, IncludedModelModalTest.this.client, (Event)IncludedModelModalTest.this.refreshDataTypesListEvent, (Event)IncludedModelModalTest.this.refreshDecisionComponentsEvent);
        }

        protected void setWidth(String width) {
        }
    }
}

