/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.modal.dropdown;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.IncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.PMMLIncludedModel;
import org.kie.workbench.common.dmn.api.property.dmn.LocationURI;
import org.kie.workbench.common.dmn.client.api.included.legacy.DMNIncludeModelsClient;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPageState;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsIndex;
import org.kie.workbench.common.dmn.client.editors.included.modal.dropdown.DMNAssetsDropdownItemsProvider;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItem;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNAssetsDropdownItemsProviderTest {
    @Mock
    private DMNIncludeModelsClient client;
    @Mock
    private IncludedModelsPageState pageState;
    @Mock
    private IncludedModelsIndex modelsIndex;
    @Mock
    private Consumer<List<IncludedModel>> wrappedConsumer;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private Path path;
    private DMNAssetsDropdownItemsProvider itemsProvider;

    @Before
    public void setup() {
        this.itemsProvider = (DMNAssetsDropdownItemsProvider)Mockito.spy((Object)new DMNAssetsDropdownItemsProvider(this.client, this.pageState, this.modelsIndex, this.sessionManager));
        ((DMNAssetsDropdownItemsProvider)Mockito.doReturn((Object)this.path).when((Object)this.itemsProvider)).getDMNModelPath();
    }

    @Test
    public void testGetItems() {
        Consumer<List> assetListConsumer = l -> {};
        ((DMNAssetsDropdownItemsProvider)Mockito.doReturn(this.wrappedConsumer).when((Object)this.itemsProvider)).wrap(assetListConsumer);
        this.itemsProvider.getItems(assetListConsumer);
        ((DMNIncludeModelsClient)Mockito.verify((Object)this.client)).loadModels((Path)ArgumentMatchers.eq((Object)this.path), (Consumer)ArgumentMatchers.eq(this.wrappedConsumer));
    }

    @Test
    public void testWrapDMNItems() {
        DMNIncludedModel includedModel1 = this.makeDMNIncludedModel(1);
        DMNIncludedModel includedModel2 = this.makeDMNIncludedModel(2);
        DMNIncludedModel includedModel3 = this.makeDMNIncludedModel(3);
        DMNIncludedModel includedModel4 = this.makeDMNIncludedModel(4);
        DMNIncludedModel includedModel5 = this.makeDMNIncludedModel(5);
        Import import1 = (Import)Mockito.mock(Import.class);
        Import import2 = (Import)Mockito.mock(Import.class);
        KieAssetsDropdownItem dropdownItem1 = (KieAssetsDropdownItem)Mockito.mock(KieAssetsDropdownItem.class);
        KieAssetsDropdownItem dropdownItem5 = (KieAssetsDropdownItem)Mockito.mock(KieAssetsDropdownItem.class);
        List<IncludedModel> t = Arrays.asList(includedModel1, includedModel2, includedModel3, includedModel4, includedModel5);
        Mockito.when((Object)import1.getNamespace()).thenReturn((Object)"://namespace3");
        Mockito.when((Object)import2.getNamespace()).thenReturn((Object)"://namespace4");
        Mockito.when((Object)this.modelsIndex.getIndexedImports()).thenReturn(Arrays.asList(import1, import2));
        Mockito.when((Object)this.pageState.getCurrentDiagramNamespace()).thenReturn((Object)"://namespace2");
        ((DMNAssetsDropdownItemsProvider)Mockito.doReturn((Object)dropdownItem1).when((Object)this.itemsProvider)).asKieAsset((IncludedModel)includedModel1);
        ((DMNAssetsDropdownItemsProvider)Mockito.doReturn((Object)dropdownItem5).when((Object)this.itemsProvider)).asKieAsset((IncludedModel)includedModel5);
        this.itemsProvider.wrap(actualList -> {
            List<KieAssetsDropdownItem> expectedList = Arrays.asList(dropdownItem1, dropdownItem5);
            Assert.assertEquals(expectedList, (Object)actualList);
        }).accept(t);
    }

    private DMNIncludedModel makeDMNIncludedModel(int id) {
        return this.makeDMNIncludedModel(id, 0, 0);
    }

    private DMNIncludedModel makeDMNIncludedModel(int id, int drgElementsCount, int itemDefinitionsCount) {
        return new DMNIncludedModel("name" + id, "com.kie.dmn", "/src/main/kie" + id, "://namespace" + id, DMNImportTypes.DMN.getDefaultNamespace(), Integer.valueOf(drgElementsCount), Integer.valueOf(itemDefinitionsCount));
    }

    @Test
    public void testWrapPMMLItems() {
        PMMLIncludedModel includedModel1 = this.makePMMLIncludedModel(1);
        PMMLIncludedModel includedModel2 = this.makePMMLIncludedModel(2);
        PMMLIncludedModel includedModel3 = this.makePMMLIncludedModel(3);
        PMMLIncludedModel includedModel4 = this.makePMMLIncludedModel(4);
        PMMLIncludedModel includedModel5 = this.makePMMLIncludedModel(5);
        Import import1 = (Import)Mockito.mock(Import.class);
        Import import2 = (Import)Mockito.mock(Import.class);
        LocationURI import1URI = new LocationURI("/src/main/kie3");
        LocationURI import2URI = new LocationURI("/src/main/kie4");
        KieAssetsDropdownItem dropdownItem1 = (KieAssetsDropdownItem)Mockito.mock(KieAssetsDropdownItem.class);
        KieAssetsDropdownItem dropdownItem2 = (KieAssetsDropdownItem)Mockito.mock(KieAssetsDropdownItem.class);
        KieAssetsDropdownItem dropdownItem5 = (KieAssetsDropdownItem)Mockito.mock(KieAssetsDropdownItem.class);
        List<IncludedModel> t = Arrays.asList(includedModel1, includedModel2, includedModel3, includedModel4, includedModel5);
        Mockito.when((Object)import1.getLocationURI()).thenReturn((Object)import1URI);
        Mockito.when((Object)import2.getLocationURI()).thenReturn((Object)import2URI);
        Mockito.when((Object)this.modelsIndex.getIndexedImports()).thenReturn(Arrays.asList(import1, import2));
        ((DMNAssetsDropdownItemsProvider)Mockito.doReturn((Object)dropdownItem1).when((Object)this.itemsProvider)).asKieAsset((IncludedModel)includedModel1);
        ((DMNAssetsDropdownItemsProvider)Mockito.doReturn((Object)dropdownItem2).when((Object)this.itemsProvider)).asKieAsset((IncludedModel)includedModel2);
        ((DMNAssetsDropdownItemsProvider)Mockito.doReturn((Object)dropdownItem5).when((Object)this.itemsProvider)).asKieAsset((IncludedModel)includedModel5);
        this.itemsProvider.wrap(actualList -> {
            List<KieAssetsDropdownItem> expectedList = Arrays.asList(dropdownItem1, dropdownItem2, dropdownItem5);
            Assert.assertEquals(expectedList, (Object)actualList);
        }).accept(t);
    }

    private PMMLIncludedModel makePMMLIncludedModel(int id) {
        return this.makePMMLIncludedModel(id, 0);
    }

    private PMMLIncludedModel makePMMLIncludedModel(int id, int modelCount) {
        return new PMMLIncludedModel("name" + id, "com.kie.pmml", "/src/main/kie" + id, DMNImportTypes.PMML.getDefaultNamespace(), Integer.valueOf(modelCount));
    }

    @Test
    public void testAsKieAssetForDMNIncludedModel() {
        DMNIncludedModel model = this.makeDMNIncludedModel(1, 2, 3);
        KieAssetsDropdownItem dropdownItem = this.itemsProvider.asKieAsset((IncludedModel)model);
        Assert.assertEquals((Object)model.getModelName(), (Object)dropdownItem.getText());
        Assert.assertEquals((Object)model.getModelPackage(), (Object)dropdownItem.getSubText());
        Assert.assertEquals((Object)model.getNamespace(), (Object)dropdownItem.getValue());
        Assert.assertEquals((Object)model.getPath(), dropdownItem.getMetaData().get("path"));
        Assert.assertEquals((Object)model.getImportType(), dropdownItem.getMetaData().get("import_type"));
        Assert.assertEquals((Object)model.getDrgElementsCount().toString(), dropdownItem.getMetaData().get("drg_element_count"));
        Assert.assertEquals((Object)model.getItemDefinitionsCount().toString(), dropdownItem.getMetaData().get("item_definition_count"));
    }

    @Test
    public void testAsKieAssetForPMMLIncludedModel() {
        PMMLIncludedModel model = this.makePMMLIncludedModel(1, 2);
        KieAssetsDropdownItem dropdownItem = this.itemsProvider.asKieAsset((IncludedModel)model);
        Assert.assertEquals((Object)model.getModelName(), (Object)dropdownItem.getText());
        Assert.assertEquals((Object)model.getModelPackage(), (Object)dropdownItem.getSubText());
        Assert.assertEquals((Object)model.getPath(), dropdownItem.getMetaData().get("path"));
        Assert.assertEquals((Object)model.getImportType(), dropdownItem.getMetaData().get("import_type"));
        Assert.assertEquals((Object)model.getModelCount().toString(), dropdownItem.getMetaData().get("pmml_model_count"));
    }
}

